@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cronExpressionForRecurrence Cron expression for an Auto-Tune maintenance schedule.
 * @property durations Configuration block for the duration of the Auto-Tune maintenance window.
 * @property startAt Date and time at which the Auto-Tune maintenance schedule starts in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 */
public data class GetDomainAutoTuneOptionMaintenanceSchedule(
    public val cronExpressionForRecurrence: String,
    public val durations: List<GetDomainAutoTuneOptionMaintenanceScheduleDuration>,
    public val startAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.GetDomainAutoTuneOptionMaintenanceSchedule): GetDomainAutoTuneOptionMaintenanceSchedule = GetDomainAutoTuneOptionMaintenanceSchedule(
            cronExpressionForRecurrence = javaType.cronExpressionForRecurrence(),
            durations = javaType.durations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticsearch.kotlin.outputs.GetDomainAutoTuneOptionMaintenanceScheduleDuration.Companion.toKotlin(args0)
                })
            }),
            startAt = javaType.startAt(),
        )
    }
}
