@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property coldStorageOptions Configuration block containing cold storage configuration.
 * @property dedicatedMasterCount Number of dedicated master nodes in the cluster.
 * @property dedicatedMasterEnabled Indicates whether dedicated master nodes are enabled for the cluster.
 * @property dedicatedMasterType Instance type of the dedicated master nodes in the cluster.
 * @property instanceCount Number of instances in the cluster.
 * @property instanceType Instance type of data nodes in the cluster.
 * @property warmCount The number of warm nodes in the cluster.
 * @property warmEnabled Warm storage is enabled.
 * @property warmType The instance type for the Elasticsearch cluster's warm nodes.
 * @property zoneAwarenessConfigs Configuration block containing zone awareness settings.
 * @property zoneAwarenessEnabled Indicates whether zone awareness is enabled.
 */
public data class GetDomainClusterConfig(
    public val coldStorageOptions: List<GetDomainClusterConfigColdStorageOption>,
    public val dedicatedMasterCount: Int,
    public val dedicatedMasterEnabled: Boolean,
    public val dedicatedMasterType: String,
    public val instanceCount: Int,
    public val instanceType: String,
    public val warmCount: Int,
    public val warmEnabled: Boolean,
    public val warmType: String,
    public val zoneAwarenessConfigs: List<GetDomainClusterConfigZoneAwarenessConfig>,
    public val zoneAwarenessEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.GetDomainClusterConfig): GetDomainClusterConfig = GetDomainClusterConfig(
            coldStorageOptions = javaType.coldStorageOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticsearch.kotlin.outputs.GetDomainClusterConfigColdStorageOption.Companion.toKotlin(args0)
                })
            }),
            dedicatedMasterCount = javaType.dedicatedMasterCount(),
            dedicatedMasterEnabled = javaType.dedicatedMasterEnabled(),
            dedicatedMasterType = javaType.dedicatedMasterType(),
            instanceCount = javaType.instanceCount(),
            instanceType = javaType.instanceType(),
            warmCount = javaType.warmCount(),
            warmEnabled = javaType.warmEnabled(),
            warmType = javaType.warmType(),
            zoneAwarenessConfigs = javaType.zoneAwarenessConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticsearch.kotlin.outputs.GetDomainClusterConfigZoneAwarenessConfig.Companion.toKotlin(args0)
                })
            }),
            zoneAwarenessEnabled = javaType.zoneAwarenessEnabled(),
        )
    }
}
