@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether node to node encryption is enabled.
 * @property kmsKeyId The KMS key id used to encrypt data at rest.
 */
public data class GetDomainEncryptionAtRest(
    public val enabled: Boolean,
    public val kmsKeyId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.GetDomainEncryptionAtRest): GetDomainEncryptionAtRest = GetDomainEncryptionAtRest(
            enabled = javaType.enabled(),
            kmsKeyId = javaType.kmsKeyId(),
        )
    }
}
