@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchLogGroupArn The CloudWatch Log Group where the logs are published.
 * @property enabled Whether node to node encryption is enabled.
 * @property logType The type of Elasticsearch log being published.
 */
public data class GetDomainLogPublishingOption(
    public val cloudwatchLogGroupArn: String,
    public val enabled: Boolean,
    public val logType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.GetDomainLogPublishingOption): GetDomainLogPublishingOption = GetDomainLogPublishingOption(
            cloudwatchLogGroupArn = javaType.cloudwatchLogGroupArn(),
            enabled = javaType.enabled(),
            logType = javaType.logType(),
        )
    }
}
