@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property availabilityZones The availability zones used by the domain.
 * @property securityGroupIds The security groups used by the domain.
 * @property subnetIds The subnets used by the domain.
 * @property vpcId The VPC used by the domain.
 */
public data class GetDomainVpcOption(
    public val availabilityZones: List<String>,
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.GetDomainVpcOption): GetDomainVpcOption = GetDomainVpcOption(
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
