@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin

import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineContentConfig
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineContentConfigPermission
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineNotifications
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineThumbnailConfig
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineThumbnailConfigPermission
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineContentConfig.Companion.toKotlin as pipelineContentConfigToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineContentConfigPermission.Companion.toKotlin as pipelineContentConfigPermissionToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineNotifications.Companion.toKotlin as pipelineNotificationsToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineThumbnailConfig.Companion.toKotlin as pipelineThumbnailConfigToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PipelineThumbnailConfigPermission.Companion.toKotlin as pipelineThumbnailConfigPermissionToKotlin

/**
 * Builder for [Pipeline].
 */
@PulumiTagMarker
public class PipelineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PipelineArgs = PipelineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PipelineArgsBuilder.() -> Unit) {
        val builder = PipelineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Pipeline {
        val builtJavaResource = com.pulumi.aws.elastictranscoder.Pipeline(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Pipeline(builtJavaResource)
    }
}

/**
 * Provides an Elastic Transcoder pipeline resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.elastictranscoder.Pipeline("bar", {
 *     inputBucket: inputBucket.id,
 *     name: "aws_elastictranscoder_pipeline_my_test_",
 *     role: testRole.arn,
 *     contentConfig: {
 *         bucket: contentBucket.id,
 *         storageClass: "Standard",
 *     },
 *     thumbnailConfig: {
 *         bucket: thumbBucket.id,
 *         storageClass: "Standard",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.elastictranscoder.Pipeline("bar",
 *     input_bucket=input_bucket["id"],
 *     name="aws_elastictranscoder_pipeline_my_test_",
 *     role=test_role["arn"],
 *     content_config={
 *         "bucket": content_bucket["id"],
 *         "storage_class": "Standard",
 *     },
 *     thumbnail_config={
 *         "bucket": thumb_bucket["id"],
 *         "storage_class": "Standard",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.ElasticTranscoder.Pipeline("bar", new()
 *     {
 *         InputBucket = inputBucket.Id,
 *         Name = "aws_elastictranscoder_pipeline_my_test_",
 *         Role = testRole.Arn,
 *         ContentConfig = new Aws.ElasticTranscoder.Inputs.PipelineContentConfigArgs
 *         {
 *             Bucket = contentBucket.Id,
 *             StorageClass = "Standard",
 *         },
 *         ThumbnailConfig = new Aws.ElasticTranscoder.Inputs.PipelineThumbnailConfigArgs
 *         {
 *             Bucket = thumbBucket.Id,
 *             StorageClass = "Standard",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elastictranscoder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elastictranscoder.NewPipeline(ctx, "bar", &elastictranscoder.PipelineArgs{
 * 			InputBucket: pulumi.Any(inputBucket.Id),
 * 			Name:        pulumi.String("aws_elastictranscoder_pipeline_my_test_"),
 * 			Role:        pulumi.Any(testRole.Arn),
 * 			ContentConfig: &elastictranscoder.PipelineContentConfigArgs{
 * 				Bucket:       pulumi.Any(contentBucket.Id),
 * 				StorageClass: pulumi.String("Standard"),
 * 			},
 * 			ThumbnailConfig: &elastictranscoder.PipelineThumbnailConfigArgs{
 * 				Bucket:       pulumi.Any(thumbBucket.Id),
 * 				StorageClass: pulumi.String("Standard"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elastictranscoder.Pipeline;
 * import com.pulumi.aws.elastictranscoder.PipelineArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PipelineContentConfigArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PipelineThumbnailConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Pipeline("bar", PipelineArgs.builder()
 *             .inputBucket(inputBucket.id())
 *             .name("aws_elastictranscoder_pipeline_my_test_")
 *             .role(testRole.arn())
 *             .contentConfig(PipelineContentConfigArgs.builder()
 *                 .bucket(contentBucket.id())
 *                 .storageClass("Standard")
 *                 .build())
 *             .thumbnailConfig(PipelineThumbnailConfigArgs.builder()
 *                 .bucket(thumbBucket.id())
 *                 .storageClass("Standard")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:elastictranscoder:Pipeline
 *     properties:
 *       inputBucket: ${inputBucket.id}
 *       name: aws_elastictranscoder_pipeline_my_test_
 *       role: ${testRole.arn}
 *       contentConfig:
 *         bucket: ${contentBucket.id}
 *         storageClass: Standard
 *       thumbnailConfig:
 *         bucket: ${thumbBucket.id}
 *         storageClass: Standard
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Elastic Transcoder pipelines using the `id`. For example:
 * ```sh
 * $ pulumi import aws:elastictranscoder/pipeline:Pipeline basic_pipeline 1407981661351-cttk8b
 * ```
 */
public class Pipeline internal constructor(
    override val javaResource: com.pulumi.aws.elastictranscoder.Pipeline,
) : KotlinCustomResource(javaResource, PipelineMapper) {
    /**
     * The ARN of the Elastictranscoder pipeline.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
     */
    public val awsKmsKeyArn: Output<String>?
        get() = javaResource.awsKmsKeyArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ContentConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. (documented below)
     */
    public val contentConfig: Output<PipelineContentConfig>
        get() = javaResource.contentConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                pipelineContentConfigToKotlin(args0)
            })
        })

    /**
     * The permissions for the `content_config` object. (documented below)
     */
    public val contentConfigPermissions: Output<List<PipelineContentConfigPermission>>?
        get() = javaResource.contentConfigPermissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        pipelineContentConfigPermissionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
     */
    public val inputBucket: Output<String>
        get() = javaResource.inputBucket().applyValue({ args0 -> args0 })

    /**
     * The name of the pipeline. Maximum 40 characters
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status. (documented below)
     */
    public val notifications: Output<PipelineNotifications>?
        get() = javaResource.notifications().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> pipelineNotificationsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Amazon S3 bucket in which you want Elastic Transcoder to save the transcoded files.
     */
    public val outputBucket: Output<String>
        get() = javaResource.outputBucket().applyValue({ args0 -> args0 })

    /**
     * The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
     */
    public val role: Output<String>
        get() = javaResource.role().applyValue({ args0 -> args0 })

    /**
     * The ThumbnailConfig object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. (documented below)
     */
    public val thumbnailConfig: Output<PipelineThumbnailConfig>
        get() = javaResource.thumbnailConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                pipelineThumbnailConfigToKotlin(args0)
            })
        })

    /**
     * The permissions for the `thumbnail_config` object. (documented below)
     * The `content_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save transcoded files and playlists: which
     * bucket to use, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config`. If you specify values for `content_config` and
     * `thumbnail_config`, omit the `output_bucket` object.
     */
    public val thumbnailConfigPermissions: Output<List<PipelineThumbnailConfigPermission>>?
        get() = javaResource.thumbnailConfigPermissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        pipelineThumbnailConfigPermissionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object PipelineMapper : ResourceMapper<Pipeline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elastictranscoder.Pipeline::class == javaResource::class

    override fun map(javaResource: Resource): Pipeline = Pipeline(
        javaResource as
            com.pulumi.aws.elastictranscoder.Pipeline,
    )
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Pipeline].
 */
public suspend fun pipeline(name: String, block: suspend PipelineResourceBuilder.() -> Unit): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Pipeline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun pipeline(name: String): Pipeline {
    val builder = PipelineResourceBuilder()
    builder.name(name)
    return builder.build()
}
