@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin

import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetAudio
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetAudioCodecOptions
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetThumbnails
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetVideo
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetVideoWatermark
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetAudio.Companion.toKotlin as presetAudioToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetAudioCodecOptions.Companion.toKotlin as presetAudioCodecOptionsToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetThumbnails.Companion.toKotlin as presetThumbnailsToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetVideo.Companion.toKotlin as presetVideoToKotlin
import com.pulumi.aws.elastictranscoder.kotlin.outputs.PresetVideoWatermark.Companion.toKotlin as presetVideoWatermarkToKotlin

/**
 * Builder for [Preset].
 */
@PulumiTagMarker
public class PresetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PresetArgs = PresetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PresetArgsBuilder.() -> Unit) {
        val builder = PresetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Preset {
        val builtJavaResource = com.pulumi.aws.elastictranscoder.Preset(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Preset(builtJavaResource)
    }
}

/**
 * Provides an Elastic Transcoder preset resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.elastictranscoder.Preset("bar", {
 *     container: "mp4",
 *     description: "Sample Preset",
 *     name: "sample_preset",
 *     audio: {
 *         audioPackingMode: "SingleTrack",
 *         bitRate: "96",
 *         channels: "2",
 *         codec: "AAC",
 *         sampleRate: "44100",
 *     },
 *     audioCodecOptions: {
 *         profile: "AAC-LC",
 *     },
 *     video: {
 *         bitRate: "1600",
 *         codec: "H.264",
 *         displayAspectRatio: "16:9",
 *         fixedGop: "false",
 *         frameRate: "auto",
 *         maxFrameRate: "60",
 *         keyframesMaxDist: "240",
 *         maxHeight: "auto",
 *         maxWidth: "auto",
 *         paddingPolicy: "Pad",
 *         sizingPolicy: "Fit",
 *     },
 *     videoCodecOptions: {
 *         Profile: "main",
 *         Level: "2.2",
 *         MaxReferenceFrames: "3",
 *         InterlacedMode: "Progressive",
 *         ColorSpaceConversionMode: "None",
 *     },
 *     videoWatermarks: [{
 *         id: "Test",
 *         maxWidth: "20%",
 *         maxHeight: "20%",
 *         sizingPolicy: "ShrinkToFit",
 *         horizontalAlign: "Right",
 *         horizontalOffset: "10px",
 *         verticalAlign: "Bottom",
 *         verticalOffset: "10px",
 *         opacity: "55.5",
 *         target: "Content",
 *     }],
 *     thumbnails: {
 *         format: "png",
 *         interval: "120",
 *         maxWidth: "auto",
 *         maxHeight: "auto",
 *         paddingPolicy: "Pad",
 *         sizingPolicy: "Fit",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.elastictranscoder.Preset("bar",
 *     container="mp4",
 *     description="Sample Preset",
 *     name="sample_preset",
 *     audio={
 *         "audio_packing_mode": "SingleTrack",
 *         "bit_rate": "96",
 *         "channels": "2",
 *         "codec": "AAC",
 *         "sample_rate": "44100",
 *     },
 *     audio_codec_options={
 *         "profile": "AAC-LC",
 *     },
 *     video={
 *         "bit_rate": "1600",
 *         "codec": "H.264",
 *         "display_aspect_ratio": "16:9",
 *         "fixed_gop": "false",
 *         "frame_rate": "auto",
 *         "max_frame_rate": "60",
 *         "keyframes_max_dist": "240",
 *         "max_height": "auto",
 *         "max_width": "auto",
 *         "padding_policy": "Pad",
 *         "sizing_policy": "Fit",
 *     },
 *     video_codec_options={
 *         "Profile": "main",
 *         "Level": "2.2",
 *         "MaxReferenceFrames": "3",
 *         "InterlacedMode": "Progressive",
 *         "ColorSpaceConversionMode": "None",
 *     },
 *     video_watermarks=[{
 *         "id": "Test",
 *         "max_width": "20%",
 *         "max_height": "20%",
 *         "sizing_policy": "ShrinkToFit",
 *         "horizontal_align": "Right",
 *         "horizontal_offset": "10px",
 *         "vertical_align": "Bottom",
 *         "vertical_offset": "10px",
 *         "opacity": "55.5",
 *         "target": "Content",
 *     }],
 *     thumbnails={
 *         "format": "png",
 *         "interval": "120",
 *         "max_width": "auto",
 *         "max_height": "auto",
 *         "padding_policy": "Pad",
 *         "sizing_policy": "Fit",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.ElasticTranscoder.Preset("bar", new()
 *     {
 *         Container = "mp4",
 *         Description = "Sample Preset",
 *         Name = "sample_preset",
 *         Audio = new Aws.ElasticTranscoder.Inputs.PresetAudioArgs
 *         {
 *             AudioPackingMode = "SingleTrack",
 *             BitRate = "96",
 *             Channels = "2",
 *             Codec = "AAC",
 *             SampleRate = "44100",
 *         },
 *         AudioCodecOptions = new Aws.ElasticTranscoder.Inputs.PresetAudioCodecOptionsArgs
 *         {
 *             Profile = "AAC-LC",
 *         },
 *         Video = new Aws.ElasticTranscoder.Inputs.PresetVideoArgs
 *         {
 *             BitRate = "1600",
 *             Codec = "H.264",
 *             DisplayAspectRatio = "16:9",
 *             FixedGop = "false",
 *             FrameRate = "auto",
 *             MaxFrameRate = "60",
 *             KeyframesMaxDist = "240",
 *             MaxHeight = "auto",
 *             MaxWidth = "auto",
 *             PaddingPolicy = "Pad",
 *             SizingPolicy = "Fit",
 *         },
 *         VideoCodecOptions =
 *         {
 *             { "Profile", "main" },
 *             { "Level", "2.2" },
 *             { "MaxReferenceFrames", "3" },
 *             { "InterlacedMode", "Progressive" },
 *             { "ColorSpaceConversionMode", "None" },
 *         },
 *         VideoWatermarks = new[]
 *         {
 *             new Aws.ElasticTranscoder.Inputs.PresetVideoWatermarkArgs
 *             {
 *                 Id = "Test",
 *                 MaxWidth = "20%",
 *                 MaxHeight = "20%",
 *                 SizingPolicy = "ShrinkToFit",
 *                 HorizontalAlign = "Right",
 *                 HorizontalOffset = "10px",
 *                 VerticalAlign = "Bottom",
 *                 VerticalOffset = "10px",
 *                 Opacity = "55.5",
 *                 Target = "Content",
 *             },
 *         },
 *         Thumbnails = new Aws.ElasticTranscoder.Inputs.PresetThumbnailsArgs
 *         {
 *             Format = "png",
 *             Interval = "120",
 *             MaxWidth = "auto",
 *             MaxHeight = "auto",
 *             PaddingPolicy = "Pad",
 *             SizingPolicy = "Fit",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elastictranscoder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elastictranscoder.NewPreset(ctx, "bar", &elastictranscoder.PresetArgs{
 * 			Container:   pulumi.String("mp4"),
 * 			Description: pulumi.String("Sample Preset"),
 * 			Name:        pulumi.String("sample_preset"),
 * 			Audio: &elastictranscoder.PresetAudioArgs{
 * 				AudioPackingMode: pulumi.String("SingleTrack"),
 * 				BitRate:          pulumi.String("96"),
 * 				Channels:         pulumi.String("2"),
 * 				Codec:            pulumi.String("AAC"),
 * 				SampleRate:       pulumi.String("44100"),
 * 			},
 * 			AudioCodecOptions: &elastictranscoder.PresetAudioCodecOptionsArgs{
 * 				Profile: pulumi.String("AAC-LC"),
 * 			},
 * 			Video: &elastictranscoder.PresetVideoArgs{
 * 				BitRate:            pulumi.String("1600"),
 * 				Codec:              pulumi.String("H.264"),
 * 				DisplayAspectRatio: pulumi.String("16:9"),
 * 				FixedGop:           pulumi.String("false"),
 * 				FrameRate:          pulumi.String("auto"),
 * 				MaxFrameRate:       pulumi.String("60"),
 * 				KeyframesMaxDist:   pulumi.String("240"),
 * 				MaxHeight:          pulumi.String("auto"),
 * 				MaxWidth:           pulumi.String("auto"),
 * 				PaddingPolicy:      pulumi.String("Pad"),
 * 				SizingPolicy:       pulumi.String("Fit"),
 * 			},
 * 			VideoCodecOptions: pulumi.StringMap{
 * 				"Profile":                  pulumi.String("main"),
 * 				"Level":                    pulumi.String("2.2"),
 * 				"MaxReferenceFrames":       pulumi.String("3"),
 * 				"InterlacedMode":           pulumi.String("Progressive"),
 * 				"ColorSpaceConversionMode": pulumi.String("None"),
 * 			},
 * 			VideoWatermarks: elastictranscoder.PresetVideoWatermarkArray{
 * 				&elastictranscoder.PresetVideoWatermarkArgs{
 * 					Id:               pulumi.String("Test"),
 * 					MaxWidth:         pulumi.String("20%"),
 * 					MaxHeight:        pulumi.String("20%"),
 * 					SizingPolicy:     pulumi.String("ShrinkToFit"),
 * 					HorizontalAlign:  pulumi.String("Right"),
 * 					HorizontalOffset: pulumi.String("10px"),
 * 					VerticalAlign:    pulumi.String("Bottom"),
 * 					VerticalOffset:   pulumi.String("10px"),
 * 					Opacity:          pulumi.String("55.5"),
 * 					Target:           pulumi.String("Content"),
 * 				},
 * 			},
 * 			Thumbnails: &elastictranscoder.PresetThumbnailsArgs{
 * 				Format:        pulumi.String("png"),
 * 				Interval:      pulumi.String("120"),
 * 				MaxWidth:      pulumi.String("auto"),
 * 				MaxHeight:     pulumi.String("auto"),
 * 				PaddingPolicy: pulumi.String("Pad"),
 * 				SizingPolicy:  pulumi.String("Fit"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elastictranscoder.Preset;
 * import com.pulumi.aws.elastictranscoder.PresetArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetAudioArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetAudioCodecOptionsArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetVideoArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetVideoWatermarkArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetThumbnailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Preset("bar", PresetArgs.builder()
 *             .container("mp4")
 *             .description("Sample Preset")
 *             .name("sample_preset")
 *             .audio(PresetAudioArgs.builder()
 *                 .audioPackingMode("SingleTrack")
 *                 .bitRate(96)
 *                 .channels(2)
 *                 .codec("AAC")
 *                 .sampleRate(44100)
 *                 .build())
 *             .audioCodecOptions(PresetAudioCodecOptionsArgs.builder()
 *                 .profile("AAC-LC")
 *                 .build())
 *             .video(PresetVideoArgs.builder()
 *                 .bitRate("1600")
 *                 .codec("H.264")
 *                 .displayAspectRatio("16:9")
 *                 .fixedGop("false")
 *                 .frameRate("auto")
 *                 .maxFrameRate("60")
 *                 .keyframesMaxDist(240)
 *                 .maxHeight("auto")
 *                 .maxWidth("auto")
 *                 .paddingPolicy("Pad")
 *                 .sizingPolicy("Fit")
 *                 .build())
 *             .videoCodecOptions(Map.ofEntries(
 *                 Map.entry("Profile", "main"),
 *                 Map.entry("Level", "2.2"),
 *                 Map.entry("MaxReferenceFrames", 3),
 *                 Map.entry("InterlacedMode", "Progressive"),
 *                 Map.entry("ColorSpaceConversionMode", "None")
 *             ))
 *             .videoWatermarks(PresetVideoWatermarkArgs.builder()
 *                 .id("Test")
 *                 .maxWidth("20%")
 *                 .maxHeight("20%")
 *                 .sizingPolicy("ShrinkToFit")
 *                 .horizontalAlign("Right")
 *                 .horizontalOffset("10px")
 *                 .verticalAlign("Bottom")
 *                 .verticalOffset("10px")
 *                 .opacity("55.5")
 *                 .target("Content")
 *                 .build())
 *             .thumbnails(PresetThumbnailsArgs.builder()
 *                 .format("png")
 *                 .interval(120)
 *                 .maxWidth("auto")
 *                 .maxHeight("auto")
 *                 .paddingPolicy("Pad")
 *                 .sizingPolicy("Fit")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:elastictranscoder:Preset
 *     properties:
 *       container: mp4
 *       description: Sample Preset
 *       name: sample_preset
 *       audio:
 *         audioPackingMode: SingleTrack
 *         bitRate: 96
 *         channels: 2
 *         codec: AAC
 *         sampleRate: 44100
 *       audioCodecOptions:
 *         profile: AAC-LC
 *       video:
 *         bitRate: '1600'
 *         codec: H.264
 *         displayAspectRatio: 16:9
 *         fixedGop: 'false'
 *         frameRate: auto
 *         maxFrameRate: '60'
 *         keyframesMaxDist: 240
 *         maxHeight: auto
 *         maxWidth: auto
 *         paddingPolicy: Pad
 *         sizingPolicy: Fit
 *       videoCodecOptions:
 *         Profile: main
 *         Level: '2.2'
 *         MaxReferenceFrames: 3
 *         InterlacedMode: Progressive
 *         ColorSpaceConversionMode: None
 *       videoWatermarks:
 *         - id: Test
 *           maxWidth: 20%
 *           maxHeight: 20%
 *           sizingPolicy: ShrinkToFit
 *           horizontalAlign: Right
 *           horizontalOffset: 10px
 *           verticalAlign: Bottom
 *           verticalOffset: 10px
 *           opacity: '55.5'
 *           target: Content
 *       thumbnails:
 *         format: png
 *         interval: 120
 *         maxWidth: auto
 *         maxHeight: auto
 *         paddingPolicy: Pad
 *         sizingPolicy: Fit
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Elastic Transcoder presets using the `id`. For example:
 * ```sh
 * $ pulumi import aws:elastictranscoder/preset:Preset basic_preset 1407981661351-cttk8b
 * ```
 */
public class Preset internal constructor(
    override val javaResource: com.pulumi.aws.elastictranscoder.Preset,
) : KotlinCustomResource(javaResource, PresetMapper) {
    /**
     * Amazon Resource Name (ARN) of the Elastic Transcoder Preset.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Audio parameters object (documented below).
     */
    public val audio: Output<PresetAudio>?
        get() = javaResource.audio().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    presetAudioToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Codec options for the audio parameters (documented below)
     */
    public val audioCodecOptions: Output<PresetAudioCodecOptions>
        get() = javaResource.audioCodecOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                presetAudioCodecOptionsToKotlin(args0)
            })
        })

    /**
     * The container type for the output file. Valid values are `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
     */
    public val container: Output<String>
        get() = javaResource.container().applyValue({ args0 -> args0 })

    /**
     * A description of the preset (maximum 255 characters)
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the preset. (maximum 40 characters)
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Thumbnail parameters object (documented below)
     */
    public val thumbnails: Output<PresetThumbnails>?
        get() = javaResource.thumbnails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    presetThumbnailsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Video parameters object (documented below)
     */
    public val video: Output<PresetVideo>?
        get() = javaResource.video().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    presetVideoToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Codec options for the video parameters
     */
    public val videoCodecOptions: Output<Map<String, String>>?
        get() = javaResource.videoCodecOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Watermark parameters for the video parameters (documented below)
     */
    public val videoWatermarks: Output<List<PresetVideoWatermark>>?
        get() = javaResource.videoWatermarks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        presetVideoWatermarkToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object PresetMapper : ResourceMapper<Preset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elastictranscoder.Preset::class == javaResource::class

    override fun map(javaResource: Resource): Preset = Preset(
        javaResource as
            com.pulumi.aws.elastictranscoder.Preset,
    )
}

/**
 * @see [Preset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Preset].
 */
public suspend fun preset(name: String, block: suspend PresetResourceBuilder.() -> Unit): Preset {
    val builder = PresetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Preset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun preset(name: String): Preset {
    val builder = PresetResourceBuilder()
    builder.name(name)
    return builder.build()
}
