@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin

import com.pulumi.aws.elastictranscoder.PresetArgs.builder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetAudioArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetAudioArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetAudioCodecOptionsArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetAudioCodecOptionsArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetThumbnailsArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetThumbnailsArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetVideoArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetVideoArgsBuilder
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetVideoWatermarkArgs
import com.pulumi.aws.elastictranscoder.kotlin.inputs.PresetVideoWatermarkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Transcoder preset resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.elastictranscoder.Preset("bar", {
 *     container: "mp4",
 *     description: "Sample Preset",
 *     name: "sample_preset",
 *     audio: {
 *         audioPackingMode: "SingleTrack",
 *         bitRate: "96",
 *         channels: "2",
 *         codec: "AAC",
 *         sampleRate: "44100",
 *     },
 *     audioCodecOptions: {
 *         profile: "AAC-LC",
 *     },
 *     video: {
 *         bitRate: "1600",
 *         codec: "H.264",
 *         displayAspectRatio: "16:9",
 *         fixedGop: "false",
 *         frameRate: "auto",
 *         maxFrameRate: "60",
 *         keyframesMaxDist: "240",
 *         maxHeight: "auto",
 *         maxWidth: "auto",
 *         paddingPolicy: "Pad",
 *         sizingPolicy: "Fit",
 *     },
 *     videoCodecOptions: {
 *         Profile: "main",
 *         Level: "2.2",
 *         MaxReferenceFrames: "3",
 *         InterlacedMode: "Progressive",
 *         ColorSpaceConversionMode: "None",
 *     },
 *     videoWatermarks: [{
 *         id: "Test",
 *         maxWidth: "20%",
 *         maxHeight: "20%",
 *         sizingPolicy: "ShrinkToFit",
 *         horizontalAlign: "Right",
 *         horizontalOffset: "10px",
 *         verticalAlign: "Bottom",
 *         verticalOffset: "10px",
 *         opacity: "55.5",
 *         target: "Content",
 *     }],
 *     thumbnails: {
 *         format: "png",
 *         interval: "120",
 *         maxWidth: "auto",
 *         maxHeight: "auto",
 *         paddingPolicy: "Pad",
 *         sizingPolicy: "Fit",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.elastictranscoder.Preset("bar",
 *     container="mp4",
 *     description="Sample Preset",
 *     name="sample_preset",
 *     audio={
 *         "audio_packing_mode": "SingleTrack",
 *         "bit_rate": "96",
 *         "channels": "2",
 *         "codec": "AAC",
 *         "sample_rate": "44100",
 *     },
 *     audio_codec_options={
 *         "profile": "AAC-LC",
 *     },
 *     video={
 *         "bit_rate": "1600",
 *         "codec": "H.264",
 *         "display_aspect_ratio": "16:9",
 *         "fixed_gop": "false",
 *         "frame_rate": "auto",
 *         "max_frame_rate": "60",
 *         "keyframes_max_dist": "240",
 *         "max_height": "auto",
 *         "max_width": "auto",
 *         "padding_policy": "Pad",
 *         "sizing_policy": "Fit",
 *     },
 *     video_codec_options={
 *         "Profile": "main",
 *         "Level": "2.2",
 *         "MaxReferenceFrames": "3",
 *         "InterlacedMode": "Progressive",
 *         "ColorSpaceConversionMode": "None",
 *     },
 *     video_watermarks=[{
 *         "id": "Test",
 *         "max_width": "20%",
 *         "max_height": "20%",
 *         "sizing_policy": "ShrinkToFit",
 *         "horizontal_align": "Right",
 *         "horizontal_offset": "10px",
 *         "vertical_align": "Bottom",
 *         "vertical_offset": "10px",
 *         "opacity": "55.5",
 *         "target": "Content",
 *     }],
 *     thumbnails={
 *         "format": "png",
 *         "interval": "120",
 *         "max_width": "auto",
 *         "max_height": "auto",
 *         "padding_policy": "Pad",
 *         "sizing_policy": "Fit",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.ElasticTranscoder.Preset("bar", new()
 *     {
 *         Container = "mp4",
 *         Description = "Sample Preset",
 *         Name = "sample_preset",
 *         Audio = new Aws.ElasticTranscoder.Inputs.PresetAudioArgs
 *         {
 *             AudioPackingMode = "SingleTrack",
 *             BitRate = "96",
 *             Channels = "2",
 *             Codec = "AAC",
 *             SampleRate = "44100",
 *         },
 *         AudioCodecOptions = new Aws.ElasticTranscoder.Inputs.PresetAudioCodecOptionsArgs
 *         {
 *             Profile = "AAC-LC",
 *         },
 *         Video = new Aws.ElasticTranscoder.Inputs.PresetVideoArgs
 *         {
 *             BitRate = "1600",
 *             Codec = "H.264",
 *             DisplayAspectRatio = "16:9",
 *             FixedGop = "false",
 *             FrameRate = "auto",
 *             MaxFrameRate = "60",
 *             KeyframesMaxDist = "240",
 *             MaxHeight = "auto",
 *             MaxWidth = "auto",
 *             PaddingPolicy = "Pad",
 *             SizingPolicy = "Fit",
 *         },
 *         VideoCodecOptions =
 *         {
 *             { "Profile", "main" },
 *             { "Level", "2.2" },
 *             { "MaxReferenceFrames", "3" },
 *             { "InterlacedMode", "Progressive" },
 *             { "ColorSpaceConversionMode", "None" },
 *         },
 *         VideoWatermarks = new[]
 *         {
 *             new Aws.ElasticTranscoder.Inputs.PresetVideoWatermarkArgs
 *             {
 *                 Id = "Test",
 *                 MaxWidth = "20%",
 *                 MaxHeight = "20%",
 *                 SizingPolicy = "ShrinkToFit",
 *                 HorizontalAlign = "Right",
 *                 HorizontalOffset = "10px",
 *                 VerticalAlign = "Bottom",
 *                 VerticalOffset = "10px",
 *                 Opacity = "55.5",
 *                 Target = "Content",
 *             },
 *         },
 *         Thumbnails = new Aws.ElasticTranscoder.Inputs.PresetThumbnailsArgs
 *         {
 *             Format = "png",
 *             Interval = "120",
 *             MaxWidth = "auto",
 *             MaxHeight = "auto",
 *             PaddingPolicy = "Pad",
 *             SizingPolicy = "Fit",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elastictranscoder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elastictranscoder.NewPreset(ctx, "bar", &elastictranscoder.PresetArgs{
 * 			Container:   pulumi.String("mp4"),
 * 			Description: pulumi.String("Sample Preset"),
 * 			Name:        pulumi.String("sample_preset"),
 * 			Audio: &elastictranscoder.PresetAudioArgs{
 * 				AudioPackingMode: pulumi.String("SingleTrack"),
 * 				BitRate:          pulumi.String("96"),
 * 				Channels:         pulumi.String("2"),
 * 				Codec:            pulumi.String("AAC"),
 * 				SampleRate:       pulumi.String("44100"),
 * 			},
 * 			AudioCodecOptions: &elastictranscoder.PresetAudioCodecOptionsArgs{
 * 				Profile: pulumi.String("AAC-LC"),
 * 			},
 * 			Video: &elastictranscoder.PresetVideoArgs{
 * 				BitRate:            pulumi.String("1600"),
 * 				Codec:              pulumi.String("H.264"),
 * 				DisplayAspectRatio: pulumi.String("16:9"),
 * 				FixedGop:           pulumi.String("false"),
 * 				FrameRate:          pulumi.String("auto"),
 * 				MaxFrameRate:       pulumi.String("60"),
 * 				KeyframesMaxDist:   pulumi.String("240"),
 * 				MaxHeight:          pulumi.String("auto"),
 * 				MaxWidth:           pulumi.String("auto"),
 * 				PaddingPolicy:      pulumi.String("Pad"),
 * 				SizingPolicy:       pulumi.String("Fit"),
 * 			},
 * 			VideoCodecOptions: pulumi.StringMap{
 * 				"Profile":                  pulumi.String("main"),
 * 				"Level":                    pulumi.String("2.2"),
 * 				"MaxReferenceFrames":       pulumi.String("3"),
 * 				"InterlacedMode":           pulumi.String("Progressive"),
 * 				"ColorSpaceConversionMode": pulumi.String("None"),
 * 			},
 * 			VideoWatermarks: elastictranscoder.PresetVideoWatermarkArray{
 * 				&elastictranscoder.PresetVideoWatermarkArgs{
 * 					Id:               pulumi.String("Test"),
 * 					MaxWidth:         pulumi.String("20%"),
 * 					MaxHeight:        pulumi.String("20%"),
 * 					SizingPolicy:     pulumi.String("ShrinkToFit"),
 * 					HorizontalAlign:  pulumi.String("Right"),
 * 					HorizontalOffset: pulumi.String("10px"),
 * 					VerticalAlign:    pulumi.String("Bottom"),
 * 					VerticalOffset:   pulumi.String("10px"),
 * 					Opacity:          pulumi.String("55.5"),
 * 					Target:           pulumi.String("Content"),
 * 				},
 * 			},
 * 			Thumbnails: &elastictranscoder.PresetThumbnailsArgs{
 * 				Format:        pulumi.String("png"),
 * 				Interval:      pulumi.String("120"),
 * 				MaxWidth:      pulumi.String("auto"),
 * 				MaxHeight:     pulumi.String("auto"),
 * 				PaddingPolicy: pulumi.String("Pad"),
 * 				SizingPolicy:  pulumi.String("Fit"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elastictranscoder.Preset;
 * import com.pulumi.aws.elastictranscoder.PresetArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetAudioArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetAudioCodecOptionsArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetVideoArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetVideoWatermarkArgs;
 * import com.pulumi.aws.elastictranscoder.inputs.PresetThumbnailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Preset("bar", PresetArgs.builder()
 *             .container("mp4")
 *             .description("Sample Preset")
 *             .name("sample_preset")
 *             .audio(PresetAudioArgs.builder()
 *                 .audioPackingMode("SingleTrack")
 *                 .bitRate(96)
 *                 .channels(2)
 *                 .codec("AAC")
 *                 .sampleRate(44100)
 *                 .build())
 *             .audioCodecOptions(PresetAudioCodecOptionsArgs.builder()
 *                 .profile("AAC-LC")
 *                 .build())
 *             .video(PresetVideoArgs.builder()
 *                 .bitRate("1600")
 *                 .codec("H.264")
 *                 .displayAspectRatio("16:9")
 *                 .fixedGop("false")
 *                 .frameRate("auto")
 *                 .maxFrameRate("60")
 *                 .keyframesMaxDist(240)
 *                 .maxHeight("auto")
 *                 .maxWidth("auto")
 *                 .paddingPolicy("Pad")
 *                 .sizingPolicy("Fit")
 *                 .build())
 *             .videoCodecOptions(Map.ofEntries(
 *                 Map.entry("Profile", "main"),
 *                 Map.entry("Level", "2.2"),
 *                 Map.entry("MaxReferenceFrames", 3),
 *                 Map.entry("InterlacedMode", "Progressive"),
 *                 Map.entry("ColorSpaceConversionMode", "None")
 *             ))
 *             .videoWatermarks(PresetVideoWatermarkArgs.builder()
 *                 .id("Test")
 *                 .maxWidth("20%")
 *                 .maxHeight("20%")
 *                 .sizingPolicy("ShrinkToFit")
 *                 .horizontalAlign("Right")
 *                 .horizontalOffset("10px")
 *                 .verticalAlign("Bottom")
 *                 .verticalOffset("10px")
 *                 .opacity("55.5")
 *                 .target("Content")
 *                 .build())
 *             .thumbnails(PresetThumbnailsArgs.builder()
 *                 .format("png")
 *                 .interval(120)
 *                 .maxWidth("auto")
 *                 .maxHeight("auto")
 *                 .paddingPolicy("Pad")
 *                 .sizingPolicy("Fit")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:elastictranscoder:Preset
 *     properties:
 *       container: mp4
 *       description: Sample Preset
 *       name: sample_preset
 *       audio:
 *         audioPackingMode: SingleTrack
 *         bitRate: 96
 *         channels: 2
 *         codec: AAC
 *         sampleRate: 44100
 *       audioCodecOptions:
 *         profile: AAC-LC
 *       video:
 *         bitRate: '1600'
 *         codec: H.264
 *         displayAspectRatio: 16:9
 *         fixedGop: 'false'
 *         frameRate: auto
 *         maxFrameRate: '60'
 *         keyframesMaxDist: 240
 *         maxHeight: auto
 *         maxWidth: auto
 *         paddingPolicy: Pad
 *         sizingPolicy: Fit
 *       videoCodecOptions:
 *         Profile: main
 *         Level: '2.2'
 *         MaxReferenceFrames: 3
 *         InterlacedMode: Progressive
 *         ColorSpaceConversionMode: None
 *       videoWatermarks:
 *         - id: Test
 *           maxWidth: 20%
 *           maxHeight: 20%
 *           sizingPolicy: ShrinkToFit
 *           horizontalAlign: Right
 *           horizontalOffset: 10px
 *           verticalAlign: Bottom
 *           verticalOffset: 10px
 *           opacity: '55.5'
 *           target: Content
 *       thumbnails:
 *         format: png
 *         interval: 120
 *         maxWidth: auto
 *         maxHeight: auto
 *         paddingPolicy: Pad
 *         sizingPolicy: Fit
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Elastic Transcoder presets using the `id`. For example:
 * ```sh
 * $ pulumi import aws:elastictranscoder/preset:Preset basic_preset 1407981661351-cttk8b
 * ```
 * @property audio Audio parameters object (documented below).
 * @property audioCodecOptions Codec options for the audio parameters (documented below)
 * @property container The container type for the output file. Valid values are `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
 * @property description A description of the preset (maximum 255 characters)
 * @property name The name of the preset. (maximum 40 characters)
 * @property thumbnails Thumbnail parameters object (documented below)
 * @property type
 * @property video Video parameters object (documented below)
 * @property videoCodecOptions Codec options for the video parameters
 * @property videoWatermarks Watermark parameters for the video parameters (documented below)
 */
public data class PresetArgs(
    public val audio: Output<PresetAudioArgs>? = null,
    public val audioCodecOptions: Output<PresetAudioCodecOptionsArgs>? = null,
    public val container: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val thumbnails: Output<PresetThumbnailsArgs>? = null,
    public val type: Output<String>? = null,
    public val video: Output<PresetVideoArgs>? = null,
    public val videoCodecOptions: Output<Map<String, String>>? = null,
    public val videoWatermarks: Output<List<PresetVideoWatermarkArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.PresetArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.PresetArgs =
        com.pulumi.aws.elastictranscoder.PresetArgs.builder()
            .audio(audio?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .audioCodecOptions(audioCodecOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .container(container?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .thumbnails(thumbnails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 }))
            .video(video?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .videoCodecOptions(
                videoCodecOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .videoWatermarks(
                videoWatermarks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PresetArgs].
 */
@PulumiTagMarker
public class PresetArgsBuilder internal constructor() {
    private var audio: Output<PresetAudioArgs>? = null

    private var audioCodecOptions: Output<PresetAudioCodecOptionsArgs>? = null

    private var container: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var thumbnails: Output<PresetThumbnailsArgs>? = null

    private var type: Output<String>? = null

    private var video: Output<PresetVideoArgs>? = null

    private var videoCodecOptions: Output<Map<String, String>>? = null

    private var videoWatermarks: Output<List<PresetVideoWatermarkArgs>>? = null

    /**
     * @param value Audio parameters object (documented below).
     */
    @JvmName("yepcfhyfcoquncei")
    public suspend fun audio(`value`: Output<PresetAudioArgs>) {
        this.audio = value
    }

    /**
     * @param value Codec options for the audio parameters (documented below)
     */
    @JvmName("wwmosokrmgluddgi")
    public suspend fun audioCodecOptions(`value`: Output<PresetAudioCodecOptionsArgs>) {
        this.audioCodecOptions = value
    }

    /**
     * @param value The container type for the output file. Valid values are `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
     */
    @JvmName("rklywporswfusfib")
    public suspend fun container(`value`: Output<String>) {
        this.container = value
    }

    /**
     * @param value A description of the preset (maximum 255 characters)
     */
    @JvmName("sfmegdfwyrdtqmsv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the preset. (maximum 40 characters)
     */
    @JvmName("ainrxbrwnwjheuop")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Thumbnail parameters object (documented below)
     */
    @JvmName("kgjalepgqahhbpqv")
    public suspend fun thumbnails(`value`: Output<PresetThumbnailsArgs>) {
        this.thumbnails = value
    }

    /**
     * @param value
     */
    @JvmName("fcdklvstqsklvqqj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Video parameters object (documented below)
     */
    @JvmName("cwutibdwubfskekn")
    public suspend fun video(`value`: Output<PresetVideoArgs>) {
        this.video = value
    }

    /**
     * @param value Codec options for the video parameters
     */
    @JvmName("pgpqhlekwqphkodw")
    public suspend fun videoCodecOptions(`value`: Output<Map<String, String>>) {
        this.videoCodecOptions = value
    }

    /**
     * @param value Watermark parameters for the video parameters (documented below)
     */
    @JvmName("vbnyghfinhpysxbw")
    public suspend fun videoWatermarks(`value`: Output<List<PresetVideoWatermarkArgs>>) {
        this.videoWatermarks = value
    }

    @JvmName("oaucmrcpoyxxxmdv")
    public suspend fun videoWatermarks(vararg values: Output<PresetVideoWatermarkArgs>) {
        this.videoWatermarks = Output.all(values.asList())
    }

    /**
     * @param values Watermark parameters for the video parameters (documented below)
     */
    @JvmName("wwdqfkqfwtolkisi")
    public suspend fun videoWatermarks(values: List<Output<PresetVideoWatermarkArgs>>) {
        this.videoWatermarks = Output.all(values)
    }

    /**
     * @param value Audio parameters object (documented below).
     */
    @JvmName("wvrgdlhscatorgea")
    public suspend fun audio(`value`: PresetAudioArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audio = mapped
    }

    /**
     * @param argument Audio parameters object (documented below).
     */
    @JvmName("vintofpodlbcpyta")
    public suspend fun audio(argument: suspend PresetAudioArgsBuilder.() -> Unit) {
        val toBeMapped = PresetAudioArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.audio = mapped
    }

    /**
     * @param value Codec options for the audio parameters (documented below)
     */
    @JvmName("ocvqelvhtedggvux")
    public suspend fun audioCodecOptions(`value`: PresetAudioCodecOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioCodecOptions = mapped
    }

    /**
     * @param argument Codec options for the audio parameters (documented below)
     */
    @JvmName("jwrhybldboqlfjji")
    public suspend fun audioCodecOptions(argument: suspend PresetAudioCodecOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = PresetAudioCodecOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.audioCodecOptions = mapped
    }

    /**
     * @param value The container type for the output file. Valid values are `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
     */
    @JvmName("dpsflisrclibcljv")
    public suspend fun container(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value A description of the preset (maximum 255 characters)
     */
    @JvmName("aknghyhiyxhhttss")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the preset. (maximum 40 characters)
     */
    @JvmName("skxcvcmlnlsftced")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Thumbnail parameters object (documented below)
     */
    @JvmName("neouhudfpothvkny")
    public suspend fun thumbnails(`value`: PresetThumbnailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbnails = mapped
    }

    /**
     * @param argument Thumbnail parameters object (documented below)
     */
    @JvmName("ylltxjbqahudkfmr")
    public suspend fun thumbnails(argument: suspend PresetThumbnailsArgsBuilder.() -> Unit) {
        val toBeMapped = PresetThumbnailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.thumbnails = mapped
    }

    /**
     * @param value
     */
    @JvmName("ditnkfbskndbskkv")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Video parameters object (documented below)
     */
    @JvmName("cxkksiymmccbsxsy")
    public suspend fun video(`value`: PresetVideoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.video = mapped
    }

    /**
     * @param argument Video parameters object (documented below)
     */
    @JvmName("teywlysnovfnkpau")
    public suspend fun video(argument: suspend PresetVideoArgsBuilder.() -> Unit) {
        val toBeMapped = PresetVideoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.video = mapped
    }

    /**
     * @param value Codec options for the video parameters
     */
    @JvmName("lxhonynxagtgkhww")
    public suspend fun videoCodecOptions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoCodecOptions = mapped
    }

    /**
     * @param values Codec options for the video parameters
     */
    @JvmName("qkquiwycngvugimg")
    public fun videoCodecOptions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.videoCodecOptions = mapped
    }

    /**
     * @param value Watermark parameters for the video parameters (documented below)
     */
    @JvmName("qreulhwcvpvpflhk")
    public suspend fun videoWatermarks(`value`: List<PresetVideoWatermarkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoWatermarks = mapped
    }

    /**
     * @param argument Watermark parameters for the video parameters (documented below)
     */
    @JvmName("fwsrpdlwgvdholdu")
    public suspend fun videoWatermarks(argument: List<suspend PresetVideoWatermarkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PresetVideoWatermarkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.videoWatermarks = mapped
    }

    /**
     * @param argument Watermark parameters for the video parameters (documented below)
     */
    @JvmName("jikrnfbubrqxokeu")
    public suspend fun videoWatermarks(vararg argument: suspend PresetVideoWatermarkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PresetVideoWatermarkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.videoWatermarks = mapped
    }

    /**
     * @param argument Watermark parameters for the video parameters (documented below)
     */
    @JvmName("qqsggmwoncqsmilg")
    public suspend fun videoWatermarks(argument: suspend PresetVideoWatermarkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PresetVideoWatermarkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.videoWatermarks = mapped
    }

    /**
     * @param values Watermark parameters for the video parameters (documented below)
     */
    @JvmName("hirahnkqcubdpjjb")
    public suspend fun videoWatermarks(vararg values: PresetVideoWatermarkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.videoWatermarks = mapped
    }

    internal fun build(): PresetArgs = PresetArgs(
        audio = audio,
        audioCodecOptions = audioCodecOptions,
        container = container,
        description = description,
        name = name,
        thumbnails = thumbnails,
        type = type,
        video = video,
        videoCodecOptions = videoCodecOptions,
        videoWatermarks = videoWatermarks,
    )
}
