@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.inputs

import com.pulumi.aws.elastictranscoder.inputs.PipelineContentConfigPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accesses The permission that you want to give to the AWS user that you specified in `content_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
 * @property grantee The AWS user or group that you want to have access to transcoded files and playlists.
 * @property granteeType Specify the type of value that appears in the `content_config_permissions.grantee` object. Valid values are `Canonical`, `Email` or `Group`.
 */
public data class PipelineContentConfigPermissionArgs(
    public val accesses: Output<List<String>>? = null,
    public val grantee: Output<String>? = null,
    public val granteeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.inputs.PipelineContentConfigPermissionArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.inputs.PipelineContentConfigPermissionArgs = com.pulumi.aws.elastictranscoder.inputs.PipelineContentConfigPermissionArgs.builder()
        .accesses(accesses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .grantee(grantee?.applyValue({ args0 -> args0 }))
        .granteeType(granteeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineContentConfigPermissionArgs].
 */
@PulumiTagMarker
public class PipelineContentConfigPermissionArgsBuilder internal constructor() {
    private var accesses: Output<List<String>>? = null

    private var grantee: Output<String>? = null

    private var granteeType: Output<String>? = null

    /**
     * @param value The permission that you want to give to the AWS user that you specified in `content_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
     */
    @JvmName("ugjyuayakcduitdp")
    public suspend fun accesses(`value`: Output<List<String>>) {
        this.accesses = value
    }

    @JvmName("otekxtielsivrsmx")
    public suspend fun accesses(vararg values: Output<String>) {
        this.accesses = Output.all(values.asList())
    }

    /**
     * @param values The permission that you want to give to the AWS user that you specified in `content_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
     */
    @JvmName("rxaimwbgyirjwbrl")
    public suspend fun accesses(values: List<Output<String>>) {
        this.accesses = Output.all(values)
    }

    /**
     * @param value The AWS user or group that you want to have access to transcoded files and playlists.
     */
    @JvmName("tdbabingssjklxux")
    public suspend fun grantee(`value`: Output<String>) {
        this.grantee = value
    }

    /**
     * @param value Specify the type of value that appears in the `content_config_permissions.grantee` object. Valid values are `Canonical`, `Email` or `Group`.
     */
    @JvmName("jmhvacnsjvcvgbpc")
    public suspend fun granteeType(`value`: Output<String>) {
        this.granteeType = value
    }

    /**
     * @param value The permission that you want to give to the AWS user that you specified in `content_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
     */
    @JvmName("cgcoirqusdabloyu")
    public suspend fun accesses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accesses = mapped
    }

    /**
     * @param values The permission that you want to give to the AWS user that you specified in `content_config_permissions.grantee`. Valid values are `Read`, `ReadAcp`, `WriteAcp` or `FullControl`.
     */
    @JvmName("djtiyyjasximjdad")
    public suspend fun accesses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accesses = mapped
    }

    /**
     * @param value The AWS user or group that you want to have access to transcoded files and playlists.
     */
    @JvmName("edadqqldovoncroq")
    public suspend fun grantee(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grantee = mapped
    }

    /**
     * @param value Specify the type of value that appears in the `content_config_permissions.grantee` object. Valid values are `Canonical`, `Email` or `Group`.
     */
    @JvmName("ufqrsjdrftcktxvg")
    public suspend fun granteeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.granteeType = mapped
    }

    internal fun build(): PipelineContentConfigPermissionArgs = PipelineContentConfigPermissionArgs(
        accesses = accesses,
        grantee = grantee,
        granteeType = granteeType,
    )
}
