@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.inputs

import com.pulumi.aws.elastictranscoder.inputs.PipelineNotificationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property completed The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job in this pipeline.
 * @property error The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition while processing a job in this pipeline.
 * @property progressing The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process a job in this pipeline.
 * @property warning The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition while processing a job in this pipeline.
 * The `thumbnail_config` object specifies information about the Amazon S3 bucket in
 * which you want Elastic Transcoder to save thumbnail files: which bucket to use,
 * which users you want to have access to the files, the type of access you want
 * users to have, and the storage class that you want to assign to the files. If
 * you specify values for `content_config`, you must also specify values for
 * `thumbnail_config` even if you don't want to create thumbnails. (You control
 * whether to create thumbnails when you create a job. For more information, see
 * ThumbnailPattern in the topic Create Job.) If you specify values for
 * `content_config` and `thumbnail_config`, omit the OutputBucket object.
 */
public data class PipelineNotificationsArgs(
    public val completed: Output<String>? = null,
    public val error: Output<String>? = null,
    public val progressing: Output<String>? = null,
    public val warning: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.inputs.PipelineNotificationsArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.inputs.PipelineNotificationsArgs =
        com.pulumi.aws.elastictranscoder.inputs.PipelineNotificationsArgs.builder()
            .completed(completed?.applyValue({ args0 -> args0 }))
            .error(error?.applyValue({ args0 -> args0 }))
            .progressing(progressing?.applyValue({ args0 -> args0 }))
            .warning(warning?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineNotificationsArgs].
 */
@PulumiTagMarker
public class PipelineNotificationsArgsBuilder internal constructor() {
    private var completed: Output<String>? = null

    private var error: Output<String>? = null

    private var progressing: Output<String>? = null

    private var warning: Output<String>? = null

    /**
     * @param value The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job in this pipeline.
     */
    @JvmName("badsfcpuhhlutvod")
    public suspend fun completed(`value`: Output<String>) {
        this.completed = value
    }

    /**
     * @param value The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition while processing a job in this pipeline.
     */
    @JvmName("oicxjjsffqlgxpvk")
    public suspend fun error(`value`: Output<String>) {
        this.error = value
    }

    /**
     * @param value The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process a job in this pipeline.
     */
    @JvmName("qyfxcbtartfacpqb")
    public suspend fun progressing(`value`: Output<String>) {
        this.progressing = value
    }

    /**
     * @param value The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition while processing a job in this pipeline.
     * The `thumbnail_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save thumbnail files: which bucket to use,
     * which users you want to have access to the files, the type of access you want
     * users to have, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config` even if you don't want to create thumbnails. (You control
     * whether to create thumbnails when you create a job. For more information, see
     * ThumbnailPattern in the topic Create Job.) If you specify values for
     * `content_config` and `thumbnail_config`, omit the OutputBucket object.
     */
    @JvmName("febgjwwykucrwscy")
    public suspend fun warning(`value`: Output<String>) {
        this.warning = value
    }

    /**
     * @param value The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job in this pipeline.
     */
    @JvmName("dwpkhuaatlpblgxd")
    public suspend fun completed(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.completed = mapped
    }

    /**
     * @param value The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition while processing a job in this pipeline.
     */
    @JvmName("bsmumhkxfenajphq")
    public suspend fun error(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error = mapped
    }

    /**
     * @param value The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process a job in this pipeline.
     */
    @JvmName("eexirrhrrnficevp")
    public suspend fun progressing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.progressing = mapped
    }

    /**
     * @param value The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition while processing a job in this pipeline.
     * The `thumbnail_config` object specifies information about the Amazon S3 bucket in
     * which you want Elastic Transcoder to save thumbnail files: which bucket to use,
     * which users you want to have access to the files, the type of access you want
     * users to have, and the storage class that you want to assign to the files. If
     * you specify values for `content_config`, you must also specify values for
     * `thumbnail_config` even if you don't want to create thumbnails. (You control
     * whether to create thumbnails when you create a job. For more information, see
     * ThumbnailPattern in the topic Create Job.) If you specify values for
     * `content_config` and `thumbnail_config`, omit the OutputBucket object.
     */
    @JvmName("qwpepctxxckqxiwn")
    public suspend fun warning(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warning = mapped
    }

    internal fun build(): PipelineNotificationsArgs = PipelineNotificationsArgs(
        completed = completed,
        error = error,
        progressing = progressing,
        warning = warning,
    )
}
