@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.inputs

import com.pulumi.aws.elastictranscoder.inputs.PipelineThumbnailConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
 * @property storageClass The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
 */
public data class PipelineThumbnailConfigArgs(
    public val bucket: Output<String>? = null,
    public val storageClass: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.inputs.PipelineThumbnailConfigArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.inputs.PipelineThumbnailConfigArgs =
        com.pulumi.aws.elastictranscoder.inputs.PipelineThumbnailConfigArgs.builder()
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineThumbnailConfigArgs].
 */
@PulumiTagMarker
public class PipelineThumbnailConfigArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
     */
    @JvmName("taayljqgaimwrxmk")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
     */
    @JvmName("coolxpolesihveiy")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
     */
    @JvmName("bmffsigmahpntknk")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
     */
    @JvmName("xgfvagjfydhsgqbo")
    public suspend fun storageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): PipelineThumbnailConfigArgs = PipelineThumbnailConfigArgs(
        bucket = bucket,
        storageClass = storageClass,
    )
}
