@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.inputs

import com.pulumi.aws.elastictranscoder.inputs.PresetAudioCodecOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bitDepth The bit depth of a sample is how many bits of information are included in the audio samples. Valid values are `16` and `24`. (FLAC/PCM Only)
 * @property bitOrder The order the bits of a PCM sample are stored in. The supported value is LittleEndian. (PCM Only)
 * @property profile If you specified AAC for Audio:Codec, choose the AAC profile for the output file.
 * @property signed Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned). The supported value is Signed. (PCM Only)
 */
public data class PresetAudioCodecOptionsArgs(
    public val bitDepth: Output<String>? = null,
    public val bitOrder: Output<String>? = null,
    public val profile: Output<String>? = null,
    public val signed: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.inputs.PresetAudioCodecOptionsArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.inputs.PresetAudioCodecOptionsArgs =
        com.pulumi.aws.elastictranscoder.inputs.PresetAudioCodecOptionsArgs.builder()
            .bitDepth(bitDepth?.applyValue({ args0 -> args0 }))
            .bitOrder(bitOrder?.applyValue({ args0 -> args0 }))
            .profile(profile?.applyValue({ args0 -> args0 }))
            .signed(signed?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PresetAudioCodecOptionsArgs].
 */
@PulumiTagMarker
public class PresetAudioCodecOptionsArgsBuilder internal constructor() {
    private var bitDepth: Output<String>? = null

    private var bitOrder: Output<String>? = null

    private var profile: Output<String>? = null

    private var signed: Output<String>? = null

    /**
     * @param value The bit depth of a sample is how many bits of information are included in the audio samples. Valid values are `16` and `24`. (FLAC/PCM Only)
     */
    @JvmName("qcqfdsmfeasibwll")
    public suspend fun bitDepth(`value`: Output<String>) {
        this.bitDepth = value
    }

    /**
     * @param value The order the bits of a PCM sample are stored in. The supported value is LittleEndian. (PCM Only)
     */
    @JvmName("gxpiheiyowcpecti")
    public suspend fun bitOrder(`value`: Output<String>) {
        this.bitOrder = value
    }

    /**
     * @param value If you specified AAC for Audio:Codec, choose the AAC profile for the output file.
     */
    @JvmName("yccigfafuybbfcrv")
    public suspend fun profile(`value`: Output<String>) {
        this.profile = value
    }

    /**
     * @param value Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned). The supported value is Signed. (PCM Only)
     */
    @JvmName("mvbuguwrceylmyag")
    public suspend fun signed(`value`: Output<String>) {
        this.signed = value
    }

    /**
     * @param value The bit depth of a sample is how many bits of information are included in the audio samples. Valid values are `16` and `24`. (FLAC/PCM Only)
     */
    @JvmName("ydsymvkclanaguay")
    public suspend fun bitDepth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitDepth = mapped
    }

    /**
     * @param value The order the bits of a PCM sample are stored in. The supported value is LittleEndian. (PCM Only)
     */
    @JvmName("wbkdvrywplxrkirj")
    public suspend fun bitOrder(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitOrder = mapped
    }

    /**
     * @param value If you specified AAC for Audio:Codec, choose the AAC profile for the output file.
     */
    @JvmName("cocxbvwkbptqukjr")
    public suspend fun profile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned). The supported value is Signed. (PCM Only)
     */
    @JvmName("jyiykcmquapjltcf")
    public suspend fun signed(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signed = mapped
    }

    internal fun build(): PresetAudioCodecOptionsArgs = PresetAudioCodecOptionsArgs(
        bitDepth = bitDepth,
        bitOrder = bitOrder,
        profile = profile,
        signed = signed,
    )
}
