@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.inputs

import com.pulumi.aws.elastictranscoder.inputs.PresetThumbnailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property aspectRatio The aspect ratio of thumbnails. The following values are valid: auto, 1:1, 4:3, 3:2, 16:9
 * @property format The format of thumbnails, if any. Valid formats are jpg and png.
 * @property interval The approximate number of seconds between thumbnails. The value must be an integer. The actual interval can vary by several seconds from one thumbnail to the next.
 * @property maxHeight The maximum height of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.
 * @property maxWidth The maximum width of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.
 * @property paddingPolicy When you set PaddingPolicy to Pad, Elastic Transcoder might add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail MaxWidth and MaxHeight settings.
 * @property resolution The width and height of thumbnail files in pixels, in the format WidthxHeight, where both values are even integers. The values cannot exceed the width and height that you specified in the Video:Resolution object. (To better control resolution and aspect ratio of thumbnails, we recommend that you use the thumbnail values `max_width`, `max_height`, `sizing_policy`, and `padding_policy` instead of `resolution` and `aspect_ratio`. The two groups of settings are mutually exclusive. Do not use them together)
 * @property sizingPolicy A value that controls scaling of thumbnails. Valid values are: `Fit`, `Fill`, `Stretch`, `Keep`, `ShrinkToFit`, and `ShrinkToFill`.
 */
public data class PresetThumbnailsArgs(
    public val aspectRatio: Output<String>? = null,
    public val format: Output<String>? = null,
    public val interval: Output<String>? = null,
    public val maxHeight: Output<String>? = null,
    public val maxWidth: Output<String>? = null,
    public val paddingPolicy: Output<String>? = null,
    public val resolution: Output<String>? = null,
    public val sizingPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.inputs.PresetThumbnailsArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.inputs.PresetThumbnailsArgs =
        com.pulumi.aws.elastictranscoder.inputs.PresetThumbnailsArgs.builder()
            .aspectRatio(aspectRatio?.applyValue({ args0 -> args0 }))
            .format(format?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .maxHeight(maxHeight?.applyValue({ args0 -> args0 }))
            .maxWidth(maxWidth?.applyValue({ args0 -> args0 }))
            .paddingPolicy(paddingPolicy?.applyValue({ args0 -> args0 }))
            .resolution(resolution?.applyValue({ args0 -> args0 }))
            .sizingPolicy(sizingPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PresetThumbnailsArgs].
 */
@PulumiTagMarker
public class PresetThumbnailsArgsBuilder internal constructor() {
    private var aspectRatio: Output<String>? = null

    private var format: Output<String>? = null

    private var interval: Output<String>? = null

    private var maxHeight: Output<String>? = null

    private var maxWidth: Output<String>? = null

    private var paddingPolicy: Output<String>? = null

    private var resolution: Output<String>? = null

    private var sizingPolicy: Output<String>? = null

    /**
     * @param value The aspect ratio of thumbnails. The following values are valid: auto, 1:1, 4:3, 3:2, 16:9
     */
    @JvmName("ficraabxatteyjln")
    public suspend fun aspectRatio(`value`: Output<String>) {
        this.aspectRatio = value
    }

    /**
     * @param value The format of thumbnails, if any. Valid formats are jpg and png.
     */
    @JvmName("cppwgbhspdxafttt")
    public suspend fun format(`value`: Output<String>) {
        this.format = value
    }

    /**
     * @param value The approximate number of seconds between thumbnails. The value must be an integer. The actual interval can vary by several seconds from one thumbnail to the next.
     */
    @JvmName("mjcobnxohihtyoca")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value The maximum height of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.
     */
    @JvmName("gnynylnbghjgltce")
    public suspend fun maxHeight(`value`: Output<String>) {
        this.maxHeight = value
    }

    /**
     * @param value The maximum width of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.
     */
    @JvmName("nwtvbebllrjqtnvm")
    public suspend fun maxWidth(`value`: Output<String>) {
        this.maxWidth = value
    }

    /**
     * @param value When you set PaddingPolicy to Pad, Elastic Transcoder might add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail MaxWidth and MaxHeight settings.
     */
    @JvmName("bwnocegtjsvnecvk")
    public suspend fun paddingPolicy(`value`: Output<String>) {
        this.paddingPolicy = value
    }

    /**
     * @param value The width and height of thumbnail files in pixels, in the format WidthxHeight, where both values are even integers. The values cannot exceed the width and height that you specified in the Video:Resolution object. (To better control resolution and aspect ratio of thumbnails, we recommend that you use the thumbnail values `max_width`, `max_height`, `sizing_policy`, and `padding_policy` instead of `resolution` and `aspect_ratio`. The two groups of settings are mutually exclusive. Do not use them together)
     */
    @JvmName("qoymhohdqyallcdm")
    public suspend fun resolution(`value`: Output<String>) {
        this.resolution = value
    }

    /**
     * @param value A value that controls scaling of thumbnails. Valid values are: `Fit`, `Fill`, `Stretch`, `Keep`, `ShrinkToFit`, and `ShrinkToFill`.
     */
    @JvmName("oqlbrcipddappkom")
    public suspend fun sizingPolicy(`value`: Output<String>) {
        this.sizingPolicy = value
    }

    /**
     * @param value The aspect ratio of thumbnails. The following values are valid: auto, 1:1, 4:3, 3:2, 16:9
     */
    @JvmName("dkicyqyiemruihal")
    public suspend fun aspectRatio(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aspectRatio = mapped
    }

    /**
     * @param value The format of thumbnails, if any. Valid formats are jpg and png.
     */
    @JvmName("qfmandioprvfguti")
    public suspend fun format(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value The approximate number of seconds between thumbnails. The value must be an integer. The actual interval can vary by several seconds from one thumbnail to the next.
     */
    @JvmName("etomjputvglceglv")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The maximum height of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.
     */
    @JvmName("dowedfpdugnhowgp")
    public suspend fun maxHeight(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxHeight = mapped
    }

    /**
     * @param value The maximum width of thumbnails, in pixels. If you specify auto, Elastic Transcoder uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.
     */
    @JvmName("cvardhbepginlxsa")
    public suspend fun maxWidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxWidth = mapped
    }

    /**
     * @param value When you set PaddingPolicy to Pad, Elastic Transcoder might add black bars to the top and bottom and/or left and right sides of thumbnails to make the total size of the thumbnails match the values that you specified for thumbnail MaxWidth and MaxHeight settings.
     */
    @JvmName("ytetyyraryfoydxq")
    public suspend fun paddingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paddingPolicy = mapped
    }

    /**
     * @param value The width and height of thumbnail files in pixels, in the format WidthxHeight, where both values are even integers. The values cannot exceed the width and height that you specified in the Video:Resolution object. (To better control resolution and aspect ratio of thumbnails, we recommend that you use the thumbnail values `max_width`, `max_height`, `sizing_policy`, and `padding_policy` instead of `resolution` and `aspect_ratio`. The two groups of settings are mutually exclusive. Do not use them together)
     */
    @JvmName("hpqkqkpiuswcvlax")
    public suspend fun resolution(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolution = mapped
    }

    /**
     * @param value A value that controls scaling of thumbnails. Valid values are: `Fit`, `Fill`, `Stretch`, `Keep`, `ShrinkToFit`, and `ShrinkToFill`.
     */
    @JvmName("omighkawnguycpan")
    public suspend fun sizingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizingPolicy = mapped
    }

    internal fun build(): PresetThumbnailsArgs = PresetThumbnailsArgs(
        aspectRatio = aspectRatio,
        format = format,
        interval = interval,
        maxHeight = maxHeight,
        maxWidth = maxWidth,
        paddingPolicy = paddingPolicy,
        resolution = resolution,
        sizingPolicy = sizingPolicy,
    )
}
