@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.inputs

import com.pulumi.aws.elastictranscoder.inputs.PresetVideoWatermarkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property horizontalAlign The horizontal position of the watermark unless you specify a nonzero value for `horzontal_offset`.
 * @property horizontalOffset The amount by which you want the horizontal position of the watermark to be offset from the position specified by `horizontal_align`.
 * @property id A unique identifier for the settings for one watermark. The value of Id can be up to 40 characters long. You can specify settings for up to four watermarks.
 * @property maxHeight The maximum height of the watermark.
 * @property maxWidth The maximum width of the watermark.
 * @property opacity A percentage that indicates how much you want a watermark to obscure the video in the location where it appears.
 * @property sizingPolicy A value that controls scaling of the watermark. Valid values are: `Fit`, `Stretch`, `ShrinkToFit`
 * @property target A value that determines how Elastic Transcoder interprets values that you specified for `video_watermarks.horizontal_offset`, `video_watermarks.vertical_offset`, `video_watermarks.max_width`, and `video_watermarks.max_height`. Valid values are `Content` and `Frame`.
 * @property verticalAlign The vertical position of the watermark unless you specify a nonzero value for `vertical_align`. Valid values are `Top`, `Bottom`, `Center`.
 * @property verticalOffset The amount by which you want the vertical position of the watermark to be offset from the position specified by `vertical_align`
 */
public data class PresetVideoWatermarkArgs(
    public val horizontalAlign: Output<String>? = null,
    public val horizontalOffset: Output<String>? = null,
    public val id: Output<String>? = null,
    public val maxHeight: Output<String>? = null,
    public val maxWidth: Output<String>? = null,
    public val opacity: Output<String>? = null,
    public val sizingPolicy: Output<String>? = null,
    public val target: Output<String>? = null,
    public val verticalAlign: Output<String>? = null,
    public val verticalOffset: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elastictranscoder.inputs.PresetVideoWatermarkArgs> {
    override fun toJava(): com.pulumi.aws.elastictranscoder.inputs.PresetVideoWatermarkArgs =
        com.pulumi.aws.elastictranscoder.inputs.PresetVideoWatermarkArgs.builder()
            .horizontalAlign(horizontalAlign?.applyValue({ args0 -> args0 }))
            .horizontalOffset(horizontalOffset?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .maxHeight(maxHeight?.applyValue({ args0 -> args0 }))
            .maxWidth(maxWidth?.applyValue({ args0 -> args0 }))
            .opacity(opacity?.applyValue({ args0 -> args0 }))
            .sizingPolicy(sizingPolicy?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0 }))
            .verticalAlign(verticalAlign?.applyValue({ args0 -> args0 }))
            .verticalOffset(verticalOffset?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PresetVideoWatermarkArgs].
 */
@PulumiTagMarker
public class PresetVideoWatermarkArgsBuilder internal constructor() {
    private var horizontalAlign: Output<String>? = null

    private var horizontalOffset: Output<String>? = null

    private var id: Output<String>? = null

    private var maxHeight: Output<String>? = null

    private var maxWidth: Output<String>? = null

    private var opacity: Output<String>? = null

    private var sizingPolicy: Output<String>? = null

    private var target: Output<String>? = null

    private var verticalAlign: Output<String>? = null

    private var verticalOffset: Output<String>? = null

    /**
     * @param value The horizontal position of the watermark unless you specify a nonzero value for `horzontal_offset`.
     */
    @JvmName("fswdljdlfsmicsdf")
    public suspend fun horizontalAlign(`value`: Output<String>) {
        this.horizontalAlign = value
    }

    /**
     * @param value The amount by which you want the horizontal position of the watermark to be offset from the position specified by `horizontal_align`.
     */
    @JvmName("igslehldfwyawetj")
    public suspend fun horizontalOffset(`value`: Output<String>) {
        this.horizontalOffset = value
    }

    /**
     * @param value A unique identifier for the settings for one watermark. The value of Id can be up to 40 characters long. You can specify settings for up to four watermarks.
     */
    @JvmName("ecxtinftfqdxahcd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The maximum height of the watermark.
     */
    @JvmName("dqffwiihsuofpnjn")
    public suspend fun maxHeight(`value`: Output<String>) {
        this.maxHeight = value
    }

    /**
     * @param value The maximum width of the watermark.
     */
    @JvmName("wppvcayawruffwsu")
    public suspend fun maxWidth(`value`: Output<String>) {
        this.maxWidth = value
    }

    /**
     * @param value A percentage that indicates how much you want a watermark to obscure the video in the location where it appears.
     */
    @JvmName("cqvqjbscvknhamtk")
    public suspend fun opacity(`value`: Output<String>) {
        this.opacity = value
    }

    /**
     * @param value A value that controls scaling of the watermark. Valid values are: `Fit`, `Stretch`, `ShrinkToFit`
     */
    @JvmName("kkymrptdnaylwdid")
    public suspend fun sizingPolicy(`value`: Output<String>) {
        this.sizingPolicy = value
    }

    /**
     * @param value A value that determines how Elastic Transcoder interprets values that you specified for `video_watermarks.horizontal_offset`, `video_watermarks.vertical_offset`, `video_watermarks.max_width`, and `video_watermarks.max_height`. Valid values are `Content` and `Frame`.
     */
    @JvmName("hhnolbvjlfyrqhba")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value The vertical position of the watermark unless you specify a nonzero value for `vertical_align`. Valid values are `Top`, `Bottom`, `Center`.
     */
    @JvmName("lixyeoclkshkoscw")
    public suspend fun verticalAlign(`value`: Output<String>) {
        this.verticalAlign = value
    }

    /**
     * @param value The amount by which you want the vertical position of the watermark to be offset from the position specified by `vertical_align`
     */
    @JvmName("pitytcmidmqebikj")
    public suspend fun verticalOffset(`value`: Output<String>) {
        this.verticalOffset = value
    }

    /**
     * @param value The horizontal position of the watermark unless you specify a nonzero value for `horzontal_offset`.
     */
    @JvmName("ieldpqsxlfjttqvu")
    public suspend fun horizontalAlign(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.horizontalAlign = mapped
    }

    /**
     * @param value The amount by which you want the horizontal position of the watermark to be offset from the position specified by `horizontal_align`.
     */
    @JvmName("qpwvnptswmlwcmvd")
    public suspend fun horizontalOffset(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.horizontalOffset = mapped
    }

    /**
     * @param value A unique identifier for the settings for one watermark. The value of Id can be up to 40 characters long. You can specify settings for up to four watermarks.
     */
    @JvmName("wllfujrpulvcbpxm")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The maximum height of the watermark.
     */
    @JvmName("mpraofunseikfjfd")
    public suspend fun maxHeight(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxHeight = mapped
    }

    /**
     * @param value The maximum width of the watermark.
     */
    @JvmName("eqwutrgsyirpwvup")
    public suspend fun maxWidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxWidth = mapped
    }

    /**
     * @param value A percentage that indicates how much you want a watermark to obscure the video in the location where it appears.
     */
    @JvmName("khwgeeusknxjrpff")
    public suspend fun opacity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.opacity = mapped
    }

    /**
     * @param value A value that controls scaling of the watermark. Valid values are: `Fit`, `Stretch`, `ShrinkToFit`
     */
    @JvmName("vwfivhduycjfrwha")
    public suspend fun sizingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizingPolicy = mapped
    }

    /**
     * @param value A value that determines how Elastic Transcoder interprets values that you specified for `video_watermarks.horizontal_offset`, `video_watermarks.vertical_offset`, `video_watermarks.max_width`, and `video_watermarks.max_height`. Valid values are `Content` and `Frame`.
     */
    @JvmName("pedycblkxiaoypgm")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value The vertical position of the watermark unless you specify a nonzero value for `vertical_align`. Valid values are `Top`, `Bottom`, `Center`.
     */
    @JvmName("ofpinegokbplsvip")
    public suspend fun verticalAlign(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verticalAlign = mapped
    }

    /**
     * @param value The amount by which you want the vertical position of the watermark to be offset from the position specified by `vertical_align`
     */
    @JvmName("knpanepgypdjxyjk")
    public suspend fun verticalOffset(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verticalOffset = mapped
    }

    internal fun build(): PresetVideoWatermarkArgs = PresetVideoWatermarkArgs(
        horizontalAlign = horizontalAlign,
        horizontalOffset = horizontalOffset,
        id = id,
        maxHeight = maxHeight,
        maxWidth = maxWidth,
        opacity = opacity,
        sizingPolicy = sizingPolicy,
        target = target,
        verticalAlign = verticalAlign,
        verticalOffset = verticalOffset,
    )
}
