@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property completed The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job in this pipeline.
 * @property error The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition while processing a job in this pipeline.
 * @property progressing The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process a job in this pipeline.
 * @property warning The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition while processing a job in this pipeline.
 * The `thumbnail_config` object specifies information about the Amazon S3 bucket in
 * which you want Elastic Transcoder to save thumbnail files: which bucket to use,
 * which users you want to have access to the files, the type of access you want
 * users to have, and the storage class that you want to assign to the files. If
 * you specify values for `content_config`, you must also specify values for
 * `thumbnail_config` even if you don't want to create thumbnails. (You control
 * whether to create thumbnails when you create a job. For more information, see
 * ThumbnailPattern in the topic Create Job.) If you specify values for
 * `content_config` and `thumbnail_config`, omit the OutputBucket object.
 */
public data class PipelineNotifications(
    public val completed: String? = null,
    public val error: String? = null,
    public val progressing: String? = null,
    public val warning: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elastictranscoder.outputs.PipelineNotifications): PipelineNotifications = PipelineNotifications(
            completed = javaType.completed().map({ args0 -> args0 }).orElse(null),
            error = javaType.error().map({ args0 -> args0 }).orElse(null),
            progressing = javaType.progressing().map({ args0 -> args0 }).orElse(null),
            warning = javaType.warning().map({ args0 -> args0 }).orElse(null),
        )
    }
}
