@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
 * @property storageClass The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
 */
public data class PipelineThumbnailConfig(
    public val bucket: String? = null,
    public val storageClass: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elastictranscoder.outputs.PipelineThumbnailConfig): PipelineThumbnailConfig = PipelineThumbnailConfig(
            bucket = javaType.bucket().map({ args0 -> args0 }).orElse(null),
            storageClass = javaType.storageClass().map({ args0 -> args0 }).orElse(null),
        )
    }
}
