@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property audioPackingMode The method of organizing audio channels and tracks. Use Audio:Channels to specify the number of channels in your output, and Audio:AudioPackingMode to specify the number of tracks and their relation to the channels. If you do not specify an Audio:AudioPackingMode, Elastic Transcoder uses SingleTrack.
 * @property bitRate The bit rate of the audio stream in the output file, in kilobits/second. Enter an integer between 64 and 320, inclusive.
 * @property channels The number of audio channels in the output file
 * @property codec The audio codec for the output file. Valid values are `AAC`, `flac`, `mp2`, `mp3`, `pcm`, and `vorbis`.
 * @property sampleRate The sample rate of the audio stream in the output file, in hertz. Valid values are: `auto`, `22050`, `32000`, `44100`, `48000`, `96000`
 */
public data class PresetAudio(
    public val audioPackingMode: String? = null,
    public val bitRate: String? = null,
    public val channels: String? = null,
    public val codec: String? = null,
    public val sampleRate: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elastictranscoder.outputs.PresetAudio): PresetAudio = PresetAudio(
            audioPackingMode = javaType.audioPackingMode().map({ args0 -> args0 }).orElse(null),
            bitRate = javaType.bitRate().map({ args0 -> args0 }).orElse(null),
            channels = javaType.channels().map({ args0 -> args0 }).orElse(null),
            codec = javaType.codec().map({ args0 -> args0 }).orElse(null),
            sampleRate = javaType.sampleRate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
