@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elastictranscoder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property horizontalAlign The horizontal position of the watermark unless you specify a nonzero value for `horzontal_offset`.
 * @property horizontalOffset The amount by which you want the horizontal position of the watermark to be offset from the position specified by `horizontal_align`.
 * @property id A unique identifier for the settings for one watermark. The value of Id can be up to 40 characters long. You can specify settings for up to four watermarks.
 * @property maxHeight The maximum height of the watermark.
 * @property maxWidth The maximum width of the watermark.
 * @property opacity A percentage that indicates how much you want a watermark to obscure the video in the location where it appears.
 * @property sizingPolicy A value that controls scaling of the watermark. Valid values are: `Fit`, `Stretch`, `ShrinkToFit`
 * @property target A value that determines how Elastic Transcoder interprets values that you specified for `video_watermarks.horizontal_offset`, `video_watermarks.vertical_offset`, `video_watermarks.max_width`, and `video_watermarks.max_height`. Valid values are `Content` and `Frame`.
 * @property verticalAlign The vertical position of the watermark unless you specify a nonzero value for `vertical_align`. Valid values are `Top`, `Bottom`, `Center`.
 * @property verticalOffset The amount by which you want the vertical position of the watermark to be offset from the position specified by `vertical_align`
 */
public data class PresetVideoWatermark(
    public val horizontalAlign: String? = null,
    public val horizontalOffset: String? = null,
    public val id: String? = null,
    public val maxHeight: String? = null,
    public val maxWidth: String? = null,
    public val opacity: String? = null,
    public val sizingPolicy: String? = null,
    public val target: String? = null,
    public val verticalAlign: String? = null,
    public val verticalOffset: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elastictranscoder.outputs.PresetVideoWatermark): PresetVideoWatermark = PresetVideoWatermark(
            horizontalAlign = javaType.horizontalAlign().map({ args0 -> args0 }).orElse(null),
            horizontalOffset = javaType.horizontalOffset().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            maxHeight = javaType.maxHeight().map({ args0 -> args0 }).orElse(null),
            maxWidth = javaType.maxWidth().map({ args0 -> args0 }).orElse(null),
            opacity = javaType.opacity().map({ args0 -> args0 }).orElse(null),
            sizingPolicy = javaType.sizingPolicy().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            verticalAlign = javaType.verticalAlign().map({ args0 -> args0 }).orElse(null),
            verticalOffset = javaType.verticalOffset().map({ args0 -> args0 }).orElse(null),
        )
    }
}
