@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.AppCookieStickinessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an application cookie stickiness policy, which allows an ELB to wed its sticky cookie's expiration to a cookie generated by your application.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const lb = new aws.elb.LoadBalancer("lb", {
 *     name: "test-lb",
 *     availabilityZones: ["us-east-1a"],
 *     listeners: [{
 *         instancePort: 8000,
 *         instanceProtocol: "http",
 *         lbPort: 80,
 *         lbProtocol: "http",
 *     }],
 * });
 * const foo = new aws.elb.AppCookieStickinessPolicy("foo", {
 *     name: "foo_policy",
 *     loadBalancer: lb.name,
 *     lbPort: 80,
 *     cookieName: "MyAppCookie",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * lb = aws.elb.LoadBalancer("lb",
 *     name="test-lb",
 *     availability_zones=["us-east-1a"],
 *     listeners=[{
 *         "instance_port": 8000,
 *         "instance_protocol": "http",
 *         "lb_port": 80,
 *         "lb_protocol": "http",
 *     }])
 * foo = aws.elb.AppCookieStickinessPolicy("foo",
 *     name="foo_policy",
 *     load_balancer=lb.name,
 *     lb_port=80,
 *     cookie_name="MyAppCookie")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lb = new Aws.Elb.LoadBalancer("lb", new()
 *     {
 *         Name = "test-lb",
 *         AvailabilityZones = new[]
 *         {
 *             "us-east-1a",
 *         },
 *         Listeners = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 8000,
 *                 InstanceProtocol = "http",
 *                 LbPort = 80,
 *                 LbProtocol = "http",
 *             },
 *         },
 *     });
 *     var foo = new Aws.Elb.AppCookieStickinessPolicy("foo", new()
 *     {
 *         Name = "foo_policy",
 *         LoadBalancer = lb.Name,
 *         LbPort = 80,
 *         CookieName = "MyAppCookie",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		lb, err := elb.NewLoadBalancer(ctx, "lb", &elb.LoadBalancerArgs{
 * 			Name: pulumi.String("test-lb"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-east-1a"),
 * 			},
 * 			Listeners: elb.LoadBalancerListenerArray{
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(8000),
 * 					InstanceProtocol: pulumi.String("http"),
 * 					LbPort:           pulumi.Int(80),
 * 					LbProtocol:       pulumi.String("http"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elb.NewAppCookieStickinessPolicy(ctx, "foo", &elb.AppCookieStickinessPolicyArgs{
 * 			Name:         pulumi.String("foo_policy"),
 * 			LoadBalancer: lb.Name,
 * 			LbPort:       pulumi.Int(80),
 * 			CookieName:   pulumi.String("MyAppCookie"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.AppCookieStickinessPolicy;
 * import com.pulumi.aws.elb.AppCookieStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer("lb", LoadBalancerArgs.builder()
 *             .name("test-lb")
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(8000)
 *                 .instanceProtocol("http")
 *                 .lbPort(80)
 *                 .lbProtocol("http")
 *                 .build())
 *             .build());
 *         var foo = new AppCookieStickinessPolicy("foo", AppCookieStickinessPolicyArgs.builder()
 *             .name("foo_policy")
 *             .loadBalancer(lb.name())
 *             .lbPort(80)
 *             .cookieName("MyAppCookie")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lb:
 *     type: aws:elb:LoadBalancer
 *     properties:
 *       name: test-lb
 *       availabilityZones:
 *         - us-east-1a
 *       listeners:
 *         - instancePort: 8000
 *           instanceProtocol: http
 *           lbPort: 80
 *           lbProtocol: http
 *   foo:
 *     type: aws:elb:AppCookieStickinessPolicy
 *     properties:
 *       name: foo_policy
 *       loadBalancer: ${lb.name}
 *       lbPort: 80
 *       cookieName: MyAppCookie
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import application cookie stickiness policies using the ELB name, port, and policy name separated by colons (`:`). For example:
 * ```sh
 * $ pulumi import aws:elb/appCookieStickinessPolicy:AppCookieStickinessPolicy example my-elb:80:my-policy
 * ```
 * @property cookieName Application cookie whose lifetime the ELB's cookie should follow.
 * @property lbPort Load balancer port to which the policy
 * should be applied. This must be an active listener on the load
 * balancer.
 * @property loadBalancer Name of load balancer to which the policy
 * should be attached.
 * @property name Name of the stickiness policy.
 */
public data class AppCookieStickinessPolicyArgs(
    public val cookieName: Output<String>? = null,
    public val lbPort: Output<Int>? = null,
    public val loadBalancer: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.AppCookieStickinessPolicyArgs> {
    override fun toJava(): com.pulumi.aws.elb.AppCookieStickinessPolicyArgs =
        com.pulumi.aws.elb.AppCookieStickinessPolicyArgs.builder()
            .cookieName(cookieName?.applyValue({ args0 -> args0 }))
            .lbPort(lbPort?.applyValue({ args0 -> args0 }))
            .loadBalancer(loadBalancer?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppCookieStickinessPolicyArgs].
 */
@PulumiTagMarker
public class AppCookieStickinessPolicyArgsBuilder internal constructor() {
    private var cookieName: Output<String>? = null

    private var lbPort: Output<Int>? = null

    private var loadBalancer: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Application cookie whose lifetime the ELB's cookie should follow.
     */
    @JvmName("upgtyxljwoagkylp")
    public suspend fun cookieName(`value`: Output<String>) {
        this.cookieName = value
    }

    /**
     * @param value Load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    @JvmName("hjwqxqogodqrxwex")
    public suspend fun lbPort(`value`: Output<Int>) {
        this.lbPort = value
    }

    /**
     * @param value Name of load balancer to which the policy
     * should be attached.
     */
    @JvmName("shpdksxqhciljsku")
    public suspend fun loadBalancer(`value`: Output<String>) {
        this.loadBalancer = value
    }

    /**
     * @param value Name of the stickiness policy.
     */
    @JvmName("xiwddtlykerpavhg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Application cookie whose lifetime the ELB's cookie should follow.
     */
    @JvmName("akkwvoxbcbjqpmty")
    public suspend fun cookieName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieName = mapped
    }

    /**
     * @param value Load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    @JvmName("suheaqyyectetptj")
    public suspend fun lbPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbPort = mapped
    }

    /**
     * @param value Name of load balancer to which the policy
     * should be attached.
     */
    @JvmName("utqvkeywhstuhuwu")
    public suspend fun loadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancer = mapped
    }

    /**
     * @param value Name of the stickiness policy.
     */
    @JvmName("gnixtpyshqyfeafq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AppCookieStickinessPolicyArgs = AppCookieStickinessPolicyArgs(
        cookieName = cookieName,
        lbPort = lbPort,
        loadBalancer = loadBalancer,
        name = name,
    )
}
