@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.AttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches an EC2 instance to an Elastic Load Balancer (ELB). For attaching resources with Application Load Balancer (ALB) or Network Load Balancer (NLB), see the `aws.lb.TargetGroupAttachment` resource.
 * > **NOTE on ELB Instances and ELB Attachments:** This provider currently provides
 * both a standalone ELB Attachment resource (describing an instance attached to
 * an ELB), and an Elastic Load Balancer resource with
 * `instances` defined in-line. At this time you cannot use an ELB with in-line
 * instances in conjunction with an ELB Attachment resource. Doing so will cause a
 * conflict and will overwrite attachments.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new load balancer attachment
 * const baz = new aws.elb.Attachment("baz", {
 *     elb: bar.id,
 *     instance: foo.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new load balancer attachment
 * baz = aws.elb.Attachment("baz",
 *     elb=bar["id"],
 *     instance=foo["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new load balancer attachment
 *     var baz = new Aws.Elb.Attachment("baz", new()
 *     {
 *         Elb = bar.Id,
 *         Instance = foo.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new load balancer attachment
 * 		_, err := elb.NewAttachment(ctx, "baz", &elb.AttachmentArgs{
 * 			Elb:      pulumi.Any(bar.Id),
 * 			Instance: pulumi.Any(foo.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.Attachment;
 * import com.pulumi.aws.elb.AttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new load balancer attachment
 *         var baz = new Attachment("baz", AttachmentArgs.builder()
 *             .elb(bar.id())
 *             .instance(foo.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new load balancer attachment
 *   baz:
 *     type: aws:elb:Attachment
 *     properties:
 *       elb: ${bar.id}
 *       instance: ${foo.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property elb The name of the ELB.
 * @property instance Instance ID to place in the ELB pool.
 */
public data class AttachmentArgs(
    public val elb: Output<String>? = null,
    public val instance: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.AttachmentArgs> {
    override fun toJava(): com.pulumi.aws.elb.AttachmentArgs =
        com.pulumi.aws.elb.AttachmentArgs.builder()
            .elb(elb?.applyValue({ args0 -> args0 }))
            .instance(instance?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttachmentArgs].
 */
@PulumiTagMarker
public class AttachmentArgsBuilder internal constructor() {
    private var elb: Output<String>? = null

    private var instance: Output<String>? = null

    /**
     * @param value The name of the ELB.
     */
    @JvmName("huaidomdewkysign")
    public suspend fun elb(`value`: Output<String>) {
        this.elb = value
    }

    /**
     * @param value Instance ID to place in the ELB pool.
     */
    @JvmName("tpinrfvwrkbsbqxl")
    public suspend fun instance(`value`: Output<String>) {
        this.instance = value
    }

    /**
     * @param value The name of the ELB.
     */
    @JvmName("owlodvioxgexdhmm")
    public suspend fun elb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elb = mapped
    }

    /**
     * @param value Instance ID to place in the ELB pool.
     */
    @JvmName("dpdplwbtxvhywypq")
    public suspend fun instance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instance = mapped
    }

    internal fun build(): AttachmentArgs = AttachmentArgs(
        elb = elb,
        instance = instance,
    )
}
