@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerAccessLogs
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerHealthCheck
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerListener
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerAccessLogs.Companion.toKotlin as loadBalancerAccessLogsToKotlin
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerHealthCheck.Companion.toKotlin as loadBalancerHealthCheckToKotlin
import com.pulumi.aws.elb.kotlin.outputs.LoadBalancerListener.Companion.toKotlin as loadBalancerListenerToKotlin

/**
 * Builder for [LoadBalancer].
 */
@PulumiTagMarker
public class LoadBalancerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerArgs = LoadBalancerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerArgsBuilder.() -> Unit) {
        val builder = LoadBalancerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancer {
        val builtJavaResource = com.pulumi.aws.elb.LoadBalancer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return LoadBalancer(builtJavaResource)
    }
}

/**
 * Provides an Elastic Load Balancer resource, also known as a "Classic
 * Load Balancer" after the release of
 * Application/Network Load Balancers.
 * > **NOTE on ELB Instances and ELB Attachments:** This provider currently
 * provides both a standalone ELB Attachment resource
 * (describing an instance attached to an ELB), and an ELB resource with
 * `instances` defined in-line. At this time you cannot use an ELB with in-line
 * instances in conjunction with a ELB Attachment resources. Doing so will cause a
 * conflict and will overwrite attachments.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new load balancer
 * const bar = new aws.elb.LoadBalancer("bar", {
 *     name: "foobar-elb",
 *     availabilityZones: [
 *         "us-west-2a",
 *         "us-west-2b",
 *         "us-west-2c",
 *     ],
 *     accessLogs: {
 *         bucket: "foo",
 *         bucketPrefix: "bar",
 *         interval: 60,
 *     },
 *     listeners: [
 *         {
 *             instancePort: 8000,
 *             instanceProtocol: "http",
 *             lbPort: 80,
 *             lbProtocol: "http",
 *         },
 *         {
 *             instancePort: 8000,
 *             instanceProtocol: "http",
 *             lbPort: 443,
 *             lbProtocol: "https",
 *             sslCertificateId: "arn:aws:iam::123456789012:server-certificate/certName",
 *         },
 *     ],
 *     healthCheck: {
 *         healthyThreshold: 2,
 *         unhealthyThreshold: 2,
 *         timeout: 3,
 *         target: "HTTP:8000/",
 *         interval: 30,
 *     },
 *     instances: [foo&#46;id],
 *     crossZoneLoadBalancing: true,
 *     idleTimeout: 400,
 *     connectionDraining: true,
 *     connectionDrainingTimeout: 400,
 *     tags: {
 *         Name: "foobar-elb",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new load balancer
 * bar = aws.elb.LoadBalancer("bar",
 *     name="foobar-elb",
 *     availability_zones=[
 *         "us-west-2a",
 *         "us-west-2b",
 *         "us-west-2c",
 *     ],
 *     access_logs={
 *         "bucket": "foo",
 *         "bucket_prefix": "bar",
 *         "interval": 60,
 *     },
 *     listeners=[
 *         {
 *             "instance_port": 8000,
 *             "instance_protocol": "http",
 *             "lb_port": 80,
 *             "lb_protocol": "http",
 *         },
 *         {
 *             "instance_port": 8000,
 *             "instance_protocol": "http",
 *             "lb_port": 443,
 *             "lb_protocol": "https",
 *             "ssl_certificate_id": "arn:aws:iam::123456789012:server-certificate/certName",
 *         },
 *     ],
 *     health_check={
 *         "healthy_threshold": 2,
 *         "unhealthy_threshold": 2,
 *         "timeout": 3,
 *         "target": "HTTP:8000/",
 *         "interval": 30,
 *     },
 *     instances=[foo["id"]],
 *     cross_zone_load_balancing=True,
 *     idle_timeout=400,
 *     connection_draining=True,
 *     connection_draining_timeout=400,
 *     tags={
 *         "Name": "foobar-elb",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new load balancer
 *     var bar = new Aws.Elb.LoadBalancer("bar", new()
 *     {
 *         Name = "foobar-elb",
 *         AvailabilityZones = new[]
 *         {
 *             "us-west-2a",
 *             "us-west-2b",
 *             "us-west-2c",
 *         },
 *         AccessLogs = new Aws.Elb.Inputs.LoadBalancerAccessLogsArgs
 *         {
 *             Bucket = "foo",
 *             BucketPrefix = "bar",
 *             Interval = 60,
 *         },
 *         Listeners = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 8000,
 *                 InstanceProtocol = "http",
 *                 LbPort = 80,
 *                 LbProtocol = "http",
 *             },
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 8000,
 *                 InstanceProtocol = "http",
 *                 LbPort = 443,
 *                 LbProtocol = "https",
 *                 SslCertificateId = "arn:aws:iam::123456789012:server-certificate/certName",
 *             },
 *         },
 *         HealthCheck = new Aws.Elb.Inputs.LoadBalancerHealthCheckArgs
 *         {
 *             HealthyThreshold = 2,
 *             UnhealthyThreshold = 2,
 *             Timeout = 3,
 *             Target = "HTTP:8000/",
 *             Interval = 30,
 *         },
 *         Instances = new[]
 *         {
 *             foo.Id,
 *         },
 *         CrossZoneLoadBalancing = true,
 *         IdleTimeout = 400,
 *         ConnectionDraining = true,
 *         ConnectionDrainingTimeout = 400,
 *         Tags =
 *         {
 *             { "Name", "foobar-elb" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new load balancer
 * 		_, err := elb.NewLoadBalancer(ctx, "bar", &elb.LoadBalancerArgs{
 * 			Name: pulumi.String("foobar-elb"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-west-2a"),
 * 				pulumi.String("us-west-2b"),
 * 				pulumi.String("us-west-2c"),
 * 			},
 * 			AccessLogs: &elb.LoadBalancerAccessLogsArgs{
 * 				Bucket:       pulumi.String("foo"),
 * 				BucketPrefix: pulumi.String("bar"),
 * 				Interval:     pulumi.Int(60),
 * 			},
 * 			Listeners: elb.LoadBalancerListenerArray{
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(8000),
 * 					InstanceProtocol: pulumi.String("http"),
 * 					LbPort:           pulumi.Int(80),
 * 					LbProtocol:       pulumi.String("http"),
 * 				},
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(8000),
 * 					InstanceProtocol: pulumi.String("http"),
 * 					LbPort:           pulumi.Int(443),
 * 					LbProtocol:       pulumi.String("https"),
 * 					SslCertificateId: pulumi.String("arn:aws:iam::123456789012:server-certificate/certName"),
 * 				},
 * 			},
 * 			HealthCheck: &elb.LoadBalancerHealthCheckArgs{
 * 				HealthyThreshold:   pulumi.Int(2),
 * 				UnhealthyThreshold: pulumi.Int(2),
 * 				Timeout:            pulumi.Int(3),
 * 				Target:             pulumi.String("HTTP:8000/"),
 * 				Interval:           pulumi.Int(30),
 * 			},
 * 			Instances: pulumi.StringArray{
 * 				foo.Id,
 * 			},
 * 			CrossZoneLoadBalancing:    pulumi.Bool(true),
 * 			IdleTimeout:               pulumi.Int(400),
 * 			ConnectionDraining:        pulumi.Bool(true),
 * 			ConnectionDrainingTimeout: pulumi.Int(400),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foobar-elb"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerHealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new load balancer
 *         var bar = new LoadBalancer("bar", LoadBalancerArgs.builder()
 *             .name("foobar-elb")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .accessLogs(LoadBalancerAccessLogsArgs.builder()
 *                 .bucket("foo")
 *                 .bucketPrefix("bar")
 *                 .interval(60)
 *                 .build())
 *             .listeners(
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(8000)
 *                     .instanceProtocol("http")
 *                     .lbPort(80)
 *                     .lbProtocol("http")
 *                     .build(),
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(8000)
 *                     .instanceProtocol("http")
 *                     .lbPort(443)
 *                     .lbProtocol("https")
 *                     .sslCertificateId("arn:aws:iam::123456789012:server-certificate/certName")
 *                     .build())
 *             .healthCheck(LoadBalancerHealthCheckArgs.builder()
 *                 .healthyThreshold(2)
 *                 .unhealthyThreshold(2)
 *                 .timeout(3)
 *                 .target("HTTP:8000/")
 *                 .interval(30)
 *                 .build())
 *             .instances(foo.id())
 *             .crossZoneLoadBalancing(true)
 *             .idleTimeout(400)
 *             .connectionDraining(true)
 *             .connectionDrainingTimeout(400)
 *             .tags(Map.of("Name", "foobar-elb"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new load balancer
 *   bar:
 *     type: aws:elb:LoadBalancer
 *     properties:
 *       name: foobar-elb
 *       availabilityZones:
 *         - us-west-2a
 *         - us-west-2b
 *         - us-west-2c
 *       accessLogs:
 *         bucket: foo
 *         bucketPrefix: bar
 *         interval: 60
 *       listeners:
 *         - instancePort: 8000
 *           instanceProtocol: http
 *           lbPort: 80
 *           lbProtocol: http
 *         - instancePort: 8000
 *           instanceProtocol: http
 *           lbPort: 443
 *           lbProtocol: https
 *           sslCertificateId: arn:aws:iam::123456789012:server-certificate/certName
 *       healthCheck:
 *         healthyThreshold: 2
 *         unhealthyThreshold: 2
 *         timeout: 3
 *         target: HTTP:8000/
 *         interval: 30
 *       instances:
 *         - ${foo.id}
 *       crossZoneLoadBalancing: true
 *       idleTimeout: 400
 *       connectionDraining: true
 *       connectionDrainingTimeout: 400
 *       tags:
 *         Name: foobar-elb
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Note on ECDSA Key Algorithm
 * If the ARN of the `ssl_certificate_id` that is pointed to references a
 * certificate that was signed by an ECDSA key, note that ELB only supports the
 * P256 and P384 curves.  Using a certificate signed by a key using a different
 * curve could produce the error `ERR_SSL_VERSION_OR_CIPHER_MISMATCH` in your
 * browser.
 * ## Import
 * Using `pulumi import`, import ELBs using the `name`. For example:
 * ```sh
 * $ pulumi import aws:elb/loadBalancer:LoadBalancer bar elb-production-12345
 * ```
 */
public class LoadBalancer internal constructor(
    override val javaResource: com.pulumi.aws.elb.LoadBalancer,
) : KotlinCustomResource(javaResource, LoadBalancerMapper) {
    /**
     * An Access Logs block. Access Logs documented below.
     */
    public val accessLogs: Output<LoadBalancerAccessLogs>?
        get() = javaResource.accessLogs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loadBalancerAccessLogsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ARN of the ELB
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AZ's to serve traffic in.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Boolean to enable connection draining. Default: `false`
     */
    public val connectionDraining: Output<Boolean>?
        get() = javaResource.connectionDraining().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time in seconds to allow for connections to drain. Default: `300`
     */
    public val connectionDrainingTimeout: Output<Int>?
        get() = javaResource.connectionDrainingTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable cross-zone load balancing. Default: `true`
     */
    public val crossZoneLoadBalancing: Output<Boolean>?
        get() = javaResource.crossZoneLoadBalancing().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     */
    public val desyncMitigationMode: Output<String>?
        get() = javaResource.desyncMitigationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DNS name of the ELB
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * A health_check block. Health Check documented below.
     */
    public val healthCheck: Output<LoadBalancerHealthCheck>
        get() = javaResource.healthCheck().applyValue({ args0 ->
            args0.let({ args0 ->
                loadBalancerHealthCheckToKotlin(args0)
            })
        })

    /**
     * The time in seconds that the connection is allowed to be idle. Default: `60`
     */
    public val idleTimeout: Output<Int>?
        get() = javaResource.idleTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of instance ids to place in the ELB pool.
     */
    public val instances: Output<List<String>>
        get() = javaResource.instances().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * If true, ELB will be an internal ELB.
     */
    public val `internal`: Output<Boolean>
        get() = javaResource.`internal`().applyValue({ args0 -> args0 })

    /**
     * A list of listener blocks. Listeners documented below.
     */
    public val listeners: Output<List<LoadBalancerListener>>
        get() = javaResource.listeners().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    loadBalancerListenerToKotlin(args0)
                })
            })
        })

    /**
     * The name of the ELB. By default generated by this provider.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the security group that you can use as
     * part of your inbound rules for your load balancer's back-end application
     * instances. Use this for Classic or Default VPC only.
     */
    public val sourceSecurityGroup: Output<String>
        get() = javaResource.sourceSecurityGroup().applyValue({ args0 -> args0 })

    /**
     * The ID of the security group that you can use as
     * part of your inbound rules for your load balancer's back-end application
     * instances. Only available on ELBs launched in a VPC.
     */
    public val sourceSecurityGroupId: Output<String>
        get() = javaResource.sourceSecurityGroupId().applyValue({ args0 -> args0 })

    /**
     * A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    public val subnets: Output<List<String>>
        get() = javaResource.subnets().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The canonical hosted zone ID of the ELB (to be used in a Route 53 Alias record)
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object LoadBalancerMapper : ResourceMapper<LoadBalancer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elb.LoadBalancer::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancer = LoadBalancer(
        javaResource as
            com.pulumi.aws.elb.LoadBalancer,
    )
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancer].
 */
public suspend fun loadBalancer(
    name: String,
    block: suspend LoadBalancerResourceBuilder.() -> Unit,
): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancer(name: String): LoadBalancer {
    val builder = LoadBalancerResourceBuilder()
    builder.name(name)
    return builder.build()
}
