@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.LoadBalancerArgs.builder
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerAccessLogsArgs
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerAccessLogsArgsBuilder
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerHealthCheckArgs
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerHealthCheckArgsBuilder
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerListenerArgs
import com.pulumi.aws.elb.kotlin.inputs.LoadBalancerListenerArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Load Balancer resource, also known as a "Classic
 * Load Balancer" after the release of
 * Application/Network Load Balancers.
 * > **NOTE on ELB Instances and ELB Attachments:** This provider currently
 * provides both a standalone ELB Attachment resource
 * (describing an instance attached to an ELB), and an ELB resource with
 * `instances` defined in-line. At this time you cannot use an ELB with in-line
 * instances in conjunction with a ELB Attachment resources. Doing so will cause a
 * conflict and will overwrite attachments.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new load balancer
 * const bar = new aws.elb.LoadBalancer("bar", {
 *     name: "foobar-elb",
 *     availabilityZones: [
 *         "us-west-2a",
 *         "us-west-2b",
 *         "us-west-2c",
 *     ],
 *     accessLogs: {
 *         bucket: "foo",
 *         bucketPrefix: "bar",
 *         interval: 60,
 *     },
 *     listeners: [
 *         {
 *             instancePort: 8000,
 *             instanceProtocol: "http",
 *             lbPort: 80,
 *             lbProtocol: "http",
 *         },
 *         {
 *             instancePort: 8000,
 *             instanceProtocol: "http",
 *             lbPort: 443,
 *             lbProtocol: "https",
 *             sslCertificateId: "arn:aws:iam::123456789012:server-certificate/certName",
 *         },
 *     ],
 *     healthCheck: {
 *         healthyThreshold: 2,
 *         unhealthyThreshold: 2,
 *         timeout: 3,
 *         target: "HTTP:8000/",
 *         interval: 30,
 *     },
 *     instances: [foo&#46;id],
 *     crossZoneLoadBalancing: true,
 *     idleTimeout: 400,
 *     connectionDraining: true,
 *     connectionDrainingTimeout: 400,
 *     tags: {
 *         Name: "foobar-elb",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new load balancer
 * bar = aws.elb.LoadBalancer("bar",
 *     name="foobar-elb",
 *     availability_zones=[
 *         "us-west-2a",
 *         "us-west-2b",
 *         "us-west-2c",
 *     ],
 *     access_logs={
 *         "bucket": "foo",
 *         "bucket_prefix": "bar",
 *         "interval": 60,
 *     },
 *     listeners=[
 *         {
 *             "instance_port": 8000,
 *             "instance_protocol": "http",
 *             "lb_port": 80,
 *             "lb_protocol": "http",
 *         },
 *         {
 *             "instance_port": 8000,
 *             "instance_protocol": "http",
 *             "lb_port": 443,
 *             "lb_protocol": "https",
 *             "ssl_certificate_id": "arn:aws:iam::123456789012:server-certificate/certName",
 *         },
 *     ],
 *     health_check={
 *         "healthy_threshold": 2,
 *         "unhealthy_threshold": 2,
 *         "timeout": 3,
 *         "target": "HTTP:8000/",
 *         "interval": 30,
 *     },
 *     instances=[foo["id"]],
 *     cross_zone_load_balancing=True,
 *     idle_timeout=400,
 *     connection_draining=True,
 *     connection_draining_timeout=400,
 *     tags={
 *         "Name": "foobar-elb",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new load balancer
 *     var bar = new Aws.Elb.LoadBalancer("bar", new()
 *     {
 *         Name = "foobar-elb",
 *         AvailabilityZones = new[]
 *         {
 *             "us-west-2a",
 *             "us-west-2b",
 *             "us-west-2c",
 *         },
 *         AccessLogs = new Aws.Elb.Inputs.LoadBalancerAccessLogsArgs
 *         {
 *             Bucket = "foo",
 *             BucketPrefix = "bar",
 *             Interval = 60,
 *         },
 *         Listeners = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 8000,
 *                 InstanceProtocol = "http",
 *                 LbPort = 80,
 *                 LbProtocol = "http",
 *             },
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 8000,
 *                 InstanceProtocol = "http",
 *                 LbPort = 443,
 *                 LbProtocol = "https",
 *                 SslCertificateId = "arn:aws:iam::123456789012:server-certificate/certName",
 *             },
 *         },
 *         HealthCheck = new Aws.Elb.Inputs.LoadBalancerHealthCheckArgs
 *         {
 *             HealthyThreshold = 2,
 *             UnhealthyThreshold = 2,
 *             Timeout = 3,
 *             Target = "HTTP:8000/",
 *             Interval = 30,
 *         },
 *         Instances = new[]
 *         {
 *             foo.Id,
 *         },
 *         CrossZoneLoadBalancing = true,
 *         IdleTimeout = 400,
 *         ConnectionDraining = true,
 *         ConnectionDrainingTimeout = 400,
 *         Tags =
 *         {
 *             { "Name", "foobar-elb" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new load balancer
 * 		_, err := elb.NewLoadBalancer(ctx, "bar", &elb.LoadBalancerArgs{
 * 			Name: pulumi.String("foobar-elb"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-west-2a"),
 * 				pulumi.String("us-west-2b"),
 * 				pulumi.String("us-west-2c"),
 * 			},
 * 			AccessLogs: &elb.LoadBalancerAccessLogsArgs{
 * 				Bucket:       pulumi.String("foo"),
 * 				BucketPrefix: pulumi.String("bar"),
 * 				Interval:     pulumi.Int(60),
 * 			},
 * 			Listeners: elb.LoadBalancerListenerArray{
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(8000),
 * 					InstanceProtocol: pulumi.String("http"),
 * 					LbPort:           pulumi.Int(80),
 * 					LbProtocol:       pulumi.String("http"),
 * 				},
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(8000),
 * 					InstanceProtocol: pulumi.String("http"),
 * 					LbPort:           pulumi.Int(443),
 * 					LbProtocol:       pulumi.String("https"),
 * 					SslCertificateId: pulumi.String("arn:aws:iam::123456789012:server-certificate/certName"),
 * 				},
 * 			},
 * 			HealthCheck: &elb.LoadBalancerHealthCheckArgs{
 * 				HealthyThreshold:   pulumi.Int(2),
 * 				UnhealthyThreshold: pulumi.Int(2),
 * 				Timeout:            pulumi.Int(3),
 * 				Target:             pulumi.String("HTTP:8000/"),
 * 				Interval:           pulumi.Int(30),
 * 			},
 * 			Instances: pulumi.StringArray{
 * 				foo.Id,
 * 			},
 * 			CrossZoneLoadBalancing:    pulumi.Bool(true),
 * 			IdleTimeout:               pulumi.Int(400),
 * 			ConnectionDraining:        pulumi.Bool(true),
 * 			ConnectionDrainingTimeout: pulumi.Int(400),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("foobar-elb"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerAccessLogsArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerHealthCheckArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new load balancer
 *         var bar = new LoadBalancer("bar", LoadBalancerArgs.builder()
 *             .name("foobar-elb")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .accessLogs(LoadBalancerAccessLogsArgs.builder()
 *                 .bucket("foo")
 *                 .bucketPrefix("bar")
 *                 .interval(60)
 *                 .build())
 *             .listeners(
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(8000)
 *                     .instanceProtocol("http")
 *                     .lbPort(80)
 *                     .lbProtocol("http")
 *                     .build(),
 *                 LoadBalancerListenerArgs.builder()
 *                     .instancePort(8000)
 *                     .instanceProtocol("http")
 *                     .lbPort(443)
 *                     .lbProtocol("https")
 *                     .sslCertificateId("arn:aws:iam::123456789012:server-certificate/certName")
 *                     .build())
 *             .healthCheck(LoadBalancerHealthCheckArgs.builder()
 *                 .healthyThreshold(2)
 *                 .unhealthyThreshold(2)
 *                 .timeout(3)
 *                 .target("HTTP:8000/")
 *                 .interval(30)
 *                 .build())
 *             .instances(foo.id())
 *             .crossZoneLoadBalancing(true)
 *             .idleTimeout(400)
 *             .connectionDraining(true)
 *             .connectionDrainingTimeout(400)
 *             .tags(Map.of("Name", "foobar-elb"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new load balancer
 *   bar:
 *     type: aws:elb:LoadBalancer
 *     properties:
 *       name: foobar-elb
 *       availabilityZones:
 *         - us-west-2a
 *         - us-west-2b
 *         - us-west-2c
 *       accessLogs:
 *         bucket: foo
 *         bucketPrefix: bar
 *         interval: 60
 *       listeners:
 *         - instancePort: 8000
 *           instanceProtocol: http
 *           lbPort: 80
 *           lbProtocol: http
 *         - instancePort: 8000
 *           instanceProtocol: http
 *           lbPort: 443
 *           lbProtocol: https
 *           sslCertificateId: arn:aws:iam::123456789012:server-certificate/certName
 *       healthCheck:
 *         healthyThreshold: 2
 *         unhealthyThreshold: 2
 *         timeout: 3
 *         target: HTTP:8000/
 *         interval: 30
 *       instances:
 *         - ${foo.id}
 *       crossZoneLoadBalancing: true
 *       idleTimeout: 400
 *       connectionDraining: true
 *       connectionDrainingTimeout: 400
 *       tags:
 *         Name: foobar-elb
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Note on ECDSA Key Algorithm
 * If the ARN of the `ssl_certificate_id` that is pointed to references a
 * certificate that was signed by an ECDSA key, note that ELB only supports the
 * P256 and P384 curves.  Using a certificate signed by a key using a different
 * curve could produce the error `ERR_SSL_VERSION_OR_CIPHER_MISMATCH` in your
 * browser.
 * ## Import
 * Using `pulumi import`, import ELBs using the `name`. For example:
 * ```sh
 * $ pulumi import aws:elb/loadBalancer:LoadBalancer bar elb-production-12345
 * ```
 * @property accessLogs An Access Logs block. Access Logs documented below.
 * @property availabilityZones The AZ's to serve traffic in.
 * @property connectionDraining Boolean to enable connection draining. Default: `false`
 * @property connectionDrainingTimeout The time in seconds to allow for connections to drain. Default: `300`
 * @property crossZoneLoadBalancing Enable cross-zone load balancing. Default: `true`
 * @property desyncMitigationMode Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
 * @property healthCheck A health_check block. Health Check documented below.
 * @property idleTimeout The time in seconds that the connection is allowed to be idle. Default: `60`
 * @property instances A list of instance ids to place in the ELB pool.
 * @property internal If true, ELB will be an internal ELB.
 * @property listeners A list of listener blocks. Listeners documented below.
 * @property name The name of the ELB. By default generated by this provider.
 * @property namePrefix Creates a unique name beginning with the specified
 * prefix. Conflicts with `name`.
 * @property securityGroups A list of security group IDs to assign to the ELB.
 * Only valid if creating an ELB within a VPC
 * @property sourceSecurityGroup The name of the security group that you can use as
 * part of your inbound rules for your load balancer's back-end application
 * instances. Use this for Classic or Default VPC only.
 * @property subnets A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * Exactly one of `availability_zones` or `subnets` must be specified: this
 * determines if the ELB exists in a VPC or in EC2-classic.
 */
public data class LoadBalancerArgs(
    public val accessLogs: Output<LoadBalancerAccessLogsArgs>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val connectionDraining: Output<Boolean>? = null,
    public val connectionDrainingTimeout: Output<Int>? = null,
    public val crossZoneLoadBalancing: Output<Boolean>? = null,
    public val desyncMitigationMode: Output<String>? = null,
    public val healthCheck: Output<LoadBalancerHealthCheckArgs>? = null,
    public val idleTimeout: Output<Int>? = null,
    public val instances: Output<List<String>>? = null,
    public val `internal`: Output<Boolean>? = null,
    public val listeners: Output<List<LoadBalancerListenerArgs>>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val sourceSecurityGroup: Output<String>? = null,
    public val subnets: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.LoadBalancerArgs> {
    override fun toJava(): com.pulumi.aws.elb.LoadBalancerArgs =
        com.pulumi.aws.elb.LoadBalancerArgs.builder()
            .accessLogs(accessLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectionDraining(connectionDraining?.applyValue({ args0 -> args0 }))
            .connectionDrainingTimeout(connectionDrainingTimeout?.applyValue({ args0 -> args0 }))
            .crossZoneLoadBalancing(crossZoneLoadBalancing?.applyValue({ args0 -> args0 }))
            .desyncMitigationMode(desyncMitigationMode?.applyValue({ args0 -> args0 }))
            .healthCheck(healthCheck?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .idleTimeout(idleTimeout?.applyValue({ args0 -> args0 }))
            .instances(instances?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`internal`(`internal`?.applyValue({ args0 -> args0 }))
            .listeners(
                listeners?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceSecurityGroup(sourceSecurityGroup?.applyValue({ args0 -> args0 }))
            .subnets(subnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LoadBalancerArgs].
 */
@PulumiTagMarker
public class LoadBalancerArgsBuilder internal constructor() {
    private var accessLogs: Output<LoadBalancerAccessLogsArgs>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var connectionDraining: Output<Boolean>? = null

    private var connectionDrainingTimeout: Output<Int>? = null

    private var crossZoneLoadBalancing: Output<Boolean>? = null

    private var desyncMitigationMode: Output<String>? = null

    private var healthCheck: Output<LoadBalancerHealthCheckArgs>? = null

    private var idleTimeout: Output<Int>? = null

    private var instances: Output<List<String>>? = null

    private var `internal`: Output<Boolean>? = null

    private var listeners: Output<List<LoadBalancerListenerArgs>>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var sourceSecurityGroup: Output<String>? = null

    private var subnets: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value An Access Logs block. Access Logs documented below.
     */
    @JvmName("pndgedpmunraqjpd")
    public suspend fun accessLogs(`value`: Output<LoadBalancerAccessLogsArgs>) {
        this.accessLogs = value
    }

    /**
     * @param value The AZ's to serve traffic in.
     */
    @JvmName("nkadtomrbqwyyfnj")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("dtlmbsgnkpgxqgal")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values The AZ's to serve traffic in.
     */
    @JvmName("astywwoqrhigdodw")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value Boolean to enable connection draining. Default: `false`
     */
    @JvmName("atmboseeeuqynrat")
    public suspend fun connectionDraining(`value`: Output<Boolean>) {
        this.connectionDraining = value
    }

    /**
     * @param value The time in seconds to allow for connections to drain. Default: `300`
     */
    @JvmName("bwqdvvfvvhdymhdc")
    public suspend fun connectionDrainingTimeout(`value`: Output<Int>) {
        this.connectionDrainingTimeout = value
    }

    /**
     * @param value Enable cross-zone load balancing. Default: `true`
     */
    @JvmName("upblfwottqdxjmhg")
    public suspend fun crossZoneLoadBalancing(`value`: Output<Boolean>) {
        this.crossZoneLoadBalancing = value
    }

    /**
     * @param value Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     */
    @JvmName("akncrcvrvudekdic")
    public suspend fun desyncMitigationMode(`value`: Output<String>) {
        this.desyncMitigationMode = value
    }

    /**
     * @param value A health_check block. Health Check documented below.
     */
    @JvmName("vlosrawxrnfbkxrx")
    public suspend fun healthCheck(`value`: Output<LoadBalancerHealthCheckArgs>) {
        this.healthCheck = value
    }

    /**
     * @param value The time in seconds that the connection is allowed to be idle. Default: `60`
     */
    @JvmName("pvekvikuihbywubb")
    public suspend fun idleTimeout(`value`: Output<Int>) {
        this.idleTimeout = value
    }

    /**
     * @param value A list of instance ids to place in the ELB pool.
     */
    @JvmName("kcqcsndmaqjlflpb")
    public suspend fun instances(`value`: Output<List<String>>) {
        this.instances = value
    }

    @JvmName("kfjgcmdllanwrlhy")
    public suspend fun instances(vararg values: Output<String>) {
        this.instances = Output.all(values.asList())
    }

    /**
     * @param values A list of instance ids to place in the ELB pool.
     */
    @JvmName("yprurlidtjkoudhb")
    public suspend fun instances(values: List<Output<String>>) {
        this.instances = Output.all(values)
    }

    /**
     * @param value If true, ELB will be an internal ELB.
     */
    @JvmName("ohkmejvxcbpnfpue")
    public suspend fun `internal`(`value`: Output<Boolean>) {
        this.`internal` = value
    }

    /**
     * @param value A list of listener blocks. Listeners documented below.
     */
    @JvmName("wwqqhymnvnvxncdd")
    public suspend fun listeners(`value`: Output<List<LoadBalancerListenerArgs>>) {
        this.listeners = value
    }

    @JvmName("ibbbtrgjeywaaiuj")
    public suspend fun listeners(vararg values: Output<LoadBalancerListenerArgs>) {
        this.listeners = Output.all(values.asList())
    }

    /**
     * @param values A list of listener blocks. Listeners documented below.
     */
    @JvmName("sxufnsnpdlaohaxe")
    public suspend fun listeners(values: List<Output<LoadBalancerListenerArgs>>) {
        this.listeners = Output.all(values)
    }

    /**
     * @param value The name of the ELB. By default generated by this provider.
     */
    @JvmName("pjcphxyitxaimbdy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("bsolgnkmwhoipnkq")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    @JvmName("kugtosujoauynkir")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("mgtolgtqlqogplfc")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    @JvmName("ferdnjcdrarrjkcg")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The name of the security group that you can use as
     * part of your inbound rules for your load balancer's back-end application
     * instances. Use this for Classic or Default VPC only.
     */
    @JvmName("grmmkocxotpouocr")
    public suspend fun sourceSecurityGroup(`value`: Output<String>) {
        this.sourceSecurityGroup = value
    }

    /**
     * @param value A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    @JvmName("vkajjrsbbeeymljh")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("cpkivkvtuanwjotp")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    @JvmName("vkuktestkxqcpfmd")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     */
    @JvmName("rsylntojenpgvobe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value An Access Logs block. Access Logs documented below.
     */
    @JvmName("xntyljkgeeigrbin")
    public suspend fun accessLogs(`value`: LoadBalancerAccessLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLogs = mapped
    }

    /**
     * @param argument An Access Logs block. Access Logs documented below.
     */
    @JvmName("suirclxrylkvtcal")
    public suspend fun accessLogs(argument: suspend LoadBalancerAccessLogsArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerAccessLogsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.accessLogs = mapped
    }

    /**
     * @param value The AZ's to serve traffic in.
     */
    @JvmName("ihuweawwfytsvxyt")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values The AZ's to serve traffic in.
     */
    @JvmName("yayvnlkkgqmeyjrb")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value Boolean to enable connection draining. Default: `false`
     */
    @JvmName("mvgvskwmtkgnvvph")
    public suspend fun connectionDraining(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionDraining = mapped
    }

    /**
     * @param value The time in seconds to allow for connections to drain. Default: `300`
     */
    @JvmName("lnwejnxmrmamkfwx")
    public suspend fun connectionDrainingTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionDrainingTimeout = mapped
    }

    /**
     * @param value Enable cross-zone load balancing. Default: `true`
     */
    @JvmName("itowlnpseqykhxrc")
    public suspend fun crossZoneLoadBalancing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossZoneLoadBalancing = mapped
    }

    /**
     * @param value Determines how the load balancer handles requests that might pose a security risk to an application due to HTTP desync. Valid values are `monitor`, `defensive` (default), `strictest`.
     */
    @JvmName("cjihwmeiamylvjpa")
    public suspend fun desyncMitigationMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desyncMitigationMode = mapped
    }

    /**
     * @param value A health_check block. Health Check documented below.
     */
    @JvmName("ggwbtjucjbschjad")
    public suspend fun healthCheck(`value`: LoadBalancerHealthCheckArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheck = mapped
    }

    /**
     * @param argument A health_check block. Health Check documented below.
     */
    @JvmName("jlqwhiasijposkyw")
    public suspend fun healthCheck(argument: suspend LoadBalancerHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped = LoadBalancerHealthCheckArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheck = mapped
    }

    /**
     * @param value The time in seconds that the connection is allowed to be idle. Default: `60`
     */
    @JvmName("spjvcrkvfuetuyas")
    public suspend fun idleTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleTimeout = mapped
    }

    /**
     * @param value A list of instance ids to place in the ELB pool.
     */
    @JvmName("dqrtmxctbwxivmrp")
    public suspend fun instances(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param values A list of instance ids to place in the ELB pool.
     */
    @JvmName("sovmdwhuioevpyfs")
    public suspend fun instances(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value If true, ELB will be an internal ELB.
     */
    @JvmName("gecaeoylrigxmagp")
    public suspend fun `internal`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`internal` = mapped
    }

    /**
     * @param value A list of listener blocks. Listeners documented below.
     */
    @JvmName("fffiicqbvumoqvvp")
    public suspend fun listeners(`value`: List<LoadBalancerListenerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param argument A list of listener blocks. Listeners documented below.
     */
    @JvmName("kfrxymqolymyhqsb")
    public suspend fun listeners(argument: List<suspend LoadBalancerListenerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LoadBalancerListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument A list of listener blocks. Listeners documented below.
     */
    @JvmName("lwhqosmjbjkjyjcd")
    public suspend fun listeners(vararg argument: suspend LoadBalancerListenerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LoadBalancerListenerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param argument A list of listener blocks. Listeners documented below.
     */
    @JvmName("idueplwvhoubhfgr")
    public suspend fun listeners(argument: suspend LoadBalancerListenerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LoadBalancerListenerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.listeners = mapped
    }

    /**
     * @param values A list of listener blocks. Listeners documented below.
     */
    @JvmName("bqwxugwjenrrrrci")
    public suspend fun listeners(vararg values: LoadBalancerListenerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listeners = mapped
    }

    /**
     * @param value The name of the ELB. By default generated by this provider.
     */
    @JvmName("noywblejqhalujma")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified
     * prefix. Conflicts with `name`.
     */
    @JvmName("tfkrohrjrarpjteh")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    @JvmName("yviqcxabprddkjef")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group IDs to assign to the ELB.
     * Only valid if creating an ELB within a VPC
     */
    @JvmName("hquhacpdispmfhjr")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The name of the security group that you can use as
     * part of your inbound rules for your load balancer's back-end application
     * instances. Use this for Classic or Default VPC only.
     */
    @JvmName("veucglpitkmaviqc")
    public suspend fun sourceSecurityGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSecurityGroup = mapped
    }

    /**
     * @param value A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    @JvmName("pvuihfjqqixxxipd")
    public suspend fun subnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values A list of subnet IDs to attach to the ELB. When an update to subnets will remove all current subnets, this will force a new resource.
     */
    @JvmName("iinbtmykatapxkqn")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     */
    @JvmName("aaqdomnalunydgss")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * Exactly one of `availability_zones` or `subnets` must be specified: this
     * determines if the ELB exists in a VPC or in EC2-classic.
     */
    @JvmName("saovdoqhyofknkmw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LoadBalancerArgs = LoadBalancerArgs(
        accessLogs = accessLogs,
        availabilityZones = availabilityZones,
        connectionDraining = connectionDraining,
        connectionDrainingTimeout = connectionDrainingTimeout,
        crossZoneLoadBalancing = crossZoneLoadBalancing,
        desyncMitigationMode = desyncMitigationMode,
        healthCheck = healthCheck,
        idleTimeout = idleTimeout,
        instances = instances,
        `internal` = `internal`,
        listeners = listeners,
        name = name,
        namePrefix = namePrefix,
        securityGroups = securityGroups,
        sourceSecurityGroup = sourceSecurityGroup,
        subnets = subnets,
        tags = tags,
    )
}
