@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [LoadBalancerBackendServerPolicy].
 */
@PulumiTagMarker
public class LoadBalancerBackendServerPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LoadBalancerBackendServerPolicyArgs = LoadBalancerBackendServerPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LoadBalancerBackendServerPolicyArgsBuilder.() -> Unit) {
        val builder = LoadBalancerBackendServerPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): LoadBalancerBackendServerPolicy {
        val builtJavaResource =
            com.pulumi.aws.elb.LoadBalancerBackendServerPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LoadBalancerBackendServerPolicy(builtJavaResource)
    }
}

/**
 * Attaches a load balancer policy to an ELB backend server.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const wu_tang = new aws.elb.LoadBalancer("wu-tang", {
 *     name: "wu-tang",
 *     availabilityZones: ["us-east-1a"],
 *     listeners: [{
 *         instancePort: 443,
 *         instanceProtocol: "http",
 *         lbPort: 443,
 *         lbProtocol: "https",
 *         sslCertificateId: "arn:aws:iam::000000000000:server-certificate/wu-tang.net",
 *     }],
 *     tags: {
 *         Name: "wu-tang",
 *     },
 * });
 * const wu_tang_ca_pubkey_policy = new aws.elb.LoadBalancerPolicy("wu-tang-ca-pubkey-policy", {
 *     loadBalancerName: wu_tang.name,
 *     policyName: "wu-tang-ca-pubkey-policy",
 *     policyTypeName: "PublicKeyPolicyType",
 *     policyAttributes: [{
 *         name: "PublicKey",
 *         value: std.file({
 *             input: "wu-tang-pubkey",
 *         }).then(invoke => invoke.result),
 *     }],
 * });
 * const wu_tang_root_ca_backend_auth_policy = new aws.elb.LoadBalancerPolicy("wu-tang-root-ca-backend-auth-policy", {
 *     loadBalancerName: wu_tang.name,
 *     policyName: "wu-tang-root-ca-backend-auth-policy",
 *     policyTypeName: "BackendServerAuthenticationPolicyType",
 *     policyAttributes: [{
 *         name: "PublicKeyPolicyName",
 *         value: wu_tang_root_ca_pubkey_policy.policyName,
 *     }],
 * });
 * const wu_tang_backend_auth_policies_443 = new aws.elb.LoadBalancerBackendServerPolicy("wu-tang-backend-auth-policies-443", {
 *     loadBalancerName: wu_tang.name,
 *     instancePort: 443,
 *     policyNames: [wu_tang_root_ca_backend_auth_policy&#46;policyName],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * wu_tang = aws.elb.LoadBalancer("wu-tang",
 *     name="wu-tang",
 *     availability_zones=["us-east-1a"],
 *     listeners=[{
 *         "instance_port": 443,
 *         "instance_protocol": "http",
 *         "lb_port": 443,
 *         "lb_protocol": "https",
 *         "ssl_certificate_id": "arn:aws:iam::000000000000:server-certificate/wu-tang.net",
 *     }],
 *     tags={
 *         "Name": "wu-tang",
 *     })
 * wu_tang_ca_pubkey_policy = aws.elb.LoadBalancerPolicy("wu-tang-ca-pubkey-policy",
 *     load_balancer_name=wu_tang.name,
 *     policy_name="wu-tang-ca-pubkey-policy",
 *     policy_type_name="PublicKeyPolicyType",
 *     policy_attributes=[{
 *         "name": "PublicKey",
 *         "value": std.file(input="wu-tang-pubkey").result,
 *     }])
 * wu_tang_root_ca_backend_auth_policy = aws.elb.LoadBalancerPolicy("wu-tang-root-ca-backend-auth-policy",
 *     load_balancer_name=wu_tang.name,
 *     policy_name="wu-tang-root-ca-backend-auth-policy",
 *     policy_type_name="BackendServerAuthenticationPolicyType",
 *     policy_attributes=[{
 *         "name": "PublicKeyPolicyName",
 *         "value": wu_tang_root_ca_pubkey_policy["policyName"],
 *     }])
 * wu_tang_backend_auth_policies_443 = aws.elb.LoadBalancerBackendServerPolicy("wu-tang-backend-auth-policies-443",
 *     load_balancer_name=wu_tang.name,
 *     instance_port=443,
 *     policy_names=[wu_tang_root_ca_backend_auth_policy&#46;policy_name])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var wu_tang = new Aws.Elb.LoadBalancer("wu-tang", new()
 *     {
 *         Name = "wu-tang",
 *         AvailabilityZones = new[]
 *         {
 *             "us-east-1a",
 *         },
 *         Listeners = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 443,
 *                 InstanceProtocol = "http",
 *                 LbPort = 443,
 *                 LbProtocol = "https",
 *                 SslCertificateId = "arn:aws:iam::000000000000:server-certificate/wu-tang.net",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "wu-tang" },
 *         },
 *     });
 *     var wu_tang_ca_pubkey_policy = new Aws.Elb.LoadBalancerPolicy("wu-tang-ca-pubkey-policy", new()
 *     {
 *         LoadBalancerName = wu_tang.Name,
 *         PolicyName = "wu-tang-ca-pubkey-policy",
 *         PolicyTypeName = "PublicKeyPolicyType",
 *         PolicyAttributes = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerPolicyPolicyAttributeArgs
 *             {
 *                 Name = "PublicKey",
 *                 Value = Std.File.Invoke(new()
 *                 {
 *                     Input = "wu-tang-pubkey",
 *                 }).Apply(invoke => invoke.Result),
 *             },
 *         },
 *     });
 *     var wu_tang_root_ca_backend_auth_policy = new Aws.Elb.LoadBalancerPolicy("wu-tang-root-ca-backend-auth-policy", new()
 *     {
 *         LoadBalancerName = wu_tang.Name,
 *         PolicyName = "wu-tang-root-ca-backend-auth-policy",
 *         PolicyTypeName = "BackendServerAuthenticationPolicyType",
 *         PolicyAttributes = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerPolicyPolicyAttributeArgs
 *             {
 *                 Name = "PublicKeyPolicyName",
 *                 Value = wu_tang_root_ca_pubkey_policy.PolicyName,
 *             },
 *         },
 *     });
 *     var wu_tang_backend_auth_policies_443 = new Aws.Elb.LoadBalancerBackendServerPolicy("wu-tang-backend-auth-policies-443", new()
 *     {
 *         LoadBalancerName = wu_tang.Name,
 *         InstancePort = 443,
 *         PolicyNames = new[]
 *         {
 *             wu_tang_root_ca_backend_auth_policy.PolicyName,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elb.NewLoadBalancer(ctx, "wu-tang", &elb.LoadBalancerArgs{
 * 			Name: pulumi.String("wu-tang"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-east-1a"),
 * 			},
 * 			Listeners: elb.LoadBalancerListenerArray{
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(443),
 * 					InstanceProtocol: pulumi.String("http"),
 * 					LbPort:           pulumi.Int(443),
 * 					LbProtocol:       pulumi.String("https"),
 * 					SslCertificateId: pulumi.String("arn:aws:iam::000000000000:server-certificate/wu-tang.net"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("wu-tang"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "wu-tang-pubkey",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elb.NewLoadBalancerPolicy(ctx, "wu-tang-ca-pubkey-policy", &elb.LoadBalancerPolicyArgs{
 * 			LoadBalancerName: wu_tang.Name,
 * 			PolicyName:       pulumi.String("wu-tang-ca-pubkey-policy"),
 * 			PolicyTypeName:   pulumi.String("PublicKeyPolicyType"),
 * 			PolicyAttributes: elb.LoadBalancerPolicyPolicyAttributeArray{
 * 				&elb.LoadBalancerPolicyPolicyAttributeArgs{
 * 					Name:  pulumi.String("PublicKey"),
 * 					Value: pulumi.String(invokeFile.Result),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elb.NewLoadBalancerPolicy(ctx, "wu-tang-root-ca-backend-auth-policy", &elb.LoadBalancerPolicyArgs{
 * 			LoadBalancerName: wu_tang.Name,
 * 			PolicyName:       pulumi.String("wu-tang-root-ca-backend-auth-policy"),
 * 			PolicyTypeName:   pulumi.String("BackendServerAuthenticationPolicyType"),
 * 			PolicyAttributes: elb.LoadBalancerPolicyPolicyAttributeArray{
 * 				&elb.LoadBalancerPolicyPolicyAttributeArgs{
 * 					Name:  pulumi.String("PublicKeyPolicyName"),
 * 					Value: pulumi.Any(wu_tang_root_ca_pubkey_policy.PolicyName),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elb.NewLoadBalancerBackendServerPolicy(ctx, "wu-tang-backend-auth-policies-443", &elb.LoadBalancerBackendServerPolicyArgs{
 * 			LoadBalancerName: wu_tang.Name,
 * 			InstancePort:     pulumi.Int(443),
 * 			PolicyNames: pulumi.StringArray{
 * 				wu_tang_root_ca_backend_auth_policy.PolicyName,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerPolicyArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerPolicyPolicyAttributeArgs;
 * import com.pulumi.aws.elb.LoadBalancerBackendServerPolicy;
 * import com.pulumi.aws.elb.LoadBalancerBackendServerPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var wu_tang = new LoadBalancer("wu-tang", LoadBalancerArgs.builder()
 *             .name("wu-tang")
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(443)
 *                 .instanceProtocol("http")
 *                 .lbPort(443)
 *                 .lbProtocol("https")
 *                 .sslCertificateId("arn:aws:iam::000000000000:server-certificate/wu-tang.net")
 *                 .build())
 *             .tags(Map.of("Name", "wu-tang"))
 *             .build());
 *         var wu_tang_ca_pubkey_policy = new LoadBalancerPolicy("wu-tang-ca-pubkey-policy", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-ca-pubkey-policy")
 *             .policyTypeName("PublicKeyPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("PublicKey")
 *                 .value(StdFunctions.file(FileArgs.builder()
 *                     .input("wu-tang-pubkey")
 *                     .build()).result())
 *                 .build())
 *             .build());
 *         var wu_tang_root_ca_backend_auth_policy = new LoadBalancerPolicy("wu-tang-root-ca-backend-auth-policy", LoadBalancerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .policyName("wu-tang-root-ca-backend-auth-policy")
 *             .policyTypeName("BackendServerAuthenticationPolicyType")
 *             .policyAttributes(LoadBalancerPolicyPolicyAttributeArgs.builder()
 *                 .name("PublicKeyPolicyName")
 *                 .value(wu_tang_root_ca_pubkey_policy.policyName())
 *                 .build())
 *             .build());
 *         var wu_tang_backend_auth_policies_443 = new LoadBalancerBackendServerPolicy("wu-tang-backend-auth-policies-443", LoadBalancerBackendServerPolicyArgs.builder()
 *             .loadBalancerName(wu_tang.name())
 *             .instancePort(443)
 *             .policyNames(wu_tang_root_ca_backend_auth_policy.policyName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   wu-tang:
 *     type: aws:elb:LoadBalancer
 *     properties:
 *       name: wu-tang
 *       availabilityZones:
 *         - us-east-1a
 *       listeners:
 *         - instancePort: 443
 *           instanceProtocol: http
 *           lbPort: 443
 *           lbProtocol: https
 *           sslCertificateId: arn:aws:iam::000000000000:server-certificate/wu-tang.net
 *       tags:
 *         Name: wu-tang
 *   wu-tang-ca-pubkey-policy:
 *     type: aws:elb:LoadBalancerPolicy
 *     properties:
 *       loadBalancerName: ${["wu-tang"].name}
 *       policyName: wu-tang-ca-pubkey-policy
 *       policyTypeName: PublicKeyPolicyType
 *       policyAttributes:
 *         - name: PublicKey
 *           value:
 *             fn::invoke:
 *               Function: std:file
 *               Arguments:
 *                 input: wu-tang-pubkey
 *               Return: result
 *   wu-tang-root-ca-backend-auth-policy:
 *     type: aws:elb:LoadBalancerPolicy
 *     properties:
 *       loadBalancerName: ${["wu-tang"].name}
 *       policyName: wu-tang-root-ca-backend-auth-policy
 *       policyTypeName: BackendServerAuthenticationPolicyType
 *       policyAttributes:
 *         - name: PublicKeyPolicyName
 *           value: ${["wu-tang-root-ca-pubkey-policy"].policyName}
 *   wu-tang-backend-auth-policies-443:
 *     type: aws:elb:LoadBalancerBackendServerPolicy
 *     properties:
 *       loadBalancerName: ${["wu-tang"].name}
 *       instancePort: 443
 *       policyNames:
 *         - ${["wu-tang-root-ca-backend-auth-policy"].policyName}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class LoadBalancerBackendServerPolicy internal constructor(
    override val javaResource: com.pulumi.aws.elb.LoadBalancerBackendServerPolicy,
) : KotlinCustomResource(javaResource, LoadBalancerBackendServerPolicyMapper) {
    /**
     * The instance port to apply the policy to.
     */
    public val instancePort: Output<Int>
        get() = javaResource.instancePort().applyValue({ args0 -> args0 })

    /**
     * The load balancer to attach the policy to.
     */
    public val loadBalancerName: Output<String>
        get() = javaResource.loadBalancerName().applyValue({ args0 -> args0 })

    /**
     * List of Policy Names to apply to the backend server.
     */
    public val policyNames: Output<List<String>>?
        get() = javaResource.policyNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object LoadBalancerBackendServerPolicyMapper :
    ResourceMapper<LoadBalancerBackendServerPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elb.LoadBalancerBackendServerPolicy::class == javaResource::class

    override fun map(javaResource: Resource): LoadBalancerBackendServerPolicy =
        LoadBalancerBackendServerPolicy(
            javaResource as
                com.pulumi.aws.elb.LoadBalancerBackendServerPolicy,
        )
}

/**
 * @see [LoadBalancerBackendServerPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LoadBalancerBackendServerPolicy].
 */
public suspend fun loadBalancerBackendServerPolicy(
    name: String,
    block: suspend LoadBalancerBackendServerPolicyResourceBuilder.() -> Unit,
): LoadBalancerBackendServerPolicy {
    val builder = LoadBalancerBackendServerPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LoadBalancerBackendServerPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun loadBalancerBackendServerPolicy(name: String): LoadBalancerBackendServerPolicy {
    val builder = LoadBalancerBackendServerPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
