@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin

import com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a load balancer cookie stickiness policy, which allows an ELB to control the sticky session lifetime of the browser.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const lb = new aws.elb.LoadBalancer("lb", {
 *     name: "test-lb",
 *     availabilityZones: ["us-east-1a"],
 *     listeners: [{
 *         instancePort: 8000,
 *         instanceProtocol: "http",
 *         lbPort: 80,
 *         lbProtocol: "http",
 *     }],
 * });
 * const foo = new aws.elb.LoadBalancerCookieStickinessPolicy("foo", {
 *     name: "foo-policy",
 *     loadBalancer: lb.id,
 *     lbPort: 80,
 *     cookieExpirationPeriod: 600,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * lb = aws.elb.LoadBalancer("lb",
 *     name="test-lb",
 *     availability_zones=["us-east-1a"],
 *     listeners=[{
 *         "instance_port": 8000,
 *         "instance_protocol": "http",
 *         "lb_port": 80,
 *         "lb_protocol": "http",
 *     }])
 * foo = aws.elb.LoadBalancerCookieStickinessPolicy("foo",
 *     name="foo-policy",
 *     load_balancer=lb.id,
 *     lb_port=80,
 *     cookie_expiration_period=600)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lb = new Aws.Elb.LoadBalancer("lb", new()
 *     {
 *         Name = "test-lb",
 *         AvailabilityZones = new[]
 *         {
 *             "us-east-1a",
 *         },
 *         Listeners = new[]
 *         {
 *             new Aws.Elb.Inputs.LoadBalancerListenerArgs
 *             {
 *                 InstancePort = 8000,
 *                 InstanceProtocol = "http",
 *                 LbPort = 80,
 *                 LbProtocol = "http",
 *             },
 *         },
 *     });
 *     var foo = new Aws.Elb.LoadBalancerCookieStickinessPolicy("foo", new()
 *     {
 *         Name = "foo-policy",
 *         LoadBalancer = lb.Id,
 *         LbPort = 80,
 *         CookieExpirationPeriod = 600,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		lb, err := elb.NewLoadBalancer(ctx, "lb", &elb.LoadBalancerArgs{
 * 			Name: pulumi.String("test-lb"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-east-1a"),
 * 			},
 * 			Listeners: elb.LoadBalancerListenerArray{
 * 				&elb.LoadBalancerListenerArgs{
 * 					InstancePort:     pulumi.Int(8000),
 * 					InstanceProtocol: pulumi.String("http"),
 * 					LbPort:           pulumi.Int(80),
 * 					LbProtocol:       pulumi.String("http"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elb.NewLoadBalancerCookieStickinessPolicy(ctx, "foo", &elb.LoadBalancerCookieStickinessPolicyArgs{
 * 			Name:                   pulumi.String("foo-policy"),
 * 			LoadBalancer:           lb.ID(),
 * 			LbPort:                 pulumi.Int(80),
 * 			CookieExpirationPeriod: pulumi.Int(600),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elb.LoadBalancer;
 * import com.pulumi.aws.elb.LoadBalancerArgs;
 * import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs;
 * import com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicy;
 * import com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new LoadBalancer("lb", LoadBalancerArgs.builder()
 *             .name("test-lb")
 *             .availabilityZones("us-east-1a")
 *             .listeners(LoadBalancerListenerArgs.builder()
 *                 .instancePort(8000)
 *                 .instanceProtocol("http")
 *                 .lbPort(80)
 *                 .lbProtocol("http")
 *                 .build())
 *             .build());
 *         var foo = new LoadBalancerCookieStickinessPolicy("foo", LoadBalancerCookieStickinessPolicyArgs.builder()
 *             .name("foo-policy")
 *             .loadBalancer(lb.id())
 *             .lbPort(80)
 *             .cookieExpirationPeriod(600)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   lb:
 *     type: aws:elb:LoadBalancer
 *     properties:
 *       name: test-lb
 *       availabilityZones:
 *         - us-east-1a
 *       listeners:
 *         - instancePort: 8000
 *           instanceProtocol: http
 *           lbPort: 80
 *           lbProtocol: http
 *   foo:
 *     type: aws:elb:LoadBalancerCookieStickinessPolicy
 *     properties:
 *       name: foo-policy
 *       loadBalancer: ${lb.id}
 *       lbPort: 80
 *       cookieExpirationPeriod: 600
 * ```
 * <!--End PulumiCodeChooser -->
 * @property cookieExpirationPeriod The time period after which
 * the session cookie should be considered stale, expressed in seconds.
 * @property lbPort The load balancer port to which the policy
 * should be applied. This must be an active listener on the load
 * balancer.
 * @property loadBalancer The load balancer to which the policy
 * should be attached.
 * @property name The name of the stickiness policy.
 */
public data class LoadBalancerCookieStickinessPolicyArgs(
    public val cookieExpirationPeriod: Output<Int>? = null,
    public val lbPort: Output<Int>? = null,
    public val loadBalancer: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs> {
    override fun toJava(): com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs =
        com.pulumi.aws.elb.LoadBalancerCookieStickinessPolicyArgs.builder()
            .cookieExpirationPeriod(cookieExpirationPeriod?.applyValue({ args0 -> args0 }))
            .lbPort(lbPort?.applyValue({ args0 -> args0 }))
            .loadBalancer(loadBalancer?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerCookieStickinessPolicyArgs].
 */
@PulumiTagMarker
public class LoadBalancerCookieStickinessPolicyArgsBuilder internal constructor() {
    private var cookieExpirationPeriod: Output<Int>? = null

    private var lbPort: Output<Int>? = null

    private var loadBalancer: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The time period after which
     * the session cookie should be considered stale, expressed in seconds.
     */
    @JvmName("nggumxpgktqfisep")
    public suspend fun cookieExpirationPeriod(`value`: Output<Int>) {
        this.cookieExpirationPeriod = value
    }

    /**
     * @param value The load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    @JvmName("iecepjnyhxknvkcs")
    public suspend fun lbPort(`value`: Output<Int>) {
        this.lbPort = value
    }

    /**
     * @param value The load balancer to which the policy
     * should be attached.
     */
    @JvmName("xgkgpondyhwadltc")
    public suspend fun loadBalancer(`value`: Output<String>) {
        this.loadBalancer = value
    }

    /**
     * @param value The name of the stickiness policy.
     */
    @JvmName("yuicoklnipapyeli")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The time period after which
     * the session cookie should be considered stale, expressed in seconds.
     */
    @JvmName("ujhwuxgvgvyccmfw")
    public suspend fun cookieExpirationPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookieExpirationPeriod = mapped
    }

    /**
     * @param value The load balancer port to which the policy
     * should be applied. This must be an active listener on the load
     * balancer.
     */
    @JvmName("wxgpegpksguahvea")
    public suspend fun lbPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbPort = mapped
    }

    /**
     * @param value The load balancer to which the policy
     * should be attached.
     */
    @JvmName("jtrysavrhomorast")
    public suspend fun loadBalancer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancer = mapped
    }

    /**
     * @param value The name of the stickiness policy.
     */
    @JvmName("rykpddcxdggxtunb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): LoadBalancerCookieStickinessPolicyArgs =
        LoadBalancerCookieStickinessPolicyArgs(
            cookieExpirationPeriod = cookieExpirationPeriod,
            lbPort = lbPort,
            loadBalancer = loadBalancer,
            name = name,
        )
}
