@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.inputs

import com.pulumi.aws.elb.inputs.GetHostedZoneIdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHostedZoneId.
 * @property region Name of the region whose AWS ELB HostedZoneId is desired.
 * Defaults to the region from the AWS provider configuration.
 */
public data class GetHostedZoneIdPlainArgs(
    public val region: String? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.inputs.GetHostedZoneIdPlainArgs> {
    override fun toJava(): com.pulumi.aws.elb.inputs.GetHostedZoneIdPlainArgs =
        com.pulumi.aws.elb.inputs.GetHostedZoneIdPlainArgs.builder()
            .region(region?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHostedZoneIdPlainArgs].
 */
@PulumiTagMarker
public class GetHostedZoneIdPlainArgsBuilder internal constructor() {
    private var region: String? = null

    /**
     * @param value Name of the region whose AWS ELB HostedZoneId is desired.
     * Defaults to the region from the AWS provider configuration.
     */
    @JvmName("esqybrrvqglhvqod")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    internal fun build(): GetHostedZoneIdPlainArgs = GetHostedZoneIdPlainArgs(
        region = region,
    )
}
