@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.inputs

import com.pulumi.aws.elb.inputs.GetLoadBalancerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLoadBalancer.
 * @property name Unique name of the load balancer.
 * @property tags
 */
public data class GetLoadBalancerPlainArgs(
    public val name: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.inputs.GetLoadBalancerPlainArgs> {
    override fun toJava(): com.pulumi.aws.elb.inputs.GetLoadBalancerPlainArgs =
        com.pulumi.aws.elb.inputs.GetLoadBalancerPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLoadBalancerPlainArgs].
 */
@PulumiTagMarker
public class GetLoadBalancerPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Unique name of the load balancer.
     */
    @JvmName("tburloxmbotqohbp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("fhojoereuueoikyy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("gjmpbwxpknpgkmyl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLoadBalancerPlainArgs = GetLoadBalancerPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tags = tags,
    )
}
