@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.inputs

import com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instancePort The port on the instance to route to
 * @property instanceProtocol The protocol to use to the instance. Valid
 * values are `HTTP`, `HTTPS`, `TCP`, or `SSL`
 * @property lbPort The port to listen on for the load balancer
 * @property lbProtocol The protocol to listen on. Valid values are `HTTP`,
 * `HTTPS`, `TCP`, or `SSL`
 * @property sslCertificateId The ARN of an SSL certificate you have
 * uploaded to AWS IAM. **Note ECDSA-specific restrictions below.  Only valid when `lb_protocol` is either HTTPS or SSL**
 */
public data class LoadBalancerListenerArgs(
    public val instancePort: Output<Int>,
    public val instanceProtocol: Output<String>,
    public val lbPort: Output<Int>,
    public val lbProtocol: Output<String>,
    public val sslCertificateId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs> {
    override fun toJava(): com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs =
        com.pulumi.aws.elb.inputs.LoadBalancerListenerArgs.builder()
            .instancePort(instancePort.applyValue({ args0 -> args0 }))
            .instanceProtocol(instanceProtocol.applyValue({ args0 -> args0 }))
            .lbPort(lbPort.applyValue({ args0 -> args0 }))
            .lbProtocol(lbProtocol.applyValue({ args0 -> args0 }))
            .sslCertificateId(sslCertificateId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerListenerArgs].
 */
@PulumiTagMarker
public class LoadBalancerListenerArgsBuilder internal constructor() {
    private var instancePort: Output<Int>? = null

    private var instanceProtocol: Output<String>? = null

    private var lbPort: Output<Int>? = null

    private var lbProtocol: Output<String>? = null

    private var sslCertificateId: Output<String>? = null

    /**
     * @param value The port on the instance to route to
     */
    @JvmName("sfwhcrljhxwoiaeh")
    public suspend fun instancePort(`value`: Output<Int>) {
        this.instancePort = value
    }

    /**
     * @param value The protocol to use to the instance. Valid
     * values are `HTTP`, `HTTPS`, `TCP`, or `SSL`
     */
    @JvmName("mblkyynquauvfrjv")
    public suspend fun instanceProtocol(`value`: Output<String>) {
        this.instanceProtocol = value
    }

    /**
     * @param value The port to listen on for the load balancer
     */
    @JvmName("qmoqnrvpqeukglvg")
    public suspend fun lbPort(`value`: Output<Int>) {
        this.lbPort = value
    }

    /**
     * @param value The protocol to listen on. Valid values are `HTTP`,
     * `HTTPS`, `TCP`, or `SSL`
     */
    @JvmName("stijforxympmmwpj")
    public suspend fun lbProtocol(`value`: Output<String>) {
        this.lbProtocol = value
    }

    /**
     * @param value The ARN of an SSL certificate you have
     * uploaded to AWS IAM. **Note ECDSA-specific restrictions below.  Only valid when `lb_protocol` is either HTTPS or SSL**
     */
    @JvmName("qpeewlxuwmyhssrk")
    public suspend fun sslCertificateId(`value`: Output<String>) {
        this.sslCertificateId = value
    }

    /**
     * @param value The port on the instance to route to
     */
    @JvmName("arkwjxrslfxndnws")
    public suspend fun instancePort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instancePort = mapped
    }

    /**
     * @param value The protocol to use to the instance. Valid
     * values are `HTTP`, `HTTPS`, `TCP`, or `SSL`
     */
    @JvmName("fywkpjhppuiwpfji")
    public suspend fun instanceProtocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceProtocol = mapped
    }

    /**
     * @param value The port to listen on for the load balancer
     */
    @JvmName("qxkpivufkuixctid")
    public suspend fun lbPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lbPort = mapped
    }

    /**
     * @param value The protocol to listen on. Valid values are `HTTP`,
     * `HTTPS`, `TCP`, or `SSL`
     */
    @JvmName("lgoflpvsbsycjxmw")
    public suspend fun lbProtocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lbProtocol = mapped
    }

    /**
     * @param value The ARN of an SSL certificate you have
     * uploaded to AWS IAM. **Note ECDSA-specific restrictions below.  Only valid when `lb_protocol` is either HTTPS or SSL**
     */
    @JvmName("navwbgtwfppsyyjp")
    public suspend fun sslCertificateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslCertificateId = mapped
    }

    internal fun build(): LoadBalancerListenerArgs = LoadBalancerListenerArgs(
        instancePort = instancePort ?: throw PulumiNullFieldException("instancePort"),
        instanceProtocol = instanceProtocol ?: throw PulumiNullFieldException("instanceProtocol"),
        lbPort = lbPort ?: throw PulumiNullFieldException("lbPort"),
        lbProtocol = lbProtocol ?: throw PulumiNullFieldException("lbProtocol"),
        sslCertificateId = sslCertificateId,
    )
}
