@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.inputs

import com.pulumi.aws.elb.inputs.SslNegotiationPolicyAttributeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the attribute
 * @property value The value of the attribute
 */
public data class SslNegotiationPolicyAttributeArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.elb.inputs.SslNegotiationPolicyAttributeArgs> {
    override fun toJava(): com.pulumi.aws.elb.inputs.SslNegotiationPolicyAttributeArgs =
        com.pulumi.aws.elb.inputs.SslNegotiationPolicyAttributeArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SslNegotiationPolicyAttributeArgs].
 */
@PulumiTagMarker
public class SslNegotiationPolicyAttributeArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the attribute
     */
    @JvmName("rfdmctvrpmgnwaoj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the attribute
     */
    @JvmName("tlrhbcykdwgdwtwm")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the attribute
     */
    @JvmName("hbcyxdkqamdnhcec")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the attribute
     */
    @JvmName("cwlvygjtjtmadhsx")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): SslNegotiationPolicyAttributeArgs = SslNegotiationPolicyAttributeArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
