@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getServiceAccount.
 * @property arn ARN of the AWS ELB service account in the selected region.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property region
 */
public data class GetServiceAccountResult(
    public val arn: String,
    public val id: String,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elb.outputs.GetServiceAccountResult): GetServiceAccountResult = GetServiceAccountResult(
            arn = javaType.arn(),
            id = javaType.id(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
