@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The S3 bucket name to store the logs in.
 * @property bucketPrefix The S3 bucket prefix. Logs are stored in the root if not configured.
 * @property enabled Boolean to enable / disable `access_logs`. Default is `true`
 * @property interval The publishing interval in minutes. Valid values: `5` and `60`. Default: `60`
 */
public data class LoadBalancerAccessLogs(
    public val bucket: String,
    public val bucketPrefix: String? = null,
    public val enabled: Boolean? = null,
    public val interval: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elb.outputs.LoadBalancerAccessLogs): LoadBalancerAccessLogs = LoadBalancerAccessLogs(
            bucket = javaType.bucket(),
            bucketPrefix = javaType.bucketPrefix().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
        )
    }
}
