@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property healthyThreshold The number of checks before the instance is declared healthy.
 * @property interval The interval between checks.
 * @property target The target of the check. Valid pattern is "${PROTOCOL}:${PORT}${PATH}", where PROTOCOL
 * values are:
 * * `HTTP`, `HTTPS` - PORT and PATH are required
 * * `TCP`, `SSL` - PORT is required, PATH is not supported
 * @property timeout The length of time before the check times out.
 * @property unhealthyThreshold The number of checks before the instance is declared unhealthy.
 */
public data class LoadBalancerHealthCheck(
    public val healthyThreshold: Int,
    public val interval: Int,
    public val target: String,
    public val timeout: Int,
    public val unhealthyThreshold: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elb.outputs.LoadBalancerHealthCheck): LoadBalancerHealthCheck = LoadBalancerHealthCheck(
            healthyThreshold = javaType.healthyThreshold(),
            interval = javaType.interval(),
            target = javaType.target(),
            timeout = javaType.timeout(),
            unhealthyThreshold = javaType.unhealthyThreshold(),
        )
    }
}
