@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property instancePort The port on the instance to route to
 * @property instanceProtocol The protocol to use to the instance. Valid
 * values are `HTTP`, `HTTPS`, `TCP`, or `SSL`
 * @property lbPort The port to listen on for the load balancer
 * @property lbProtocol The protocol to listen on. Valid values are `HTTP`,
 * `HTTPS`, `TCP`, or `SSL`
 * @property sslCertificateId The ARN of an SSL certificate you have
 * uploaded to AWS IAM. **Note ECDSA-specific restrictions below.  Only valid when `lb_protocol` is either HTTPS or SSL**
 */
public data class LoadBalancerListener(
    public val instancePort: Int,
    public val instanceProtocol: String,
    public val lbPort: Int,
    public val lbProtocol: String,
    public val sslCertificateId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elb.outputs.LoadBalancerListener): LoadBalancerListener = LoadBalancerListener(
            instancePort = javaType.instancePort(),
            instanceProtocol = javaType.instanceProtocol(),
            lbPort = javaType.lbPort(),
            lbProtocol = javaType.lbProtocol(),
            sslCertificateId = javaType.sslCertificateId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
