@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.EmrFunctions.getReleaseLabelsPlain
import com.pulumi.aws.emr.EmrFunctions.getSupportedInstanceTypesPlain
import com.pulumi.aws.emr.kotlin.inputs.GetReleaseLabelsFilters
import com.pulumi.aws.emr.kotlin.inputs.GetReleaseLabelsPlainArgs
import com.pulumi.aws.emr.kotlin.inputs.GetReleaseLabelsPlainArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.GetSupportedInstanceTypesPlainArgs
import com.pulumi.aws.emr.kotlin.inputs.GetSupportedInstanceTypesPlainArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.GetSupportedInstanceTypesSupportedInstanceType
import com.pulumi.aws.emr.kotlin.outputs.GetReleaseLabelsResult
import com.pulumi.aws.emr.kotlin.outputs.GetSupportedInstanceTypesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.emr.kotlin.outputs.GetReleaseLabelsResult.Companion.toKotlin as getReleaseLabelsResultToKotlin
import com.pulumi.aws.emr.kotlin.outputs.GetSupportedInstanceTypesResult.Companion.toKotlin as getSupportedInstanceTypesResultToKotlin

public object EmrFunctions {
    /**
     * Retrieve information about EMR Release Labels.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.emr.getReleaseLabels({
     *     filters: {
     *         application: "spark@2.1.0",
     *         prefix: "emr-5",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.emr.get_release_labels(filters={
     *     "application": "spark@2.1.0",
     *     "prefix": "emr-5",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Emr.GetReleaseLabels.Invoke(new()
     *     {
     *         Filters = new Aws.Emr.Inputs.GetReleaseLabelsFiltersInputArgs
     *         {
     *             Application = "spark@2.1.0",
     *             Prefix = "emr-5",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := emr.GetReleaseLabels(ctx, &emr.GetReleaseLabelsArgs{
     * 			Filters: emr.GetReleaseLabelsFilters{
     * 				Application: pulumi.StringRef("spark@2.1.0"),
     * 				Prefix:      pulumi.StringRef("emr-5"),
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.EmrFunctions;
     * import com.pulumi.aws.emr.inputs.GetReleaseLabelsArgs;
     * import com.pulumi.aws.emr.inputs.GetReleaseLabelsFiltersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EmrFunctions.getReleaseLabels(GetReleaseLabelsArgs.builder()
     *             .filters(GetReleaseLabelsFiltersArgs.builder()
     *                 .application("spark@2.1.0")
     *                 .prefix("emr-5")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:emr:getReleaseLabels
     *       Arguments:
     *         filters:
     *           application: spark@2.1.0
     *           prefix: emr-5
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getReleaseLabels.
     * @return A collection of values returned by getReleaseLabels.
     */
    public suspend fun getReleaseLabels(argument: GetReleaseLabelsPlainArgs): GetReleaseLabelsResult =
        getReleaseLabelsResultToKotlin(getReleaseLabelsPlain(argument.toJava()).await())

    /**
     * @see [getReleaseLabels].
     * @param filters Filters the results of the request. Prefix specifies the prefix of release labels to return. Application specifies the application (with/without version) of release labels to return. See Filters.
     * @return A collection of values returned by getReleaseLabels.
     */
    public suspend fun getReleaseLabels(filters: GetReleaseLabelsFilters? = null): GetReleaseLabelsResult {
        val argument = GetReleaseLabelsPlainArgs(
            filters = filters,
        )
        return getReleaseLabelsResultToKotlin(getReleaseLabelsPlain(argument.toJava()).await())
    }

    /**
     * @see [getReleaseLabels].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;emr&#46;kotlin&#46;inputs&#46;GetReleaseLabelsPlainArgs].
     * @return A collection of values returned by getReleaseLabels.
     */
    public suspend fun getReleaseLabels(argument: suspend GetReleaseLabelsPlainArgsBuilder.() -> Unit): GetReleaseLabelsResult {
        val builder = GetReleaseLabelsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReleaseLabelsResultToKotlin(getReleaseLabelsPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing AWS EMR Supported Instance Types.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.emr.getSupportedInstanceTypes({
     *     releaseLabel: "ebs-6.15.0",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.emr.get_supported_instance_types(release_label="ebs-6.15.0")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Emr.GetSupportedInstanceTypes.Invoke(new()
     *     {
     *         ReleaseLabel = "ebs-6.15.0",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := emr.GetSupportedInstanceTypes(ctx, &emr.GetSupportedInstanceTypesArgs{
     * 			ReleaseLabel: "ebs-6.15.0",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.EmrFunctions;
     * import com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EmrFunctions.getSupportedInstanceTypes(GetSupportedInstanceTypesArgs.builder()
     *             .releaseLabel("ebs-6.15.0")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:emr:getSupportedInstanceTypes
     *       Arguments:
     *         releaseLabel: ebs-6.15.0
     * ```
     * <!--End PulumiCodeChooser -->
     * ### With a Lifecycle Pre-Condition
     * This data source can be used with a lifecycle precondition to ensure a given instance type is supported by EMR.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const instanceType = "r7g.large";
     * const releaseLabel = "emr-6.15.0";
     * const test = aws.emr.getSupportedInstanceTypes({
     *     releaseLabel: releaseLabel,
     * });
     * const testCluster = new aws.emr.Cluster("test", {
     *     releaseLabel: releaseLabel,
     *     masterInstanceGroup: {
     *         instanceType: instanceType,
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * instance_type = "r7g.large"
     * release_label = "emr-6.15.0"
     * test = aws.emr.get_supported_instance_types(release_label=release_label)
     * test_cluster = aws.emr.Cluster("test",
     *     release_label=release_label,
     *     master_instance_group={
     *         "instance_type": instance_type,
     *     })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var instanceType = "r7g.large";
     *     var releaseLabel = "emr-6.15.0";
     *     var test = Aws.Emr.GetSupportedInstanceTypes.Invoke(new()
     *     {
     *         ReleaseLabel = releaseLabel,
     *     });
     *     var testCluster = new Aws.Emr.Cluster("test", new()
     *     {
     *         ReleaseLabel = releaseLabel,
     *         MasterInstanceGroup = new Aws.Emr.Inputs.ClusterMasterInstanceGroupArgs
     *         {
     *             InstanceType = instanceType,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		instanceType := "r7g.large"
     * 		releaseLabel := "emr-6.15.0"
     * 		_, err := emr.GetSupportedInstanceTypes(ctx, &emr.GetSupportedInstanceTypesArgs{
     * 			ReleaseLabel: releaseLabel,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = emr.NewCluster(ctx, "test", &emr.ClusterArgs{
     * 			ReleaseLabel: pulumi.String(releaseLabel),
     * 			MasterInstanceGroup: &emr.ClusterMasterInstanceGroupArgs{
     * 				InstanceType: pulumi.String(instanceType),
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.EmrFunctions;
     * import com.pulumi.aws.emr.inputs.GetSupportedInstanceTypesArgs;
     * import com.pulumi.aws.emr.Cluster;
     * import com.pulumi.aws.emr.ClusterArgs;
     * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var instanceType = "r7g.large";
     *         final var releaseLabel = "emr-6.15.0";
     *         final var test = EmrFunctions.getSupportedInstanceTypes(GetSupportedInstanceTypesArgs.builder()
     *             .releaseLabel(releaseLabel)
     *             .build());
     *         var testCluster = new Cluster("testCluster", ClusterArgs.builder()
     *             .releaseLabel(releaseLabel)
     *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
     *                 .instanceType(instanceType)
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   testCluster:
     *     type: aws:emr:Cluster
     *     name: test
     *     properties:
     *       releaseLabel: ${releaseLabel}
     *       masterInstanceGroup:
     *         instanceType: ${instanceType}
     * variables:
     *   instanceType: r7g.large
     *   releaseLabel: emr-6.15.0
     *   test:
     *     fn::invoke:
     *       Function: aws:emr:getSupportedInstanceTypes
     *       Arguments:
     *         releaseLabel: ${releaseLabel}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSupportedInstanceTypes.
     * @return A collection of values returned by getSupportedInstanceTypes.
     */
    public suspend fun getSupportedInstanceTypes(argument: GetSupportedInstanceTypesPlainArgs): GetSupportedInstanceTypesResult =
        getSupportedInstanceTypesResultToKotlin(getSupportedInstanceTypesPlain(argument.toJava()).await())

    /**
     * @see [getSupportedInstanceTypes].
     * @param releaseLabel Amazon EMR release label. For more information about Amazon EMR releases and their included application versions and features, see the [Amazon EMR Release Guide](https://docs.aws.amazon.com/emr/latest/ReleaseGuide/emr-release-components.html).
     * @param supportedInstanceTypes List of supported instance types. See `supported_instance_types` below.
     * @return A collection of values returned by getSupportedInstanceTypes.
     */
    public suspend fun getSupportedInstanceTypes(
        releaseLabel: String,
        supportedInstanceTypes: List<GetSupportedInstanceTypesSupportedInstanceType>? = null,
    ): GetSupportedInstanceTypesResult {
        val argument = GetSupportedInstanceTypesPlainArgs(
            releaseLabel = releaseLabel,
            supportedInstanceTypes = supportedInstanceTypes,
        )
        return getSupportedInstanceTypesResultToKotlin(getSupportedInstanceTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSupportedInstanceTypes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;emr&#46;kotlin&#46;inputs&#46;GetSupportedInstanceTypesPlainArgs].
     * @return A collection of values returned by getSupportedInstanceTypes.
     */
    public suspend fun getSupportedInstanceTypes(argument: suspend GetSupportedInstanceTypesPlainArgsBuilder.() -> Unit): GetSupportedInstanceTypesResult {
        val builder = GetSupportedInstanceTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSupportedInstanceTypesResultToKotlin(getSupportedInstanceTypesPlain(builtArgument.toJava()).await())
    }
}
