@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.InstanceFleetArgs.builder
import com.pulumi.aws.emr.kotlin.inputs.InstanceFleetInstanceTypeConfigArgs
import com.pulumi.aws.emr.kotlin.inputs.InstanceFleetInstanceTypeConfigArgsBuilder
import com.pulumi.aws.emr.kotlin.inputs.InstanceFleetLaunchSpecificationsArgs
import com.pulumi.aws.emr.kotlin.inputs.InstanceFleetLaunchSpecificationsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Elastic MapReduce Cluster Instance Fleet configuration.
 * See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/emr/) for more information.
 * > **NOTE:** At this time, Instance Fleets cannot be destroyed through the API nor
 * web interface. Instance Fleets are destroyed when the EMR Cluster is destroyed.
 * the provider will resize any Instance Fleet to zero when destroying the resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const task = new aws.emr.InstanceFleet("task", {
 *     clusterId: cluster.id,
 *     instanceTypeConfigs: [
 *         {
 *             bidPriceAsPercentageOfOnDemandPrice: 100,
 *             ebsConfigs: [{
 *                 size: 100,
 *                 type: "gp2",
 *                 volumesPerInstance: 1,
 *             }],
 *             instanceType: "m4.xlarge",
 *             weightedCapacity: 1,
 *         },
 *         {
 *             bidPriceAsPercentageOfOnDemandPrice: 100,
 *             ebsConfigs: [{
 *                 size: 100,
 *                 type: "gp2",
 *                 volumesPerInstance: 1,
 *             }],
 *             instanceType: "m4.2xlarge",
 *             weightedCapacity: 2,
 *         },
 *     ],
 *     launchSpecifications: {
 *         spotSpecifications: [{
 *             allocationStrategy: "capacity-optimized",
 *             blockDurationMinutes: 0,
 *             timeoutAction: "TERMINATE_CLUSTER",
 *             timeoutDurationMinutes: 10,
 *         }],
 *     },
 *     name: "task fleet",
 *     targetOnDemandCapacity: 1,
 *     targetSpotCapacity: 1,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * task = aws.emr.InstanceFleet("task",
 *     cluster_id=cluster["id"],
 *     instance_type_configs=[
 *         {
 *             "bid_price_as_percentage_of_on_demand_price": 100,
 *             "ebs_configs": [{
 *                 "size": 100,
 *                 "type": "gp2",
 *                 "volumes_per_instance": 1,
 *             }],
 *             "instance_type": "m4.xlarge",
 *             "weighted_capacity": 1,
 *         },
 *         {
 *             "bid_price_as_percentage_of_on_demand_price": 100,
 *             "ebs_configs": [{
 *                 "size": 100,
 *                 "type": "gp2",
 *                 "volumes_per_instance": 1,
 *             }],
 *             "instance_type": "m4.2xlarge",
 *             "weighted_capacity": 2,
 *         },
 *     ],
 *     launch_specifications={
 *         "spot_specifications": [{
 *             "allocation_strategy": "capacity-optimized",
 *             "block_duration_minutes": 0,
 *             "timeout_action": "TERMINATE_CLUSTER",
 *             "timeout_duration_minutes": 10,
 *         }],
 *     },
 *     name="task fleet",
 *     target_on_demand_capacity=1,
 *     target_spot_capacity=1)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new Aws.Emr.InstanceFleet("task", new()
 *     {
 *         ClusterId = cluster.Id,
 *         InstanceTypeConfigs = new[]
 *         {
 *             new Aws.Emr.Inputs.InstanceFleetInstanceTypeConfigArgs
 *             {
 *                 BidPriceAsPercentageOfOnDemandPrice = 100,
 *                 EbsConfigs = new[]
 *                 {
 *                     new Aws.Emr.Inputs.InstanceFleetInstanceTypeConfigEbsConfigArgs
 *                     {
 *                         Size = 100,
 *                         Type = "gp2",
 *                         VolumesPerInstance = 1,
 *                     },
 *                 },
 *                 InstanceType = "m4.xlarge",
 *                 WeightedCapacity = 1,
 *             },
 *             new Aws.Emr.Inputs.InstanceFleetInstanceTypeConfigArgs
 *             {
 *                 BidPriceAsPercentageOfOnDemandPrice = 100,
 *                 EbsConfigs = new[]
 *                 {
 *                     new Aws.Emr.Inputs.InstanceFleetInstanceTypeConfigEbsConfigArgs
 *                     {
 *                         Size = 100,
 *                         Type = "gp2",
 *                         VolumesPerInstance = 1,
 *                     },
 *                 },
 *                 InstanceType = "m4.2xlarge",
 *                 WeightedCapacity = 2,
 *             },
 *         },
 *         LaunchSpecifications = new Aws.Emr.Inputs.InstanceFleetLaunchSpecificationsArgs
 *         {
 *             SpotSpecifications = new[]
 *             {
 *                 new Aws.Emr.Inputs.InstanceFleetLaunchSpecificationsSpotSpecificationArgs
 *                 {
 *                     AllocationStrategy = "capacity-optimized",
 *                     BlockDurationMinutes = 0,
 *                     TimeoutAction = "TERMINATE_CLUSTER",
 *                     TimeoutDurationMinutes = 10,
 *                 },
 *             },
 *         },
 *         Name = "task fleet",
 *         TargetOnDemandCapacity = 1,
 *         TargetSpotCapacity = 1,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emr.NewInstanceFleet(ctx, "task", &emr.InstanceFleetArgs{
 * 			ClusterId: pulumi.Any(cluster.Id),
 * 			InstanceTypeConfigs: emr.InstanceFleetInstanceTypeConfigArray{
 * 				&emr.InstanceFleetInstanceTypeConfigArgs{
 * 					BidPriceAsPercentageOfOnDemandPrice: pulumi.Float64(100),
 * 					EbsConfigs: emr.InstanceFleetInstanceTypeConfigEbsConfigArray{
 * 						&emr.InstanceFleetInstanceTypeConfigEbsConfigArgs{
 * 							Size:               pulumi.Int(100),
 * 							Type:               pulumi.String("gp2"),
 * 							VolumesPerInstance: pulumi.Int(1),
 * 						},
 * 					},
 * 					InstanceType:     pulumi.String("m4.xlarge"),
 * 					WeightedCapacity: pulumi.Int(1),
 * 				},
 * 				&emr.InstanceFleetInstanceTypeConfigArgs{
 * 					BidPriceAsPercentageOfOnDemandPrice: pulumi.Float64(100),
 * 					EbsConfigs: emr.InstanceFleetInstanceTypeConfigEbsConfigArray{
 * 						&emr.InstanceFleetInstanceTypeConfigEbsConfigArgs{
 * 							Size:               pulumi.Int(100),
 * 							Type:               pulumi.String("gp2"),
 * 							VolumesPerInstance: pulumi.Int(1),
 * 						},
 * 					},
 * 					InstanceType:     pulumi.String("m4.2xlarge"),
 * 					WeightedCapacity: pulumi.Int(2),
 * 				},
 * 			},
 * 			LaunchSpecifications: &emr.InstanceFleetLaunchSpecificationsArgs{
 * 				SpotSpecifications: emr.InstanceFleetLaunchSpecificationsSpotSpecificationArray{
 * 					&emr.InstanceFleetLaunchSpecificationsSpotSpecificationArgs{
 * 						AllocationStrategy:     pulumi.String("capacity-optimized"),
 * 						BlockDurationMinutes:   pulumi.Int(0),
 * 						TimeoutAction:          pulumi.String("TERMINATE_CLUSTER"),
 * 						TimeoutDurationMinutes: pulumi.Int(10),
 * 					},
 * 				},
 * 			},
 * 			Name:                   pulumi.String("task fleet"),
 * 			TargetOnDemandCapacity: pulumi.Int(1),
 * 			TargetSpotCapacity:     pulumi.Int(1),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.InstanceFleet;
 * import com.pulumi.aws.emr.InstanceFleetArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetInstanceTypeConfigArgs;
 * import com.pulumi.aws.emr.inputs.InstanceFleetLaunchSpecificationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new InstanceFleet("task", InstanceFleetArgs.builder()
 *             .clusterId(cluster.id())
 *             .instanceTypeConfigs(
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.xlarge")
 *                     .weightedCapacity(1)
 *                     .build(),
 *                 InstanceFleetInstanceTypeConfigArgs.builder()
 *                     .bidPriceAsPercentageOfOnDemandPrice(100)
 *                     .ebsConfigs(InstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
 *                         .size(100)
 *                         .type("gp2")
 *                         .volumesPerInstance(1)
 *                         .build())
 *                     .instanceType("m4.2xlarge")
 *                     .weightedCapacity(2)
 *                     .build())
 *             .launchSpecifications(InstanceFleetLaunchSpecificationsArgs.builder()
 *                 .spotSpecifications(InstanceFleetLaunchSpecificationsSpotSpecificationArgs.builder()
 *                     .allocationStrategy("capacity-optimized")
 *                     .blockDurationMinutes(0)
 *                     .timeoutAction("TERMINATE_CLUSTER")
 *                     .timeoutDurationMinutes(10)
 *                     .build())
 *                 .build())
 *             .name("task fleet")
 *             .targetOnDemandCapacity(1)
 *             .targetSpotCapacity(1)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   task:
 *     type: aws:emr:InstanceFleet
 *     properties:
 *       clusterId: ${cluster.id}
 *       instanceTypeConfigs:
 *         - bidPriceAsPercentageOfOnDemandPrice: 100
 *           ebsConfigs:
 *             - size: 100
 *               type: gp2
 *               volumesPerInstance: 1
 *           instanceType: m4.xlarge
 *           weightedCapacity: 1
 *         - bidPriceAsPercentageOfOnDemandPrice: 100
 *           ebsConfigs:
 *             - size: 100
 *               type: gp2
 *               volumesPerInstance: 1
 *           instanceType: m4.2xlarge
 *           weightedCapacity: 2
 *       launchSpecifications:
 *         spotSpecifications:
 *           - allocationStrategy: capacity-optimized
 *             blockDurationMinutes: 0
 *             timeoutAction: TERMINATE_CLUSTER
 *             timeoutDurationMinutes: 10
 *       name: task fleet
 *       targetOnDemandCapacity: 1
 *       targetSpotCapacity: 1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EMR Instance Fleet using the EMR Cluster identifier and Instance Fleet identifier separated by a forward slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:emr/instanceFleet:InstanceFleet example j-123456ABCDEF/if-15EK4O09RZLNR
 * ```
 * @property clusterId ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
 * @property instanceTypeConfigs Configuration block for instance fleet
 * @property launchSpecifications Configuration block for launch specification
 * @property name Friendly name given to the instance fleet.
 * @property targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
 * @property targetSpotCapacity The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
 */
public data class InstanceFleetArgs(
    public val clusterId: Output<String>? = null,
    public val instanceTypeConfigs: Output<List<InstanceFleetInstanceTypeConfigArgs>>? = null,
    public val launchSpecifications: Output<InstanceFleetLaunchSpecificationsArgs>? = null,
    public val name: Output<String>? = null,
    public val targetOnDemandCapacity: Output<Int>? = null,
    public val targetSpotCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.InstanceFleetArgs> {
    override fun toJava(): com.pulumi.aws.emr.InstanceFleetArgs =
        com.pulumi.aws.emr.InstanceFleetArgs.builder()
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .instanceTypeConfigs(
                instanceTypeConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchSpecifications(
                launchSpecifications?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .targetOnDemandCapacity(targetOnDemandCapacity?.applyValue({ args0 -> args0 }))
            .targetSpotCapacity(targetSpotCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceFleetArgs].
 */
@PulumiTagMarker
public class InstanceFleetArgsBuilder internal constructor() {
    private var clusterId: Output<String>? = null

    private var instanceTypeConfigs: Output<List<InstanceFleetInstanceTypeConfigArgs>>? = null

    private var launchSpecifications: Output<InstanceFleetLaunchSpecificationsArgs>? = null

    private var name: Output<String>? = null

    private var targetOnDemandCapacity: Output<Int>? = null

    private var targetSpotCapacity: Output<Int>? = null

    /**
     * @param value ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     */
    @JvmName("kcpejxgphbhptpvf")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value Configuration block for instance fleet
     */
    @JvmName("jrijekeqpwyblvie")
    public suspend fun instanceTypeConfigs(`value`: Output<List<InstanceFleetInstanceTypeConfigArgs>>) {
        this.instanceTypeConfigs = value
    }

    @JvmName("qojksfjohhlqibji")
    public suspend fun instanceTypeConfigs(vararg values: Output<InstanceFleetInstanceTypeConfigArgs>) {
        this.instanceTypeConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for instance fleet
     */
    @JvmName("niwkmpxeahxcrrbl")
    public suspend fun instanceTypeConfigs(values: List<Output<InstanceFleetInstanceTypeConfigArgs>>) {
        this.instanceTypeConfigs = Output.all(values)
    }

    /**
     * @param value Configuration block for launch specification
     */
    @JvmName("jnsltbxbrhqipcxx")
    public suspend fun launchSpecifications(`value`: Output<InstanceFleetLaunchSpecificationsArgs>) {
        this.launchSpecifications = value
    }

    /**
     * @param value Friendly name given to the instance fleet.
     */
    @JvmName("sqwqclomwmkgfkfh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @JvmName("uepbupyevfyeiqla")
    public suspend fun targetOnDemandCapacity(`value`: Output<Int>) {
        this.targetOnDemandCapacity = value
    }

    /**
     * @param value The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @JvmName("ftnpsnxkykffvquj")
    public suspend fun targetSpotCapacity(`value`: Output<Int>) {
        this.targetSpotCapacity = value
    }

    /**
     * @param value ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     */
    @JvmName("xdynoqhekmcevrhf")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value Configuration block for instance fleet
     */
    @JvmName("xvokkmulvyqokevs")
    public suspend fun instanceTypeConfigs(`value`: List<InstanceFleetInstanceTypeConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet
     */
    @JvmName("ogydcaggxsebjstu")
    public suspend fun instanceTypeConfigs(argument: List<suspend InstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceFleetInstanceTypeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet
     */
    @JvmName("cmkiihlvdehgxbko")
    public suspend fun instanceTypeConfigs(vararg argument: suspend InstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceFleetInstanceTypeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet
     */
    @JvmName("svudyjeiaiyignnu")
    public suspend fun instanceTypeConfigs(argument: suspend InstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceFleetInstanceTypeConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param values Configuration block for instance fleet
     */
    @JvmName("oahjtnpnhyxkqedo")
    public suspend fun instanceTypeConfigs(vararg values: InstanceFleetInstanceTypeConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param value Configuration block for launch specification
     */
    @JvmName("gweybhhiuhofnrst")
    public suspend fun launchSpecifications(`value`: InstanceFleetLaunchSpecificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchSpecifications = mapped
    }

    /**
     * @param argument Configuration block for launch specification
     */
    @JvmName("ibwooqxtwlnxbqnx")
    public suspend fun launchSpecifications(argument: suspend InstanceFleetLaunchSpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceFleetLaunchSpecificationsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.launchSpecifications = mapped
    }

    /**
     * @param value Friendly name given to the instance fleet.
     */
    @JvmName("ffyyswmohyttoygd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @JvmName("gvgbbyabwfywkysy")
    public suspend fun targetOnDemandCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOnDemandCapacity = mapped
    }

    /**
     * @param value The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @JvmName("nawveyfynheilnes")
    public suspend fun targetSpotCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSpotCapacity = mapped
    }

    internal fun build(): InstanceFleetArgs = InstanceFleetArgs(
        clusterId = clusterId,
        instanceTypeConfigs = instanceTypeConfigs,
        launchSpecifications = launchSpecifications,
        name = name,
        targetOnDemandCapacity = targetOnDemandCapacity,
        targetSpotCapacity = targetSpotCapacity,
    )
}
