@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.kotlin.outputs.InstanceGroupEbsConfig
import com.pulumi.aws.emr.kotlin.outputs.InstanceGroupEbsConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [InstanceGroup].
 */
@PulumiTagMarker
public class InstanceGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceGroupArgs = InstanceGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceGroupArgsBuilder.() -> Unit) {
        val builder = InstanceGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceGroup {
        val builtJavaResource = com.pulumi.aws.emr.InstanceGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstanceGroup(builtJavaResource)
    }
}

/**
 * Provides an Elastic MapReduce Cluster Instance Group configuration.
 * See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/emr/) for more information.
 * > **NOTE:** At this time, Instance Groups cannot be destroyed through the API nor
 * web interface. Instance Groups are destroyed when the EMR Cluster is destroyed.
 * this provider will resize any Instance Group to zero when destroying the resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const task = new aws.emr.InstanceGroup("task", {
 *     clusterId: tf_test_cluster.id,
 *     instanceCount: 1,
 *     instanceType: "m5.xlarge",
 *     name: "my little instance group",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * task = aws.emr.InstanceGroup("task",
 *     cluster_id=tf_test_cluster["id"],
 *     instance_count=1,
 *     instance_type="m5.xlarge",
 *     name="my little instance group")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new Aws.Emr.InstanceGroup("task", new()
 *     {
 *         ClusterId = tf_test_cluster.Id,
 *         InstanceCount = 1,
 *         InstanceType = "m5.xlarge",
 *         Name = "my little instance group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emr.NewInstanceGroup(ctx, "task", &emr.InstanceGroupArgs{
 * 			ClusterId:     pulumi.Any(tf_test_cluster.Id),
 * 			InstanceCount: pulumi.Int(1),
 * 			InstanceType:  pulumi.String("m5.xlarge"),
 * 			Name:          pulumi.String("my little instance group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.InstanceGroup;
 * import com.pulumi.aws.emr.InstanceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new InstanceGroup("task", InstanceGroupArgs.builder()
 *             .clusterId(tf_test_cluster.id())
 *             .instanceCount(1)
 *             .instanceType("m5.xlarge")
 *             .name("my little instance group")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   task:
 *     type: aws:emr:InstanceGroup
 *     properties:
 *       clusterId: ${["tf-test-cluster"].id}
 *       instanceCount: 1
 *       instanceType: m5.xlarge
 *       name: my little instance group
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EMR task instance group using their EMR Cluster id and Instance Group id separated by a forward-slash `/`. For example:
 * ```sh
 * $ pulumi import aws:emr/instanceGroup:InstanceGroup task_group j-123456ABCDEF/ig-15EK4O09RZLNR
 * ```
 */
public class InstanceGroup internal constructor(
    override val javaResource: com.pulumi.aws.emr.InstanceGroup,
) : KotlinCustomResource(javaResource, InstanceGroupMapper) {
    /**
     * The autoscaling policy document. This is a JSON formatted string. See [EMR Auto Scaling](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html)
     */
    public val autoscalingPolicy: Output<String>?
        get() = javaResource.autoscalingPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If set, the bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
     */
    public val bidPrice: Output<String>?
        get() = javaResource.bidPrice().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * A JSON string for supplying list of configurations specific to the EMR instance group. Note that this can only be changed when using EMR release 5.21 or later.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const task = new aws.emr.InstanceGroup("task", {configurationsJson: `[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * task = aws.emr.InstanceGroup("task", configurations_json="""[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * """)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var task = new Aws.Emr.InstanceGroup("task", new()
     *     {
     *         ConfigurationsJson = @"[
     * {
     * ""Classification"": ""hadoop-env"",
     * ""Configurations"": [
     * {
     * ""Classification"": ""export"",
     * ""Properties"": {
     * ""JAVA_HOME"": ""/usr/lib/jvm/java-1.8.0""
     * }
     * }
     * ],
     * ""Properties"": {}
     * }
     * ]
     * ",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := emr.NewInstanceGroup(ctx, "task", &emr.InstanceGroupArgs{
     * 			ConfigurationsJson: pulumi.String(`[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.InstanceGroup;
     * import com.pulumi.aws.emr.InstanceGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var task = new InstanceGroup("task", InstanceGroupArgs.builder()
     *             .configurationsJson("""
     * [
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     *             """)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   task:
     *     type: aws:emr:InstanceGroup
     *     properties:
     *       configurationsJson: |
     *         [
     *         {
     *         "Classification": "hadoop-env",
     *         "Configurations": [
     *         {
     *         "Classification": "export",
     *         "Properties": {
     *         "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     *         }
     *         }
     *         ],
     *         "Properties": {}
     *         }
     *         ]
     * ```
     * <!--End PulumiCodeChooser -->
     */
    public val configurationsJson: Output<String>?
        get() = javaResource.configurationsJson().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     */
    public val ebsConfigs: Output<List<InstanceGroupEbsConfig>>
        get() = javaResource.ebsConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Indicates whether an Amazon EBS volume is EBS-optimized. Changing this forces a new resource to be created.
     */
    public val ebsOptimized: Output<Boolean>?
        get() = javaResource.ebsOptimized().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * target number of instances for the instance group. defaults to 0.
     */
    public val instanceCount: Output<Int>
        get() = javaResource.instanceCount().applyValue({ args0 -> args0 })

    /**
     * The EC2 instance type for all instances in the instance group. Changing this forces a new resource to be created.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Human friendly name given to the instance group. Changing this forces a new resource to be created.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of instances currently running in this instance group.
     */
    public val runningInstanceCount: Output<Int>
        get() = javaResource.runningInstanceCount().applyValue({ args0 -> args0 })

    /**
     * The current status of the instance group.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object InstanceGroupMapper : ResourceMapper<InstanceGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.InstanceGroup::class == javaResource::class

    override fun map(javaResource: Resource): InstanceGroup = InstanceGroup(
        javaResource as
            com.pulumi.aws.emr.InstanceGroup,
    )
}

/**
 * @see [InstanceGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceGroup].
 */
public suspend fun instanceGroup(
    name: String,
    block: suspend InstanceGroupResourceBuilder.() -> Unit,
): InstanceGroup {
    val builder = InstanceGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceGroup(name: String): InstanceGroup {
    val builder = InstanceGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
