@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.InstanceGroupArgs.builder
import com.pulumi.aws.emr.kotlin.inputs.InstanceGroupEbsConfigArgs
import com.pulumi.aws.emr.kotlin.inputs.InstanceGroupEbsConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Elastic MapReduce Cluster Instance Group configuration.
 * See [Amazon Elastic MapReduce Documentation](https://aws.amazon.com/documentation/emr/) for more information.
 * > **NOTE:** At this time, Instance Groups cannot be destroyed through the API nor
 * web interface. Instance Groups are destroyed when the EMR Cluster is destroyed.
 * this provider will resize any Instance Group to zero when destroying the resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const task = new aws.emr.InstanceGroup("task", {
 *     clusterId: tf_test_cluster.id,
 *     instanceCount: 1,
 *     instanceType: "m5.xlarge",
 *     name: "my little instance group",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * task = aws.emr.InstanceGroup("task",
 *     cluster_id=tf_test_cluster["id"],
 *     instance_count=1,
 *     instance_type="m5.xlarge",
 *     name="my little instance group")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new Aws.Emr.InstanceGroup("task", new()
 *     {
 *         ClusterId = tf_test_cluster.Id,
 *         InstanceCount = 1,
 *         InstanceType = "m5.xlarge",
 *         Name = "my little instance group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emr.NewInstanceGroup(ctx, "task", &emr.InstanceGroupArgs{
 * 			ClusterId:     pulumi.Any(tf_test_cluster.Id),
 * 			InstanceCount: pulumi.Int(1),
 * 			InstanceType:  pulumi.String("m5.xlarge"),
 * 			Name:          pulumi.String("my little instance group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.InstanceGroup;
 * import com.pulumi.aws.emr.InstanceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new InstanceGroup("task", InstanceGroupArgs.builder()
 *             .clusterId(tf_test_cluster.id())
 *             .instanceCount(1)
 *             .instanceType("m5.xlarge")
 *             .name("my little instance group")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   task:
 *     type: aws:emr:InstanceGroup
 *     properties:
 *       clusterId: ${["tf-test-cluster"].id}
 *       instanceCount: 1
 *       instanceType: m5.xlarge
 *       name: my little instance group
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EMR task instance group using their EMR Cluster id and Instance Group id separated by a forward-slash `/`. For example:
 * ```sh
 * $ pulumi import aws:emr/instanceGroup:InstanceGroup task_group j-123456ABCDEF/ig-15EK4O09RZLNR
 * ```
 * @property autoscalingPolicy The autoscaling policy document. This is a JSON formatted string. See [EMR Auto Scaling](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html)
 * @property bidPrice If set, the bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
 * @property clusterId ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
 * @property configurationsJson A JSON string for supplying list of configurations specific to the EMR instance group. Note that this can only be changed when using EMR release 5.21 or later.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const task = new aws.emr.InstanceGroup("task", {configurationsJson: `[
 * {
 * "Classification": "hadoop-env",
 * "Configurations": [
 * {
 * "Classification": "export",
 * "Properties": {
 * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 * }
 * }
 * ],
 * "Properties": {}
 * }
 * ]
 * `});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * task = aws.emr.InstanceGroup("task", configurations_json="""[
 * {
 * "Classification": "hadoop-env",
 * "Configurations": [
 * {
 * "Classification": "export",
 * "Properties": {
 * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 * }
 * }
 * ],
 * "Properties": {}
 * }
 * ]
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var task = new Aws.Emr.InstanceGroup("task", new()
 *     {
 *         ConfigurationsJson = @"[
 * {
 * ""Classification"": ""hadoop-env"",
 * ""Configurations"": [
 * {
 * ""Classification"": ""export"",
 * ""Properties"": {
 * ""JAVA_HOME"": ""/usr/lib/jvm/java-1.8.0""
 * }
 * }
 * ],
 * ""Properties"": {}
 * }
 * ]
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emr.NewInstanceGroup(ctx, "task", &emr.InstanceGroupArgs{
 * 			ConfigurationsJson: pulumi.String(`[
 * {
 * "Classification": "hadoop-env",
 * "Configurations": [
 * {
 * "Classification": "export",
 * "Properties": {
 * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 * }
 * }
 * ],
 * "Properties": {}
 * }
 * ]
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.InstanceGroup;
 * import com.pulumi.aws.emr.InstanceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var task = new InstanceGroup("task", InstanceGroupArgs.builder()
 *             .configurationsJson("""
 * [
 * {
 * "Classification": "hadoop-env",
 * "Configurations": [
 * {
 * "Classification": "export",
 * "Properties": {
 * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 * }
 * }
 * ],
 * "Properties": {}
 * }
 * ]
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   task:
 *     type: aws:emr:InstanceGroup
 *     properties:
 *       configurationsJson: |
 *         [
 *         {
 *         "Classification": "hadoop-env",
 *         "Configurations": [
 *         {
 *         "Classification": "export",
 *         "Properties": {
 *         "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
 *         }
 *         }
 *         ],
 *         "Properties": {}
 *         }
 *         ]
 * ```
 * <!--End PulumiCodeChooser -->
 * @property ebsConfigs One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
 * @property ebsOptimized Indicates whether an Amazon EBS volume is EBS-optimized. Changing this forces a new resource to be created.
 * @property instanceCount target number of instances for the instance group. defaults to 0.
 * @property instanceType The EC2 instance type for all instances in the instance group. Changing this forces a new resource to be created.
 * @property name Human friendly name given to the instance group. Changing this forces a new resource to be created.
 */
public data class InstanceGroupArgs(
    public val autoscalingPolicy: Output<String>? = null,
    public val bidPrice: Output<String>? = null,
    public val clusterId: Output<String>? = null,
    public val configurationsJson: Output<String>? = null,
    public val ebsConfigs: Output<List<InstanceGroupEbsConfigArgs>>? = null,
    public val ebsOptimized: Output<Boolean>? = null,
    public val instanceCount: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.InstanceGroupArgs> {
    override fun toJava(): com.pulumi.aws.emr.InstanceGroupArgs =
        com.pulumi.aws.emr.InstanceGroupArgs.builder()
            .autoscalingPolicy(autoscalingPolicy?.applyValue({ args0 -> args0 }))
            .bidPrice(bidPrice?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .configurationsJson(configurationsJson?.applyValue({ args0 -> args0 }))
            .ebsConfigs(
                ebsConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ebsOptimized(ebsOptimized?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceGroupArgs].
 */
@PulumiTagMarker
public class InstanceGroupArgsBuilder internal constructor() {
    private var autoscalingPolicy: Output<String>? = null

    private var bidPrice: Output<String>? = null

    private var clusterId: Output<String>? = null

    private var configurationsJson: Output<String>? = null

    private var ebsConfigs: Output<List<InstanceGroupEbsConfigArgs>>? = null

    private var ebsOptimized: Output<Boolean>? = null

    private var instanceCount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The autoscaling policy document. This is a JSON formatted string. See [EMR Auto Scaling](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html)
     */
    @JvmName("rwayifpautrqijxj")
    public suspend fun autoscalingPolicy(`value`: Output<String>) {
        this.autoscalingPolicy = value
    }

    /**
     * @param value If set, the bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
     */
    @JvmName("iqtytccmjmegoxnm")
    public suspend fun bidPrice(`value`: Output<String>) {
        this.bidPrice = value
    }

    /**
     * @param value ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     */
    @JvmName("nagyrxgpwxhevrco")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value A JSON string for supplying list of configurations specific to the EMR instance group. Note that this can only be changed when using EMR release 5.21 or later.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const task = new aws.emr.InstanceGroup("task", {configurationsJson: `[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * task = aws.emr.InstanceGroup("task", configurations_json="""[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * """)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var task = new Aws.Emr.InstanceGroup("task", new()
     *     {
     *         ConfigurationsJson = @"[
     * {
     * ""Classification"": ""hadoop-env"",
     * ""Configurations"": [
     * {
     * ""Classification"": ""export"",
     * ""Properties"": {
     * ""JAVA_HOME"": ""/usr/lib/jvm/java-1.8.0""
     * }
     * }
     * ],
     * ""Properties"": {}
     * }
     * ]
     * ",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := emr.NewInstanceGroup(ctx, "task", &emr.InstanceGroupArgs{
     * 			ConfigurationsJson: pulumi.String(`[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.InstanceGroup;
     * import com.pulumi.aws.emr.InstanceGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var task = new InstanceGroup("task", InstanceGroupArgs.builder()
     *             .configurationsJson("""
     * [
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     *             """)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   task:
     *     type: aws:emr:InstanceGroup
     *     properties:
     *       configurationsJson: |
     *         [
     *         {
     *         "Classification": "hadoop-env",
     *         "Configurations": [
     *         {
     *         "Classification": "export",
     *         "Properties": {
     *         "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     *         }
     *         }
     *         ],
     *         "Properties": {}
     *         }
     *         ]
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("qjfutmqwppywehup")
    public suspend fun configurationsJson(`value`: Output<String>) {
        this.configurationsJson = value
    }

    /**
     * @param value One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     */
    @JvmName("qfiwcxdllfwtsgve")
    public suspend fun ebsConfigs(`value`: Output<List<InstanceGroupEbsConfigArgs>>) {
        this.ebsConfigs = value
    }

    @JvmName("jlvbnbhdtgjuybbs")
    public suspend fun ebsConfigs(vararg values: Output<InstanceGroupEbsConfigArgs>) {
        this.ebsConfigs = Output.all(values.asList())
    }

    /**
     * @param values One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     */
    @JvmName("vemaxdhufxbyryny")
    public suspend fun ebsConfigs(values: List<Output<InstanceGroupEbsConfigArgs>>) {
        this.ebsConfigs = Output.all(values)
    }

    /**
     * @param value Indicates whether an Amazon EBS volume is EBS-optimized. Changing this forces a new resource to be created.
     */
    @JvmName("nfdoesiixynrospc")
    public suspend fun ebsOptimized(`value`: Output<Boolean>) {
        this.ebsOptimized = value
    }

    /**
     * @param value target number of instances for the instance group. defaults to 0.
     */
    @JvmName("nnixckmguaqdirfs")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value The EC2 instance type for all instances in the instance group. Changing this forces a new resource to be created.
     */
    @JvmName("dutmisxnpyqsvowm")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Human friendly name given to the instance group. Changing this forces a new resource to be created.
     */
    @JvmName("mmxfpsqysqxpplon")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The autoscaling policy document. This is a JSON formatted string. See [EMR Auto Scaling](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html)
     */
    @JvmName("ecpnxxwgcbownmsw")
    public suspend fun autoscalingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingPolicy = mapped
    }

    /**
     * @param value If set, the bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
     */
    @JvmName("wfqopglibaolpifr")
    public suspend fun bidPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPrice = mapped
    }

    /**
     * @param value ID of the EMR Cluster to attach to. Changing this forces a new resource to be created.
     */
    @JvmName("vqikswfvkrfxueqy")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value A JSON string for supplying list of configurations specific to the EMR instance group. Note that this can only be changed when using EMR release 5.21 or later.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const task = new aws.emr.InstanceGroup("task", {configurationsJson: `[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * task = aws.emr.InstanceGroup("task", configurations_json="""[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * """)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var task = new Aws.Emr.InstanceGroup("task", new()
     *     {
     *         ConfigurationsJson = @"[
     * {
     * ""Classification"": ""hadoop-env"",
     * ""Configurations"": [
     * {
     * ""Classification"": ""export"",
     * ""Properties"": {
     * ""JAVA_HOME"": ""/usr/lib/jvm/java-1.8.0""
     * }
     * }
     * ],
     * ""Properties"": {}
     * }
     * ]
     * ",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := emr.NewInstanceGroup(ctx, "task", &emr.InstanceGroupArgs{
     * 			ConfigurationsJson: pulumi.String(`[
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     * `),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.emr.InstanceGroup;
     * import com.pulumi.aws.emr.InstanceGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var task = new InstanceGroup("task", InstanceGroupArgs.builder()
     *             .configurationsJson("""
     * [
     * {
     * "Classification": "hadoop-env",
     * "Configurations": [
     * {
     * "Classification": "export",
     * "Properties": {
     * "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     * }
     * }
     * ],
     * "Properties": {}
     * }
     * ]
     *             """)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   task:
     *     type: aws:emr:InstanceGroup
     *     properties:
     *       configurationsJson: |
     *         [
     *         {
     *         "Classification": "hadoop-env",
     *         "Configurations": [
     *         {
     *         "Classification": "export",
     *         "Properties": {
     *         "JAVA_HOME": "/usr/lib/jvm/java-1.8.0"
     *         }
     *         }
     *         ],
     *         "Properties": {}
     *         }
     *         ]
     * ```
     * <!--End PulumiCodeChooser -->
     */
    @JvmName("ebkjwlukvkvhddfp")
    public suspend fun configurationsJson(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationsJson = mapped
    }

    /**
     * @param value One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     */
    @JvmName("dohmuavocjgyggvv")
    public suspend fun ebsConfigs(`value`: List<InstanceGroupEbsConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param argument One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     */
    @JvmName("kgnvehhgdeggcktn")
    public suspend fun ebsConfigs(argument: List<suspend InstanceGroupEbsConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceGroupEbsConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     */
    @JvmName("byshgsgtltnrtoon")
    public suspend fun ebsConfigs(vararg argument: suspend InstanceGroupEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceGroupEbsConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     */
    @JvmName("mqkncoysianyrbpe")
    public suspend fun ebsConfigs(argument: suspend InstanceGroupEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceGroupEbsConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param values One or more `ebs_config` blocks as defined below. Changing this forces a new resource to be created.
     */
    @JvmName("qvmpuojkbjxvjegg")
    public suspend fun ebsConfigs(vararg values: InstanceGroupEbsConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param value Indicates whether an Amazon EBS volume is EBS-optimized. Changing this forces a new resource to be created.
     */
    @JvmName("ddvonjyidemntdps")
    public suspend fun ebsOptimized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsOptimized = mapped
    }

    /**
     * @param value target number of instances for the instance group. defaults to 0.
     */
    @JvmName("tasfgnwbqwthvbha")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The EC2 instance type for all instances in the instance group. Changing this forces a new resource to be created.
     */
    @JvmName("tykajrwmmkivlmow")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Human friendly name given to the instance group. Changing this forces a new resource to be created.
     */
    @JvmName("qukgdfaxcfonwhai")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): InstanceGroupArgs = InstanceGroupArgs(
        autoscalingPolicy = autoscalingPolicy,
        bidPrice = bidPrice,
        clusterId = clusterId,
        configurationsJson = configurationsJson,
        ebsConfigs = ebsConfigs,
        ebsOptimized = ebsOptimized,
        instanceCount = instanceCount,
        instanceType = instanceType,
        name = name,
    )
}
