@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.kotlin.outputs.ManagedScalingPolicyComputeLimit
import com.pulumi.aws.emr.kotlin.outputs.ManagedScalingPolicyComputeLimit.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ManagedScalingPolicy].
 */
@PulumiTagMarker
public class ManagedScalingPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedScalingPolicyArgs = ManagedScalingPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedScalingPolicyArgsBuilder.() -> Unit) {
        val builder = ManagedScalingPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedScalingPolicy {
        val builtJavaResource = com.pulumi.aws.emr.ManagedScalingPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ManagedScalingPolicy(builtJavaResource)
    }
}

/**
 * Provides a Managed Scaling policy for EMR Cluster. With Amazon EMR versions 5.30.0 and later (except for Amazon EMR 6.0.0), you can enable EMR managed scaling to automatically increase or decrease the number of instances or units in your cluster based on workload. See [Using EMR Managed Scaling in Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-scaling.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sample = new aws.emr.Cluster("sample", {
 *     name: "emr-sample-cluster",
 *     releaseLabel: "emr-5.30.0",
 *     masterInstanceGroup: {
 *         instanceType: "m4.large",
 *     },
 *     coreInstanceGroup: {
 *         instanceType: "c4.large",
 *     },
 * });
 * const samplepolicy = new aws.emr.ManagedScalingPolicy("samplepolicy", {
 *     clusterId: sample.id,
 *     computeLimits: [{
 *         unitType: "Instances",
 *         minimumCapacityUnits: 2,
 *         maximumCapacityUnits: 10,
 *         maximumOndemandCapacityUnits: 2,
 *         maximumCoreCapacityUnits: 10,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sample = aws.emr.Cluster("sample",
 *     name="emr-sample-cluster",
 *     release_label="emr-5.30.0",
 *     master_instance_group={
 *         "instance_type": "m4.large",
 *     },
 *     core_instance_group={
 *         "instance_type": "c4.large",
 *     })
 * samplepolicy = aws.emr.ManagedScalingPolicy("samplepolicy",
 *     cluster_id=sample.id,
 *     compute_limits=[{
 *         "unit_type": "Instances",
 *         "minimum_capacity_units": 2,
 *         "maximum_capacity_units": 10,
 *         "maximum_ondemand_capacity_units": 2,
 *         "maximum_core_capacity_units": 10,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sample = new Aws.Emr.Cluster("sample", new()
 *     {
 *         Name = "emr-sample-cluster",
 *         ReleaseLabel = "emr-5.30.0",
 *         MasterInstanceGroup = new Aws.Emr.Inputs.ClusterMasterInstanceGroupArgs
 *         {
 *             InstanceType = "m4.large",
 *         },
 *         CoreInstanceGroup = new Aws.Emr.Inputs.ClusterCoreInstanceGroupArgs
 *         {
 *             InstanceType = "c4.large",
 *         },
 *     });
 *     var samplepolicy = new Aws.Emr.ManagedScalingPolicy("samplepolicy", new()
 *     {
 *         ClusterId = sample.Id,
 *         ComputeLimits = new[]
 *         {
 *             new Aws.Emr.Inputs.ManagedScalingPolicyComputeLimitArgs
 *             {
 *                 UnitType = "Instances",
 *                 MinimumCapacityUnits = 2,
 *                 MaximumCapacityUnits = 10,
 *                 MaximumOndemandCapacityUnits = 2,
 *                 MaximumCoreCapacityUnits = 10,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		sample, err := emr.NewCluster(ctx, "sample", &emr.ClusterArgs{
 * 			Name:         pulumi.String("emr-sample-cluster"),
 * 			ReleaseLabel: pulumi.String("emr-5.30.0"),
 * 			MasterInstanceGroup: &emr.ClusterMasterInstanceGroupArgs{
 * 				InstanceType: pulumi.String("m4.large"),
 * 			},
 * 			CoreInstanceGroup: &emr.ClusterCoreInstanceGroupArgs{
 * 				InstanceType: pulumi.String("c4.large"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = emr.NewManagedScalingPolicy(ctx, "samplepolicy", &emr.ManagedScalingPolicyArgs{
 * 			ClusterId: sample.ID(),
 * 			ComputeLimits: emr.ManagedScalingPolicyComputeLimitArray{
 * 				&emr.ManagedScalingPolicyComputeLimitArgs{
 * 					UnitType:                     pulumi.String("Instances"),
 * 					MinimumCapacityUnits:         pulumi.Int(2),
 * 					MaximumCapacityUnits:         pulumi.Int(10),
 * 					MaximumOndemandCapacityUnits: pulumi.Int(2),
 * 					MaximumCoreCapacityUnits:     pulumi.Int(10),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
 * import com.pulumi.aws.emr.ManagedScalingPolicy;
 * import com.pulumi.aws.emr.ManagedScalingPolicyArgs;
 * import com.pulumi.aws.emr.inputs.ManagedScalingPolicyComputeLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample = new Cluster("sample", ClusterArgs.builder()
 *             .name("emr-sample-cluster")
 *             .releaseLabel("emr-5.30.0")
 *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
 *                 .instanceType("m4.large")
 *                 .build())
 *             .coreInstanceGroup(ClusterCoreInstanceGroupArgs.builder()
 *                 .instanceType("c4.large")
 *                 .build())
 *             .build());
 *         var samplepolicy = new ManagedScalingPolicy("samplepolicy", ManagedScalingPolicyArgs.builder()
 *             .clusterId(sample.id())
 *             .computeLimits(ManagedScalingPolicyComputeLimitArgs.builder()
 *                 .unitType("Instances")
 *                 .minimumCapacityUnits(2)
 *                 .maximumCapacityUnits(10)
 *                 .maximumOndemandCapacityUnits(2)
 *                 .maximumCoreCapacityUnits(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sample:
 *     type: aws:emr:Cluster
 *     properties:
 *       name: emr-sample-cluster
 *       releaseLabel: emr-5.30.0
 *       masterInstanceGroup:
 *         instanceType: m4.large
 *       coreInstanceGroup:
 *         instanceType: c4.large
 *   samplepolicy:
 *     type: aws:emr:ManagedScalingPolicy
 *     properties:
 *       clusterId: ${sample.id}
 *       computeLimits:
 *         - unitType: Instances
 *           minimumCapacityUnits: 2
 *           maximumCapacityUnits: 10
 *           maximumOndemandCapacityUnits: 2
 *           maximumCoreCapacityUnits: 10
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EMR Managed Scaling Policies using the EMR Cluster identifier. For example:
 * ```sh
 * $ pulumi import aws:emr/managedScalingPolicy:ManagedScalingPolicy example j-123456ABCDEF
 * ```
 */
public class ManagedScalingPolicy internal constructor(
    override val javaResource: com.pulumi.aws.emr.ManagedScalingPolicy,
) : KotlinCustomResource(javaResource, ManagedScalingPolicyMapper) {
    /**
     * ID of the EMR cluster
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * Configuration block with compute limit settings. Described below.
     */
    public val computeLimits: Output<List<ManagedScalingPolicyComputeLimit>>
        get() = javaResource.computeLimits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })
}

public object ManagedScalingPolicyMapper : ResourceMapper<ManagedScalingPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.ManagedScalingPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ManagedScalingPolicy = ManagedScalingPolicy(
        javaResource
            as com.pulumi.aws.emr.ManagedScalingPolicy,
    )
}

/**
 * @see [ManagedScalingPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedScalingPolicy].
 */
public suspend fun managedScalingPolicy(
    name: String,
    block: suspend ManagedScalingPolicyResourceBuilder.() -> Unit,
): ManagedScalingPolicy {
    val builder = ManagedScalingPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedScalingPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedScalingPolicy(name: String): ManagedScalingPolicy {
    val builder = ManagedScalingPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
