@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.ManagedScalingPolicyArgs.builder
import com.pulumi.aws.emr.kotlin.inputs.ManagedScalingPolicyComputeLimitArgs
import com.pulumi.aws.emr.kotlin.inputs.ManagedScalingPolicyComputeLimitArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Managed Scaling policy for EMR Cluster. With Amazon EMR versions 5.30.0 and later (except for Amazon EMR 6.0.0), you can enable EMR managed scaling to automatically increase or decrease the number of instances or units in your cluster based on workload. See [Using EMR Managed Scaling in Amazon EMR](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-managed-scaling.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sample = new aws.emr.Cluster("sample", {
 *     name: "emr-sample-cluster",
 *     releaseLabel: "emr-5.30.0",
 *     masterInstanceGroup: {
 *         instanceType: "m4.large",
 *     },
 *     coreInstanceGroup: {
 *         instanceType: "c4.large",
 *     },
 * });
 * const samplepolicy = new aws.emr.ManagedScalingPolicy("samplepolicy", {
 *     clusterId: sample.id,
 *     computeLimits: [{
 *         unitType: "Instances",
 *         minimumCapacityUnits: 2,
 *         maximumCapacityUnits: 10,
 *         maximumOndemandCapacityUnits: 2,
 *         maximumCoreCapacityUnits: 10,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sample = aws.emr.Cluster("sample",
 *     name="emr-sample-cluster",
 *     release_label="emr-5.30.0",
 *     master_instance_group={
 *         "instance_type": "m4.large",
 *     },
 *     core_instance_group={
 *         "instance_type": "c4.large",
 *     })
 * samplepolicy = aws.emr.ManagedScalingPolicy("samplepolicy",
 *     cluster_id=sample.id,
 *     compute_limits=[{
 *         "unit_type": "Instances",
 *         "minimum_capacity_units": 2,
 *         "maximum_capacity_units": 10,
 *         "maximum_ondemand_capacity_units": 2,
 *         "maximum_core_capacity_units": 10,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sample = new Aws.Emr.Cluster("sample", new()
 *     {
 *         Name = "emr-sample-cluster",
 *         ReleaseLabel = "emr-5.30.0",
 *         MasterInstanceGroup = new Aws.Emr.Inputs.ClusterMasterInstanceGroupArgs
 *         {
 *             InstanceType = "m4.large",
 *         },
 *         CoreInstanceGroup = new Aws.Emr.Inputs.ClusterCoreInstanceGroupArgs
 *         {
 *             InstanceType = "c4.large",
 *         },
 *     });
 *     var samplepolicy = new Aws.Emr.ManagedScalingPolicy("samplepolicy", new()
 *     {
 *         ClusterId = sample.Id,
 *         ComputeLimits = new[]
 *         {
 *             new Aws.Emr.Inputs.ManagedScalingPolicyComputeLimitArgs
 *             {
 *                 UnitType = "Instances",
 *                 MinimumCapacityUnits = 2,
 *                 MaximumCapacityUnits = 10,
 *                 MaximumOndemandCapacityUnits = 2,
 *                 MaximumCoreCapacityUnits = 10,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		sample, err := emr.NewCluster(ctx, "sample", &emr.ClusterArgs{
 * 			Name:         pulumi.String("emr-sample-cluster"),
 * 			ReleaseLabel: pulumi.String("emr-5.30.0"),
 * 			MasterInstanceGroup: &emr.ClusterMasterInstanceGroupArgs{
 * 				InstanceType: pulumi.String("m4.large"),
 * 			},
 * 			CoreInstanceGroup: &emr.ClusterCoreInstanceGroupArgs{
 * 				InstanceType: pulumi.String("c4.large"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = emr.NewManagedScalingPolicy(ctx, "samplepolicy", &emr.ManagedScalingPolicyArgs{
 * 			ClusterId: sample.ID(),
 * 			ComputeLimits: emr.ManagedScalingPolicyComputeLimitArray{
 * 				&emr.ManagedScalingPolicyComputeLimitArgs{
 * 					UnitType:                     pulumi.String("Instances"),
 * 					MinimumCapacityUnits:         pulumi.Int(2),
 * 					MaximumCapacityUnits:         pulumi.Int(10),
 * 					MaximumOndemandCapacityUnits: pulumi.Int(2),
 * 					MaximumCoreCapacityUnits:     pulumi.Int(10),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Cluster;
 * import com.pulumi.aws.emr.ClusterArgs;
 * import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs;
 * import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs;
 * import com.pulumi.aws.emr.ManagedScalingPolicy;
 * import com.pulumi.aws.emr.ManagedScalingPolicyArgs;
 * import com.pulumi.aws.emr.inputs.ManagedScalingPolicyComputeLimitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample = new Cluster("sample", ClusterArgs.builder()
 *             .name("emr-sample-cluster")
 *             .releaseLabel("emr-5.30.0")
 *             .masterInstanceGroup(ClusterMasterInstanceGroupArgs.builder()
 *                 .instanceType("m4.large")
 *                 .build())
 *             .coreInstanceGroup(ClusterCoreInstanceGroupArgs.builder()
 *                 .instanceType("c4.large")
 *                 .build())
 *             .build());
 *         var samplepolicy = new ManagedScalingPolicy("samplepolicy", ManagedScalingPolicyArgs.builder()
 *             .clusterId(sample.id())
 *             .computeLimits(ManagedScalingPolicyComputeLimitArgs.builder()
 *                 .unitType("Instances")
 *                 .minimumCapacityUnits(2)
 *                 .maximumCapacityUnits(10)
 *                 .maximumOndemandCapacityUnits(2)
 *                 .maximumCoreCapacityUnits(10)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sample:
 *     type: aws:emr:Cluster
 *     properties:
 *       name: emr-sample-cluster
 *       releaseLabel: emr-5.30.0
 *       masterInstanceGroup:
 *         instanceType: m4.large
 *       coreInstanceGroup:
 *         instanceType: c4.large
 *   samplepolicy:
 *     type: aws:emr:ManagedScalingPolicy
 *     properties:
 *       clusterId: ${sample.id}
 *       computeLimits:
 *         - unitType: Instances
 *           minimumCapacityUnits: 2
 *           maximumCapacityUnits: 10
 *           maximumOndemandCapacityUnits: 2
 *           maximumCoreCapacityUnits: 10
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EMR Managed Scaling Policies using the EMR Cluster identifier. For example:
 * ```sh
 * $ pulumi import aws:emr/managedScalingPolicy:ManagedScalingPolicy example j-123456ABCDEF
 * ```
 * @property clusterId ID of the EMR cluster
 * @property computeLimits Configuration block with compute limit settings. Described below.
 */
public data class ManagedScalingPolicyArgs(
    public val clusterId: Output<String>? = null,
    public val computeLimits: Output<List<ManagedScalingPolicyComputeLimitArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.ManagedScalingPolicyArgs> {
    override fun toJava(): com.pulumi.aws.emr.ManagedScalingPolicyArgs =
        com.pulumi.aws.emr.ManagedScalingPolicyArgs.builder()
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .computeLimits(
                computeLimits?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ManagedScalingPolicyArgs].
 */
@PulumiTagMarker
public class ManagedScalingPolicyArgsBuilder internal constructor() {
    private var clusterId: Output<String>? = null

    private var computeLimits: Output<List<ManagedScalingPolicyComputeLimitArgs>>? = null

    /**
     * @param value ID of the EMR cluster
     */
    @JvmName("dtujcvmmrtuhnjcn")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value Configuration block with compute limit settings. Described below.
     */
    @JvmName("xyfspntcdcxiqour")
    public suspend fun computeLimits(`value`: Output<List<ManagedScalingPolicyComputeLimitArgs>>) {
        this.computeLimits = value
    }

    @JvmName("ysfavhcmifexkqag")
    public suspend fun computeLimits(vararg values: Output<ManagedScalingPolicyComputeLimitArgs>) {
        this.computeLimits = Output.all(values.asList())
    }

    /**
     * @param values Configuration block with compute limit settings. Described below.
     */
    @JvmName("qdjnvekjysslqbqb")
    public suspend fun computeLimits(values: List<Output<ManagedScalingPolicyComputeLimitArgs>>) {
        this.computeLimits = Output.all(values)
    }

    /**
     * @param value ID of the EMR cluster
     */
    @JvmName("smobanawirlxvqtg")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value Configuration block with compute limit settings. Described below.
     */
    @JvmName("rmnsadxkbvffubqs")
    public suspend fun computeLimits(`value`: List<ManagedScalingPolicyComputeLimitArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeLimits = mapped
    }

    /**
     * @param argument Configuration block with compute limit settings. Described below.
     */
    @JvmName("oggwgbmkgxnnljmv")
    public suspend fun computeLimits(argument: List<suspend ManagedScalingPolicyComputeLimitArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedScalingPolicyComputeLimitArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.computeLimits = mapped
    }

    /**
     * @param argument Configuration block with compute limit settings. Described below.
     */
    @JvmName("ijdhyippavexanpq")
    public suspend fun computeLimits(vararg argument: suspend ManagedScalingPolicyComputeLimitArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedScalingPolicyComputeLimitArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.computeLimits = mapped
    }

    /**
     * @param argument Configuration block with compute limit settings. Described below.
     */
    @JvmName("nnvcgixlfsthfhjf")
    public suspend fun computeLimits(argument: suspend ManagedScalingPolicyComputeLimitArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ManagedScalingPolicyComputeLimitArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.computeLimits = mapped
    }

    /**
     * @param values Configuration block with compute limit settings. Described below.
     */
    @JvmName("emxjgfmjysstanch")
    public suspend fun computeLimits(vararg values: ManagedScalingPolicyComputeLimitArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeLimits = mapped
    }

    internal fun build(): ManagedScalingPolicyArgs = ManagedScalingPolicyArgs(
        clusterId = clusterId,
        computeLimits = computeLimits,
    )
}
