@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.aws.emr.StudioArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic MapReduce Studio.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emr.Studio("example", {
 *     authMode: "SSO",
 *     defaultS3Location: `s3://${test.bucket}/test`,
 *     engineSecurityGroupId: testAwsSecurityGroup.id,
 *     name: "example",
 *     serviceRole: testAwsIamRole.arn,
 *     subnetIds: [testAwsSubnet&#46;id],
 *     userRole: testAwsIamRole.arn,
 *     vpcId: testAwsVpc.id,
 *     workspaceSecurityGroupId: testAwsSecurityGroup.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emr.Studio("example",
 *     auth_mode="SSO",
 *     default_s3_location=f"s3://{test['bucket']}/test",
 *     engine_security_group_id=test_aws_security_group["id"],
 *     name="example",
 *     service_role=test_aws_iam_role["arn"],
 *     subnet_ids=[test_aws_subnet["id"]],
 *     user_role=test_aws_iam_role["arn"],
 *     vpc_id=test_aws_vpc["id"],
 *     workspace_security_group_id=test_aws_security_group["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Emr.Studio("example", new()
 *     {
 *         AuthMode = "SSO",
 *         DefaultS3Location = $"s3://{test.Bucket}/test",
 *         EngineSecurityGroupId = testAwsSecurityGroup.Id,
 *         Name = "example",
 *         ServiceRole = testAwsIamRole.Arn,
 *         SubnetIds = new[]
 *         {
 *             testAwsSubnet.Id,
 *         },
 *         UserRole = testAwsIamRole.Arn,
 *         VpcId = testAwsVpc.Id,
 *         WorkspaceSecurityGroupId = testAwsSecurityGroup.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emr.NewStudio(ctx, "example", &emr.StudioArgs{
 * 			AuthMode:              pulumi.String("SSO"),
 * 			DefaultS3Location:     pulumi.Sprintf("s3://%v/test", test.Bucket),
 * 			EngineSecurityGroupId: pulumi.Any(testAwsSecurityGroup.Id),
 * 			Name:                  pulumi.String("example"),
 * 			ServiceRole:           pulumi.Any(testAwsIamRole.Arn),
 * 			SubnetIds: pulumi.StringArray{
 * 				testAwsSubnet.Id,
 * 			},
 * 			UserRole:                 pulumi.Any(testAwsIamRole.Arn),
 * 			VpcId:                    pulumi.Any(testAwsVpc.Id),
 * 			WorkspaceSecurityGroupId: pulumi.Any(testAwsSecurityGroup.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.Studio;
 * import com.pulumi.aws.emr.StudioArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Studio("example", StudioArgs.builder()
 *             .authMode("SSO")
 *             .defaultS3Location(String.format("s3://%s/test", test.bucket()))
 *             .engineSecurityGroupId(testAwsSecurityGroup.id())
 *             .name("example")
 *             .serviceRole(testAwsIamRole.arn())
 *             .subnetIds(testAwsSubnet.id())
 *             .userRole(testAwsIamRole.arn())
 *             .vpcId(testAwsVpc.id())
 *             .workspaceSecurityGroupId(testAwsSecurityGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emr:Studio
 *     properties:
 *       authMode: SSO
 *       defaultS3Location: s3://${test.bucket}/test
 *       engineSecurityGroupId: ${testAwsSecurityGroup.id}
 *       name: example
 *       serviceRole: ${testAwsIamRole.arn}
 *       subnetIds:
 *         - ${testAwsSubnet.id}
 *       userRole: ${testAwsIamRole.arn}
 *       vpcId: ${testAwsVpc.id}
 *       workspaceSecurityGroupId: ${testAwsSecurityGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EMR studios using the `id`. For example:
 * ```sh
 * $ pulumi import aws:emr/studio:Studio studio es-123456ABCDEF
 * ```
 * @property authMode Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
 * @property defaultS3Location The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
 * @property description A detailed description of the Amazon EMR Studio.
 * @property engineSecurityGroupId The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
 * @property idpAuthUrl The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
 * @property idpRelayStateParameterName The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
 * @property name A descriptive name for the Amazon EMR Studio.
 * @property serviceRole The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
 * @property subnetIds A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
 * @property tags list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userRole The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
 * @property vpcId The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
 * @property workspaceSecurityGroupId The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
 * The following arguments are optional:
 */
public data class StudioArgs(
    public val authMode: Output<String>? = null,
    public val defaultS3Location: Output<String>? = null,
    public val description: Output<String>? = null,
    public val engineSecurityGroupId: Output<String>? = null,
    public val idpAuthUrl: Output<String>? = null,
    public val idpRelayStateParameterName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val serviceRole: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userRole: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val workspaceSecurityGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.StudioArgs> {
    override fun toJava(): com.pulumi.aws.emr.StudioArgs = com.pulumi.aws.emr.StudioArgs.builder()
        .authMode(authMode?.applyValue({ args0 -> args0 }))
        .defaultS3Location(defaultS3Location?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .engineSecurityGroupId(engineSecurityGroupId?.applyValue({ args0 -> args0 }))
        .idpAuthUrl(idpAuthUrl?.applyValue({ args0 -> args0 }))
        .idpRelayStateParameterName(idpRelayStateParameterName?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .serviceRole(serviceRole?.applyValue({ args0 -> args0 }))
        .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .userRole(userRole?.applyValue({ args0 -> args0 }))
        .vpcId(vpcId?.applyValue({ args0 -> args0 }))
        .workspaceSecurityGroupId(workspaceSecurityGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StudioArgs].
 */
@PulumiTagMarker
public class StudioArgsBuilder internal constructor() {
    private var authMode: Output<String>? = null

    private var defaultS3Location: Output<String>? = null

    private var description: Output<String>? = null

    private var engineSecurityGroupId: Output<String>? = null

    private var idpAuthUrl: Output<String>? = null

    private var idpRelayStateParameterName: Output<String>? = null

    private var name: Output<String>? = null

    private var serviceRole: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userRole: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var workspaceSecurityGroupId: Output<String>? = null

    /**
     * @param value Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
     */
    @JvmName("ykyltekbbrhyjmlk")
    public suspend fun authMode(`value`: Output<String>) {
        this.authMode = value
    }

    /**
     * @param value The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    @JvmName("xyrfbuenqqxykjvy")
    public suspend fun defaultS3Location(`value`: Output<String>) {
        this.defaultS3Location = value
    }

    /**
     * @param value A detailed description of the Amazon EMR Studio.
     */
    @JvmName("bfofnpxcrfrmcpff")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
     */
    @JvmName("kfigjtuwhqydvbwg")
    public suspend fun engineSecurityGroupId(`value`: Output<String>) {
        this.engineSecurityGroupId = value
    }

    /**
     * @param value The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     */
    @JvmName("pruwrfismvprbjlv")
    public suspend fun idpAuthUrl(`value`: Output<String>) {
        this.idpAuthUrl = value
    }

    /**
     * @param value The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
     */
    @JvmName("tshrxhhjkmukmixw")
    public suspend fun idpRelayStateParameterName(`value`: Output<String>) {
        this.idpRelayStateParameterName = value
    }

    /**
     * @param value A descriptive name for the Amazon EMR Studio.
     */
    @JvmName("eotwfujobjpwwbyd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
     */
    @JvmName("xrfpyhxmvcksitly")
    public suspend fun serviceRole(`value`: Output<String>) {
        this.serviceRole = value
    }

    /**
     * @param value A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     */
    @JvmName("jeyqadlgaeotkjvc")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("eiflskefjitcdimk")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     */
    @JvmName("nejrnccbktpayaay")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dpugbytvuuquyvsx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
     */
    @JvmName("aegpprtbcbcbuftx")
    public suspend fun userRole(`value`: Output<String>) {
        this.userRole = value
    }

    /**
     * @param value The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     */
    @JvmName("knrqwmlavodqnfrl")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
     * The following arguments are optional:
     */
    @JvmName("qeoyhgcofqwiioei")
    public suspend fun workspaceSecurityGroupId(`value`: Output<String>) {
        this.workspaceSecurityGroupId = value
    }

    /**
     * @param value Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO. Valid values are `SSO` or `IAM`.
     */
    @JvmName("lqkhexifjaehhctw")
    public suspend fun authMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authMode = mapped
    }

    /**
     * @param value The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    @JvmName("jomnvxfqwjunqiut")
    public suspend fun defaultS3Location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultS3Location = mapped
    }

    /**
     * @param value A detailed description of the Amazon EMR Studio.
     */
    @JvmName("agggvnfsufrlqvcs")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the Amazon EMR Studio Engine security group. The Engine security group allows inbound network traffic from the Workspace security group, and it must be in the same VPC specified by `vpc_id`.
     */
    @JvmName("pxouqfvopgfgpqpe")
    public suspend fun engineSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineSecurityGroupId = mapped
    }

    /**
     * @param value The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     */
    @JvmName("pkjxyienukhjbyws")
    public suspend fun idpAuthUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idpAuthUrl = mapped
    }

    /**
     * @param value The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
     */
    @JvmName("rvlhagsrjpxfoung")
    public suspend fun idpRelayStateParameterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idpRelayStateParameterName = mapped
    }

    /**
     * @param value A descriptive name for the Amazon EMR Studio.
     */
    @JvmName("oayorusnnkuksvft")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IAM role that the Amazon EMR Studio assumes. The service role provides a way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
     */
    @JvmName("kbuuwvprhjyhxblx")
    public suspend fun serviceRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRole = mapped
    }

    /**
     * @param value A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     */
    @JvmName("xwnhqkdthliednvc")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC specified by `vpc_id`. Studio users can create a Workspace in any of the specified subnets.
     */
    @JvmName("ghjglkvloyogppde")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bgfhjlcicxnwhgtd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values list of tags to apply to the EMR Cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qmeadwcgdobafdnu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a User Role when you use Amazon Web Services SSO authentication. The permissions attached to the User Role can be scoped down for each user or group using session policies.
     */
    @JvmName("mtlkbemooyyhglit")
    public suspend fun userRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userRole = mapped
    }

    /**
     * @param value The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the Studio.
     */
    @JvmName("icncxkotugxqliuk")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the Amazon EMR Studio Workspace security group. The Workspace security group allows outbound network traffic to resources in the Engine security group, and it must be in the same VPC specified by `vpc_id`.
     * The following arguments are optional:
     */
    @JvmName("hswknxhmhcxwvjps")
    public suspend fun workspaceSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceSecurityGroupId = mapped
    }

    internal fun build(): StudioArgs = StudioArgs(
        authMode = authMode,
        defaultS3Location = defaultS3Location,
        description = description,
        engineSecurityGroupId = engineSecurityGroupId,
        idpAuthUrl = idpAuthUrl,
        idpRelayStateParameterName = idpRelayStateParameterName,
        name = name,
        serviceRole = serviceRole,
        subnetIds = subnetIds,
        tags = tags,
        userRole = userRole,
        vpcId = vpcId,
        workspaceSecurityGroupId = workspaceSecurityGroupId,
    )
}
