@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [StudioSessionMapping].
 */
@PulumiTagMarker
public class StudioSessionMappingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StudioSessionMappingArgs = StudioSessionMappingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StudioSessionMappingArgsBuilder.() -> Unit) {
        val builder = StudioSessionMappingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StudioSessionMapping {
        val builtJavaResource = com.pulumi.aws.emr.StudioSessionMapping(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StudioSessionMapping(builtJavaResource)
    }
}

/**
 * Provides an Elastic MapReduce Studio Session Mapping.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.emr.StudioSessionMapping("example", {
 *     studioId: exampleAwsEmrStudio.id,
 *     identityType: "USER",
 *     identityId: "example",
 *     sessionPolicyArn: exampleAwsIamPolicy.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.emr.StudioSessionMapping("example",
 *     studio_id=example_aws_emr_studio["id"],
 *     identity_type="USER",
 *     identity_id="example",
 *     session_policy_arn=example_aws_iam_policy["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Emr.StudioSessionMapping("example", new()
 *     {
 *         StudioId = exampleAwsEmrStudio.Id,
 *         IdentityType = "USER",
 *         IdentityId = "example",
 *         SessionPolicyArn = exampleAwsIamPolicy.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/emr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := emr.NewStudioSessionMapping(ctx, "example", &emr.StudioSessionMappingArgs{
 * 			StudioId:         pulumi.Any(exampleAwsEmrStudio.Id),
 * 			IdentityType:     pulumi.String("USER"),
 * 			IdentityId:       pulumi.String("example"),
 * 			SessionPolicyArn: pulumi.Any(exampleAwsIamPolicy.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.emr.StudioSessionMapping;
 * import com.pulumi.aws.emr.StudioSessionMappingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StudioSessionMapping("example", StudioSessionMappingArgs.builder()
 *             .studioId(exampleAwsEmrStudio.id())
 *             .identityType("USER")
 *             .identityId("example")
 *             .sessionPolicyArn(exampleAwsIamPolicy.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:emr:StudioSessionMapping
 *     properties:
 *       studioId: ${exampleAwsEmrStudio.id}
 *       identityType: USER
 *       identityId: example
 *       sessionPolicyArn: ${exampleAwsIamPolicy.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EMR studio session mappings using `studio-id:identity-type:identity-id`. For example:
 * ```sh
 * $ pulumi import aws:emr/studioSessionMapping:StudioSessionMapping example es-xxxxx:USER:xxxxx-xxx-xxx
 * ```
 */
public class StudioSessionMapping internal constructor(
    override val javaResource: com.pulumi.aws.emr.StudioSessionMapping,
) : KotlinCustomResource(javaResource, StudioSessionMappingMapper) {
    /**
     * The globally unique identifier (GUID) of the user or group from the Amazon Web Services SSO Identity Store.
     */
    public val identityId: Output<String>
        get() = javaResource.identityId().applyValue({ args0 -> args0 })

    /**
     * The name of the user or group from the Amazon Web Services SSO Identity Store.
     */
    public val identityName: Output<String>
        get() = javaResource.identityName().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the identity to map to the Amazon EMR Studio is a `USER` or a `GROUP`.
     */
    public val identityType: Output<String>
        get() = javaResource.identityType().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the session policy that will be applied to the user or group. You should specify the ARN for the session policy that you want to apply, not the ARN of your user role.
     */
    public val sessionPolicyArn: Output<String>
        get() = javaResource.sessionPolicyArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the Amazon EMR Studio to which the user or group will be mapped.
     */
    public val studioId: Output<String>
        get() = javaResource.studioId().applyValue({ args0 -> args0 })
}

public object StudioSessionMappingMapper : ResourceMapper<StudioSessionMapping> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.emr.StudioSessionMapping::class == javaResource::class

    override fun map(javaResource: Resource): StudioSessionMapping = StudioSessionMapping(
        javaResource
            as com.pulumi.aws.emr.StudioSessionMapping,
    )
}

/**
 * @see [StudioSessionMapping].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StudioSessionMapping].
 */
public suspend fun studioSessionMapping(
    name: String,
    block: suspend StudioSessionMappingResourceBuilder.() -> Unit,
): StudioSessionMapping {
    val builder = StudioSessionMappingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StudioSessionMapping].
 * @param name The _unique_ name of the resulting resource.
 */
public fun studioSessionMapping(name: String): StudioSessionMapping {
    val builder = StudioSessionMappingResourceBuilder()
    builder.name(name)
    return builder.build()
}
