@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxRange The final port in the range of TCP ports.
 * @property minRange The first port in the range of TCP ports.
 */
public data class BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs(
    public val maxRange: Output<Int>,
    public val minRange: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs =
        com.pulumi.aws.emr.inputs.BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs.builder()
            .maxRange(maxRange.applyValue({ args0 -> args0 }))
            .minRange(minRange.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs].
 */
@PulumiTagMarker
public class BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgsBuilder internal constructor() {
    private var maxRange: Output<Int>? = null

    private var minRange: Output<Int>? = null

    /**
     * @param value The final port in the range of TCP ports.
     */
    @JvmName("micwbctsbwdfsamn")
    public suspend fun maxRange(`value`: Output<Int>) {
        this.maxRange = value
    }

    /**
     * @param value The first port in the range of TCP ports.
     */
    @JvmName("bfnlfqorwdxdcpps")
    public suspend fun minRange(`value`: Output<Int>) {
        this.minRange = value
    }

    /**
     * @param value The final port in the range of TCP ports.
     */
    @JvmName("wcovmvrwdepmwtsp")
    public suspend fun maxRange(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRange = mapped
    }

    /**
     * @param value The first port in the range of TCP ports.
     */
    @JvmName("xymgdbrdympdbjcj")
    public suspend fun minRange(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minRange = mapped
    }

    internal fun build(): BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs =
        BlockPublicAccessConfigurationPermittedPublicSecurityGroupRuleRangeArgs(
            maxRange = maxRange ?: throw PulumiNullFieldException("maxRange"),
            minRange = minRange ?: throw PulumiNullFieldException("minRange"),
        )
}
