@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property id ID of the cluster.
 * @property instanceTypeConfigs Configuration block for instance fleet.
 * @property launchSpecifications Configuration block for launch specification.
 * @property name Friendly name given to the instance fleet.
 * @property provisionedOnDemandCapacity
 * @property provisionedSpotCapacity
 * @property targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
 * @property targetSpotCapacity Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
 */
public data class ClusterCoreInstanceFleetArgs(
    public val id: Output<String>? = null,
    public val instanceTypeConfigs: Output<List<ClusterCoreInstanceFleetInstanceTypeConfigArgs>>? =
        null,
    public val launchSpecifications: Output<ClusterCoreInstanceFleetLaunchSpecificationsArgs>? = null,
    public val name: Output<String>? = null,
    public val provisionedOnDemandCapacity: Output<Int>? = null,
    public val provisionedSpotCapacity: Output<Int>? = null,
    public val targetOnDemandCapacity: Output<Int>? = null,
    public val targetSpotCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetArgs =
        com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .instanceTypeConfigs(
                instanceTypeConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchSpecifications(
                launchSpecifications?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .provisionedOnDemandCapacity(provisionedOnDemandCapacity?.applyValue({ args0 -> args0 }))
            .provisionedSpotCapacity(provisionedSpotCapacity?.applyValue({ args0 -> args0 }))
            .targetOnDemandCapacity(targetOnDemandCapacity?.applyValue({ args0 -> args0 }))
            .targetSpotCapacity(targetSpotCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterCoreInstanceFleetArgs].
 */
@PulumiTagMarker
public class ClusterCoreInstanceFleetArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var instanceTypeConfigs: Output<List<ClusterCoreInstanceFleetInstanceTypeConfigArgs>>? =
        null

    private var launchSpecifications: Output<ClusterCoreInstanceFleetLaunchSpecificationsArgs>? = null

    private var name: Output<String>? = null

    private var provisionedOnDemandCapacity: Output<Int>? = null

    private var provisionedSpotCapacity: Output<Int>? = null

    private var targetOnDemandCapacity: Output<Int>? = null

    private var targetSpotCapacity: Output<Int>? = null

    /**
     * @param value ID of the cluster.
     */
    @JvmName("sikawwcsgwproebf")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Configuration block for instance fleet.
     */
    @JvmName("pnkecjogopgywxys")
    public suspend fun instanceTypeConfigs(`value`: Output<List<ClusterCoreInstanceFleetInstanceTypeConfigArgs>>) {
        this.instanceTypeConfigs = value
    }

    @JvmName("uhagmdusmgkorace")
    public suspend fun instanceTypeConfigs(vararg values: Output<ClusterCoreInstanceFleetInstanceTypeConfigArgs>) {
        this.instanceTypeConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for instance fleet.
     */
    @JvmName("soqyuwfifgsujbso")
    public suspend fun instanceTypeConfigs(values: List<Output<ClusterCoreInstanceFleetInstanceTypeConfigArgs>>) {
        this.instanceTypeConfigs = Output.all(values)
    }

    /**
     * @param value Configuration block for launch specification.
     */
    @JvmName("qiisxajpxfryyjsf")
    public suspend fun launchSpecifications(`value`: Output<ClusterCoreInstanceFleetLaunchSpecificationsArgs>) {
        this.launchSpecifications = value
    }

    /**
     * @param value Friendly name given to the instance fleet.
     */
    @JvmName("ihwhowlbwjlrdogc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("gcojpvctbyyhjhgl")
    public suspend fun provisionedOnDemandCapacity(`value`: Output<Int>) {
        this.provisionedOnDemandCapacity = value
    }

    /**
     * @param value
     */
    @JvmName("blfhmgptgpcrsqhm")
    public suspend fun provisionedSpotCapacity(`value`: Output<Int>) {
        this.provisionedSpotCapacity = value
    }

    /**
     * @param value The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @JvmName("nbkmcjnbwhnkimjo")
    public suspend fun targetOnDemandCapacity(`value`: Output<Int>) {
        this.targetOnDemandCapacity = value
    }

    /**
     * @param value Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @JvmName("mvqsaeuhintmypmg")
    public suspend fun targetSpotCapacity(`value`: Output<Int>) {
        this.targetSpotCapacity = value
    }

    /**
     * @param value ID of the cluster.
     */
    @JvmName("sgphqsefsymdvaeb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Configuration block for instance fleet.
     */
    @JvmName("jdiooqkwtnttuhto")
    public suspend fun instanceTypeConfigs(`value`: List<ClusterCoreInstanceFleetInstanceTypeConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet.
     */
    @JvmName("bnsopppdieatrahc")
    public suspend fun instanceTypeConfigs(argument: List<suspend ClusterCoreInstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetInstanceTypeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet.
     */
    @JvmName("hnivbxkfijsntdpl")
    public suspend fun instanceTypeConfigs(vararg argument: suspend ClusterCoreInstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetInstanceTypeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet.
     */
    @JvmName("yyldjufvolgjginu")
    public suspend fun instanceTypeConfigs(argument: suspend ClusterCoreInstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterCoreInstanceFleetInstanceTypeConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param values Configuration block for instance fleet.
     */
    @JvmName("vavkggajtgigmxcp")
    public suspend fun instanceTypeConfigs(vararg values: ClusterCoreInstanceFleetInstanceTypeConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param value Configuration block for launch specification.
     */
    @JvmName("vgpsetjgqlcpeukx")
    public suspend fun launchSpecifications(`value`: ClusterCoreInstanceFleetLaunchSpecificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchSpecifications = mapped
    }

    /**
     * @param argument Configuration block for launch specification.
     */
    @JvmName("ctbuepansxnmjvji")
    public suspend fun launchSpecifications(argument: suspend ClusterCoreInstanceFleetLaunchSpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterCoreInstanceFleetLaunchSpecificationsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.launchSpecifications = mapped
    }

    /**
     * @param value Friendly name given to the instance fleet.
     */
    @JvmName("njmrpoqwlucqgjyg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("brcnobionobyakxa")
    public suspend fun provisionedOnDemandCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedOnDemandCapacity = mapped
    }

    /**
     * @param value
     */
    @JvmName("gpxuyaoruumsmpci")
    public suspend fun provisionedSpotCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedSpotCapacity = mapped
    }

    /**
     * @param value The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @JvmName("opvvxoulcbhjfoww")
    public suspend fun targetOnDemandCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOnDemandCapacity = mapped
    }

    /**
     * @param value Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @JvmName("skhyflieudbfixmf")
    public suspend fun targetSpotCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSpotCapacity = mapped
    }

    internal fun build(): ClusterCoreInstanceFleetArgs = ClusterCoreInstanceFleetArgs(
        id = id,
        instanceTypeConfigs = instanceTypeConfigs,
        launchSpecifications = launchSpecifications,
        name = name,
        provisionedOnDemandCapacity = provisionedOnDemandCapacity,
        provisionedSpotCapacity = provisionedSpotCapacity,
        targetOnDemandCapacity = targetOnDemandCapacity,
        targetSpotCapacity = targetSpotCapacity,
    )
}
