@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bidPrice Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
 * @property bidPriceAsPercentageOfOnDemandPrice Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
 * @property configurations Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
 * @property ebsConfigs Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
 * @property instanceType EC2 instance type, such as m4.xlarge.
 * @property weightedCapacity Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
 */
public data class ClusterCoreInstanceFleetInstanceTypeConfigArgs(
    public val bidPrice: Output<String>? = null,
    public val bidPriceAsPercentageOfOnDemandPrice: Output<Double>? = null,
    public val configurations: Output<List<ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs>>? = null,
    public val ebsConfigs: Output<List<ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs>>? =
        null,
    public val instanceType: Output<String>,
    public val weightedCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigArgs =
        com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigArgs.builder()
            .bidPrice(bidPrice?.applyValue({ args0 -> args0 }))
            .bidPriceAsPercentageOfOnDemandPrice(
                bidPriceAsPercentageOfOnDemandPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .configurations(
                configurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ebsConfigs(
                ebsConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterCoreInstanceFleetInstanceTypeConfigArgs].
 */
@PulumiTagMarker
public class ClusterCoreInstanceFleetInstanceTypeConfigArgsBuilder internal constructor() {
    private var bidPrice: Output<String>? = null

    private var bidPriceAsPercentageOfOnDemandPrice: Output<Double>? = null

    private var configurations:
        Output<List<ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs>>? = null

    private var ebsConfigs: Output<List<ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs>>? =
        null

    private var instanceType: Output<String>? = null

    private var weightedCapacity: Output<Int>? = null

    /**
     * @param value Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("okdpqbujklqqhocn")
    public suspend fun bidPrice(`value`: Output<String>) {
        this.bidPrice = value
    }

    /**
     * @param value Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("rnrxoutggptrjbof")
    public suspend fun bidPriceAsPercentageOfOnDemandPrice(`value`: Output<Double>) {
        this.bidPriceAsPercentageOfOnDemandPrice = value
    }

    /**
     * @param value Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("nvoevphyrrmkgcpw")
    public suspend fun configurations(`value`: Output<List<ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("rxqqtdagpsqmurbt")
    public suspend fun configurations(vararg values: Output<ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("fulevipwekdqvcii")
    public suspend fun configurations(values: List<Output<ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("ebryhcnushpqnigf")
    public suspend fun ebsConfigs(`value`: Output<List<ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs>>) {
        this.ebsConfigs = value
    }

    @JvmName("gfttcsgadatbbvpf")
    public suspend fun ebsConfigs(vararg values: Output<ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs>) {
        this.ebsConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("lrudttikxrdackqj")
    public suspend fun ebsConfigs(values: List<Output<ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs>>) {
        this.ebsConfigs = Output.all(values)
    }

    /**
     * @param value EC2 instance type, such as m4.xlarge.
     */
    @JvmName("hxmjxavrpnapvgan")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
     */
    @JvmName("amapcjstfbkhvjad")
    public suspend fun weightedCapacity(`value`: Output<Int>) {
        this.weightedCapacity = value
    }

    /**
     * @param value Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("iuxeouapnpmlhvfy")
    public suspend fun bidPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPrice = mapped
    }

    /**
     * @param value Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("xueiapseiiiepqss")
    public suspend fun bidPriceAsPercentageOfOnDemandPrice(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPriceAsPercentageOfOnDemandPrice = mapped
    }

    /**
     * @param value Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("fwrlpjuycpaokxin")
    public suspend fun configurations(`value`: List<ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("vfacqtjnqtcuwqsd")
    public suspend fun configurations(argument: List<suspend ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("sygmwegbdvmcuywi")
    public suspend fun configurations(vararg argument: suspend ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("xjrpnejvduuikhnd")
    public suspend fun configurations(argument: suspend ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("okyxwfnrxabmibud")
    public suspend fun configurations(vararg values: ClusterCoreInstanceFleetInstanceTypeConfigConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("vwkoloyjlbdesdbo")
    public suspend fun ebsConfigs(`value`: List<ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("xmwttwashqkjahws")
    public suspend fun ebsConfigs(argument: List<suspend ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("uqlpvbniksibocle")
    public suspend fun ebsConfigs(vararg argument: suspend ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("jibqrjhflufnkflm")
    public suspend fun ebsConfigs(argument: suspend ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("rqkxbpmrachaechl")
    public suspend fun ebsConfigs(vararg values: ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param value EC2 instance type, such as m4.xlarge.
     */
    @JvmName("edxgrfsycrntnres")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
     */
    @JvmName("pxoeqfxbonykthvv")
    public suspend fun weightedCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): ClusterCoreInstanceFleetInstanceTypeConfigArgs =
        ClusterCoreInstanceFleetInstanceTypeConfigArgs(
            bidPrice = bidPrice,
            bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice,
            configurations = configurations,
            ebsConfigs = ebsConfigs,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            weightedCapacity = weightedCapacity,
        )
}
