@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property iops Number of I/O operations per second (IOPS) that the volume supports.
 * @property size Volume size, in gibibytes (GiB).
 * @property type Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
 * @property volumesPerInstance Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
 */
public data class ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs(
    public val iops: Output<Int>? = null,
    public val size: Output<Int>,
    public val type: Output<String>,
    public val volumesPerInstance: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs =
        com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs.builder()
            .iops(iops?.applyValue({ args0 -> args0 }))
            .size(size.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .volumesPerInstance(volumesPerInstance?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs].
 */
@PulumiTagMarker
public class ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder internal constructor() {
    private var iops: Output<Int>? = null

    private var size: Output<Int>? = null

    private var type: Output<String>? = null

    private var volumesPerInstance: Output<Int>? = null

    /**
     * @param value Number of I/O operations per second (IOPS) that the volume supports.
     */
    @JvmName("sdsoqumpwyunwcfe")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value Volume size, in gibibytes (GiB).
     */
    @JvmName("lcxitldjyycvaxit")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
     */
    @JvmName("nmklypvishborxcu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
     */
    @JvmName("nfoexbubkorqeqem")
    public suspend fun volumesPerInstance(`value`: Output<Int>) {
        this.volumesPerInstance = value
    }

    /**
     * @param value Number of I/O operations per second (IOPS) that the volume supports.
     */
    @JvmName("uledqdyoiacmltdl")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Volume size, in gibibytes (GiB).
     */
    @JvmName("lrfnonpxgdrwprlf")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Volume type. Valid options are `gp3`, `gp2`, `io1`, `standard`, `st1` and `sc1`. See [EBS Volume Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
     */
    @JvmName("mtkeugbtbucruhid")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Number of EBS volumes with this configuration to attach to each EC2 instance in the instance group (default is 1).
     */
    @JvmName("mxqvyrqupswlrifv")
    public suspend fun volumesPerInstance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumesPerInstance = mapped
    }

    internal fun build(): ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs =
        ClusterCoreInstanceFleetInstanceTypeConfigEbsConfigArgs(
            iops = iops,
            size = size ?: throw PulumiNullFieldException("size"),
            type = type ?: throw PulumiNullFieldException("type"),
            volumesPerInstance = volumesPerInstance,
        )
}
