@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allocationStrategy Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is `lowest-price` (the default), which launches the lowest price first.
 */
public data class ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs(
    public val allocationStrategy: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs =
        com.pulumi.aws.emr.inputs.ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs.builder()
            .allocationStrategy(allocationStrategy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs].
 */
@PulumiTagMarker
public class ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgsBuilder internal constructor() {
    private var allocationStrategy: Output<String>? = null

    /**
     * @param value Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is `lowest-price` (the default), which launches the lowest price first.
     */
    @JvmName("cjrsvlmbyelkpehe")
    public suspend fun allocationStrategy(`value`: Output<String>) {
        this.allocationStrategy = value
    }

    /**
     * @param value Specifies the strategy to use in launching On-Demand instance fleets. Currently, the only option is `lowest-price` (the default), which launches the lowest price first.
     */
    @JvmName("oykxdbdqbfvjnvls")
    public suspend fun allocationStrategy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allocationStrategy = mapped
    }

    internal fun build(): ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs =
        ClusterCoreInstanceFleetLaunchSpecificationsOnDemandSpecificationArgs(
            allocationStrategy = allocationStrategy ?: throw PulumiNullFieldException("allocationStrategy"),
        )
}
