@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property autoscalingPolicy String containing the [EMR Auto Scaling Policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html) JSON.
 * @property bidPrice Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
 * @property ebsConfigs Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
 * @property id Core node type Instance Group ID, if using Instance Group for this node type.
 * @property instanceCount Target number of instances for the instance group. Must be at least 1. Defaults to 1.
 * @property instanceType EC2 instance type for all instances in the instance group.
 * @property name Friendly name given to the instance group.
 */
public data class ClusterCoreInstanceGroupArgs(
    public val autoscalingPolicy: Output<String>? = null,
    public val bidPrice: Output<String>? = null,
    public val ebsConfigs: Output<List<ClusterCoreInstanceGroupEbsConfigArgs>>? = null,
    public val id: Output<String>? = null,
    public val instanceCount: Output<Int>? = null,
    public val instanceType: Output<String>,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs =
        com.pulumi.aws.emr.inputs.ClusterCoreInstanceGroupArgs.builder()
            .autoscalingPolicy(autoscalingPolicy?.applyValue({ args0 -> args0 }))
            .bidPrice(bidPrice?.applyValue({ args0 -> args0 }))
            .ebsConfigs(
                ebsConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterCoreInstanceGroupArgs].
 */
@PulumiTagMarker
public class ClusterCoreInstanceGroupArgsBuilder internal constructor() {
    private var autoscalingPolicy: Output<String>? = null

    private var bidPrice: Output<String>? = null

    private var ebsConfigs: Output<List<ClusterCoreInstanceGroupEbsConfigArgs>>? = null

    private var id: Output<String>? = null

    private var instanceCount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value String containing the [EMR Auto Scaling Policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html) JSON.
     */
    @JvmName("rylhxxlsjgsgkuef")
    public suspend fun autoscalingPolicy(`value`: Output<String>) {
        this.autoscalingPolicy = value
    }

    /**
     * @param value Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
     */
    @JvmName("cyedlfevqahaorau")
    public suspend fun bidPrice(`value`: Output<String>) {
        this.bidPrice = value
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("jssggkyxlqqxeavc")
    public suspend fun ebsConfigs(`value`: Output<List<ClusterCoreInstanceGroupEbsConfigArgs>>) {
        this.ebsConfigs = value
    }

    @JvmName("oochdxlwyffbkpva")
    public suspend fun ebsConfigs(vararg values: Output<ClusterCoreInstanceGroupEbsConfigArgs>) {
        this.ebsConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("yphpotrexrmdknys")
    public suspend fun ebsConfigs(values: List<Output<ClusterCoreInstanceGroupEbsConfigArgs>>) {
        this.ebsConfigs = Output.all(values)
    }

    /**
     * @param value Core node type Instance Group ID, if using Instance Group for this node type.
     */
    @JvmName("yjfcomjtwnpljjwv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Target number of instances for the instance group. Must be at least 1. Defaults to 1.
     */
    @JvmName("pvbiuqvaswidvobs")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value EC2 instance type for all instances in the instance group.
     */
    @JvmName("slykovvxftmwdrgp")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Friendly name given to the instance group.
     */
    @JvmName("tgojrkigkyqylnfk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value String containing the [EMR Auto Scaling Policy](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-automatic-scaling.html) JSON.
     */
    @JvmName("hjbldgbllxcwvaqh")
    public suspend fun autoscalingPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingPolicy = mapped
    }

    /**
     * @param value Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
     */
    @JvmName("tvniphtkvpdxvfwn")
    public suspend fun bidPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPrice = mapped
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("flbftdbrqgvjogjo")
    public suspend fun ebsConfigs(`value`: List<ClusterCoreInstanceGroupEbsConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("nwlpdrlgmodndgxt")
    public suspend fun ebsConfigs(argument: List<suspend ClusterCoreInstanceGroupEbsConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceGroupEbsConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("hqvaerfmllghcgat")
    public suspend fun ebsConfigs(vararg argument: suspend ClusterCoreInstanceGroupEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterCoreInstanceGroupEbsConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("bvoyeivddomwpjgo")
    public suspend fun ebsConfigs(argument: suspend ClusterCoreInstanceGroupEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterCoreInstanceGroupEbsConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("lucswbacunwebmkc")
    public suspend fun ebsConfigs(vararg values: ClusterCoreInstanceGroupEbsConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param value Core node type Instance Group ID, if using Instance Group for this node type.
     */
    @JvmName("omapnxvsinywybex")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Target number of instances for the instance group. Must be at least 1. Defaults to 1.
     */
    @JvmName("gxnsisofbityxdro")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value EC2 instance type for all instances in the instance group.
     */
    @JvmName("qqmtqptbpnvtdmih")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Friendly name given to the instance group.
     */
    @JvmName("xkswnlotnoyxfbbx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ClusterCoreInstanceGroupArgs = ClusterCoreInstanceGroupArgs(
        autoscalingPolicy = autoscalingPolicy,
        bidPrice = bidPrice,
        ebsConfigs = ebsConfigs,
        id = id,
        instanceCount = instanceCount,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        name = name,
    )
}
