@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterEc2AttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property additionalMasterSecurityGroups String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
 * @property additionalSlaveSecurityGroups String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
 * @property emrManagedMasterSecurityGroup Identifier of the Amazon EC2 EMR-Managed security group for the master node.
 * @property emrManagedSlaveSecurityGroup Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
 * @property instanceProfile Instance Profile for EC2 instances of the cluster assume this role.
 * @property keyName Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
 * @property serviceAccessSecurityGroup Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
 * @property subnetId VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
 * @property subnetIds List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
 * > **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
 */
public data class ClusterEc2AttributesArgs(
    public val additionalMasterSecurityGroups: Output<String>? = null,
    public val additionalSlaveSecurityGroups: Output<String>? = null,
    public val emrManagedMasterSecurityGroup: Output<String>? = null,
    public val emrManagedSlaveSecurityGroup: Output<String>? = null,
    public val instanceProfile: Output<String>,
    public val keyName: Output<String>? = null,
    public val serviceAccessSecurityGroup: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterEc2AttributesArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterEc2AttributesArgs =
        com.pulumi.aws.emr.inputs.ClusterEc2AttributesArgs.builder()
            .additionalMasterSecurityGroups(additionalMasterSecurityGroups?.applyValue({ args0 -> args0 }))
            .additionalSlaveSecurityGroups(additionalSlaveSecurityGroups?.applyValue({ args0 -> args0 }))
            .emrManagedMasterSecurityGroup(emrManagedMasterSecurityGroup?.applyValue({ args0 -> args0 }))
            .emrManagedSlaveSecurityGroup(emrManagedSlaveSecurityGroup?.applyValue({ args0 -> args0 }))
            .instanceProfile(instanceProfile.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .serviceAccessSecurityGroup(serviceAccessSecurityGroup?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ClusterEc2AttributesArgs].
 */
@PulumiTagMarker
public class ClusterEc2AttributesArgsBuilder internal constructor() {
    private var additionalMasterSecurityGroups: Output<String>? = null

    private var additionalSlaveSecurityGroups: Output<String>? = null

    private var emrManagedMasterSecurityGroup: Output<String>? = null

    private var emrManagedSlaveSecurityGroup: Output<String>? = null

    private var instanceProfile: Output<String>? = null

    private var keyName: Output<String>? = null

    private var serviceAccessSecurityGroup: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
     */
    @JvmName("kuawybgvumxowhfu")
    public suspend fun additionalMasterSecurityGroups(`value`: Output<String>) {
        this.additionalMasterSecurityGroups = value
    }

    /**
     * @param value String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
     */
    @JvmName("ycgtjccopprcmnqn")
    public suspend fun additionalSlaveSecurityGroups(`value`: Output<String>) {
        this.additionalSlaveSecurityGroups = value
    }

    /**
     * @param value Identifier of the Amazon EC2 EMR-Managed security group for the master node.
     */
    @JvmName("avphjpvdhmyniync")
    public suspend fun emrManagedMasterSecurityGroup(`value`: Output<String>) {
        this.emrManagedMasterSecurityGroup = value
    }

    /**
     * @param value Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
     */
    @JvmName("smkudeppovqtoyph")
    public suspend fun emrManagedSlaveSecurityGroup(`value`: Output<String>) {
        this.emrManagedSlaveSecurityGroup = value
    }

    /**
     * @param value Instance Profile for EC2 instances of the cluster assume this role.
     */
    @JvmName("psoyuejrnvofehpx")
    public suspend fun instanceProfile(`value`: Output<String>) {
        this.instanceProfile = value
    }

    /**
     * @param value Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
     */
    @JvmName("uraxkqtdalxdwfgt")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
     */
    @JvmName("rcbahsvhgacchwfs")
    public suspend fun serviceAccessSecurityGroup(`value`: Output<String>) {
        this.serviceAccessSecurityGroup = value
    }

    /**
     * @param value VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
     */
    @JvmName("ctpasmqcmafwygng")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
     * > **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
     */
    @JvmName("wkqqtxgpsiekpdvw")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("mrkpmgrjjasxqnaa")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
     * > **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
     */
    @JvmName("elfadbvsjxxxhcdb")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value String containing a comma separated list of additional Amazon EC2 security group IDs for the master node.
     */
    @JvmName("epxvwubcbkgmelra")
    public suspend fun additionalMasterSecurityGroups(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalMasterSecurityGroups = mapped
    }

    /**
     * @param value String containing a comma separated list of additional Amazon EC2 security group IDs for the slave nodes as a comma separated string.
     */
    @JvmName("prvcbgnarcjvmwqa")
    public suspend fun additionalSlaveSecurityGroups(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalSlaveSecurityGroups = mapped
    }

    /**
     * @param value Identifier of the Amazon EC2 EMR-Managed security group for the master node.
     */
    @JvmName("ymmdyjqqsdrijkkw")
    public suspend fun emrManagedMasterSecurityGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emrManagedMasterSecurityGroup = mapped
    }

    /**
     * @param value Identifier of the Amazon EC2 EMR-Managed security group for the slave nodes.
     */
    @JvmName("rrrnrxwtkwlalqbt")
    public suspend fun emrManagedSlaveSecurityGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emrManagedSlaveSecurityGroup = mapped
    }

    /**
     * @param value Instance Profile for EC2 instances of the cluster assume this role.
     */
    @JvmName("asetyhpohfphbuho")
    public suspend fun instanceProfile(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceProfile = mapped
    }

    /**
     * @param value Amazon EC2 key pair that can be used to ssh to the master node as the user called `hadoop`.
     */
    @JvmName("vnnvescdcnctnrng")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value Identifier of the Amazon EC2 service-access security group - required when the cluster runs on a private subnet.
     */
    @JvmName("iegxhouwbikdavri")
    public suspend fun serviceAccessSecurityGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccessSecurityGroup = mapped
    }

    /**
     * @param value VPC subnet id where you want the job flow to launch. Cannot specify the `cc1.4xlarge` instance type for nodes of a job flow launched in an Amazon VPC.
     */
    @JvmName("plfpijhawbdelipp")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
     * > **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
     */
    @JvmName("nnvpwbpuhbixaggo")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of VPC subnet id-s where you want the job flow to launch.  Amazon EMR identifies the best Availability Zone to launch instances according to your fleet specifications.
     * > **NOTE on EMR-Managed security groups:** These security groups will have any missing inbound or outbound access rules added and maintained by AWS, to ensure proper communication between instances in a cluster. The EMR service will maintain these rules for groups provided in `emr_managed_master_security_group` and `emr_managed_slave_security_group`; attempts to remove the required rules may succeed, only for the EMR service to re-add them in a matter of minutes. This may cause this provider to fail to destroy an environment that contains an EMR cluster, because the EMR service does not revoke rules added on deletion, leaving a cyclic dependency between the security groups that prevents their deletion. To avoid this, use the `revoke_rules_on_delete` optional attribute for any Security Group used in `emr_managed_master_security_group` and `emr_managed_slave_security_group`. See [Amazon EMR-Managed Security Groups](http://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-man-sec-groups.html) for more information about the EMR-managed security group rules.
     */
    @JvmName("dldswejlhxohhlpe")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): ClusterEc2AttributesArgs = ClusterEc2AttributesArgs(
        additionalMasterSecurityGroups = additionalMasterSecurityGroups,
        additionalSlaveSecurityGroups = additionalSlaveSecurityGroups,
        emrManagedMasterSecurityGroup = emrManagedMasterSecurityGroup,
        emrManagedSlaveSecurityGroup = emrManagedSlaveSecurityGroup,
        instanceProfile = instanceProfile ?: throw PulumiNullFieldException("instanceProfile"),
        keyName = keyName,
        serviceAccessSecurityGroup = serviceAccessSecurityGroup,
        subnetId = subnetId,
        subnetIds = subnetIds,
    )
}
