@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property id ID of the cluster.
 * @property instanceTypeConfigs Configuration block for instance fleet.
 * @property launchSpecifications Configuration block for launch specification.
 * @property name Friendly name given to the instance fleet.
 * @property provisionedOnDemandCapacity
 * @property provisionedSpotCapacity
 * @property targetOnDemandCapacity Target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
 * @property targetSpotCapacity Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
 */
public data class ClusterMasterInstanceFleetArgs(
    public val id: Output<String>? = null,
    public val instanceTypeConfigs: Output<List<ClusterMasterInstanceFleetInstanceTypeConfigArgs>>? =
        null,
    public val launchSpecifications: Output<ClusterMasterInstanceFleetLaunchSpecificationsArgs>? =
        null,
    public val name: Output<String>? = null,
    public val provisionedOnDemandCapacity: Output<Int>? = null,
    public val provisionedSpotCapacity: Output<Int>? = null,
    public val targetOnDemandCapacity: Output<Int>? = null,
    public val targetSpotCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetArgs =
        com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .instanceTypeConfigs(
                instanceTypeConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchSpecifications(
                launchSpecifications?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .provisionedOnDemandCapacity(provisionedOnDemandCapacity?.applyValue({ args0 -> args0 }))
            .provisionedSpotCapacity(provisionedSpotCapacity?.applyValue({ args0 -> args0 }))
            .targetOnDemandCapacity(targetOnDemandCapacity?.applyValue({ args0 -> args0 }))
            .targetSpotCapacity(targetSpotCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterMasterInstanceFleetArgs].
 */
@PulumiTagMarker
public class ClusterMasterInstanceFleetArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var instanceTypeConfigs: Output<List<ClusterMasterInstanceFleetInstanceTypeConfigArgs>>? =
        null

    private var launchSpecifications: Output<ClusterMasterInstanceFleetLaunchSpecificationsArgs>? =
        null

    private var name: Output<String>? = null

    private var provisionedOnDemandCapacity: Output<Int>? = null

    private var provisionedSpotCapacity: Output<Int>? = null

    private var targetOnDemandCapacity: Output<Int>? = null

    private var targetSpotCapacity: Output<Int>? = null

    /**
     * @param value ID of the cluster.
     */
    @JvmName("xilwetfljfbrfnbx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Configuration block for instance fleet.
     */
    @JvmName("caysgpykxkxfgdmr")
    public suspend fun instanceTypeConfigs(`value`: Output<List<ClusterMasterInstanceFleetInstanceTypeConfigArgs>>) {
        this.instanceTypeConfigs = value
    }

    @JvmName("wghkwrahynejuwkf")
    public suspend fun instanceTypeConfigs(vararg values: Output<ClusterMasterInstanceFleetInstanceTypeConfigArgs>) {
        this.instanceTypeConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for instance fleet.
     */
    @JvmName("vhynpkbkvideeoxi")
    public suspend fun instanceTypeConfigs(values: List<Output<ClusterMasterInstanceFleetInstanceTypeConfigArgs>>) {
        this.instanceTypeConfigs = Output.all(values)
    }

    /**
     * @param value Configuration block for launch specification.
     */
    @JvmName("ymphwfpitgmwylxh")
    public suspend fun launchSpecifications(`value`: Output<ClusterMasterInstanceFleetLaunchSpecificationsArgs>) {
        this.launchSpecifications = value
    }

    /**
     * @param value Friendly name given to the instance fleet.
     */
    @JvmName("pdjvrwqmwrspebow")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("erhmwqpugejujsdr")
    public suspend fun provisionedOnDemandCapacity(`value`: Output<Int>) {
        this.provisionedOnDemandCapacity = value
    }

    /**
     * @param value
     */
    @JvmName("uvdwurkathcqnhcs")
    public suspend fun provisionedSpotCapacity(`value`: Output<Int>) {
        this.provisionedSpotCapacity = value
    }

    /**
     * @param value Target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @JvmName("dkodosoeuirkotnh")
    public suspend fun targetOnDemandCapacity(`value`: Output<Int>) {
        this.targetOnDemandCapacity = value
    }

    /**
     * @param value Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @JvmName("sddtejbqwojucpsh")
    public suspend fun targetSpotCapacity(`value`: Output<Int>) {
        this.targetSpotCapacity = value
    }

    /**
     * @param value ID of the cluster.
     */
    @JvmName("rirtlexsncmbhaac")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Configuration block for instance fleet.
     */
    @JvmName("wucsoqrlrlbnoymg")
    public suspend fun instanceTypeConfigs(`value`: List<ClusterMasterInstanceFleetInstanceTypeConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet.
     */
    @JvmName("ojoulvvfialyngdl")
    public suspend fun instanceTypeConfigs(argument: List<suspend ClusterMasterInstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetInstanceTypeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet.
     */
    @JvmName("pryqrmoyapxfjvas")
    public suspend fun instanceTypeConfigs(vararg argument: suspend ClusterMasterInstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetInstanceTypeConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param argument Configuration block for instance fleet.
     */
    @JvmName("hdsnhhehmlnuvjir")
    public suspend fun instanceTypeConfigs(argument: suspend ClusterMasterInstanceFleetInstanceTypeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterMasterInstanceFleetInstanceTypeConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param values Configuration block for instance fleet.
     */
    @JvmName("bvwotrkrifbqkdqp")
    public suspend fun instanceTypeConfigs(vararg values: ClusterMasterInstanceFleetInstanceTypeConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypeConfigs = mapped
    }

    /**
     * @param value Configuration block for launch specification.
     */
    @JvmName("tfxairoqgdqropme")
    public suspend fun launchSpecifications(`value`: ClusterMasterInstanceFleetLaunchSpecificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchSpecifications = mapped
    }

    /**
     * @param argument Configuration block for launch specification.
     */
    @JvmName("jrdgudbdcgriastj")
    public suspend fun launchSpecifications(argument: suspend ClusterMasterInstanceFleetLaunchSpecificationsArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterMasterInstanceFleetLaunchSpecificationsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.launchSpecifications = mapped
    }

    /**
     * @param value Friendly name given to the instance fleet.
     */
    @JvmName("haesqxnvdiowgpyx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("yidhddftguwsfqnq")
    public suspend fun provisionedOnDemandCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedOnDemandCapacity = mapped
    }

    /**
     * @param value
     */
    @JvmName("rfdxuqiaiixupihu")
    public suspend fun provisionedSpotCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedSpotCapacity = mapped
    }

    /**
     * @param value Target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     */
    @JvmName("uhbsreflpbvobuxk")
    public suspend fun targetOnDemandCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetOnDemandCapacity = mapped
    }

    /**
     * @param value Target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     */
    @JvmName("jlwfobyaxuhukvio")
    public suspend fun targetSpotCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSpotCapacity = mapped
    }

    internal fun build(): ClusterMasterInstanceFleetArgs = ClusterMasterInstanceFleetArgs(
        id = id,
        instanceTypeConfigs = instanceTypeConfigs,
        launchSpecifications = launchSpecifications,
        name = name,
        provisionedOnDemandCapacity = provisionedOnDemandCapacity,
        provisionedSpotCapacity = provisionedSpotCapacity,
        targetOnDemandCapacity = targetOnDemandCapacity,
        targetSpotCapacity = targetSpotCapacity,
    )
}
