@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetInstanceTypeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bidPrice Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
 * @property bidPriceAsPercentageOfOnDemandPrice Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
 * @property configurations Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
 * @property ebsConfigs Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
 * @property instanceType EC2 instance type, such as m4.xlarge.
 * @property weightedCapacity Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
 */
public data class ClusterMasterInstanceFleetInstanceTypeConfigArgs(
    public val bidPrice: Output<String>? = null,
    public val bidPriceAsPercentageOfOnDemandPrice: Output<Double>? = null,
    public val configurations: Output<List<ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs>>? = null,
    public val ebsConfigs: Output<List<ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs>>? =
        null,
    public val instanceType: Output<String>,
    public val weightedCapacity: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetInstanceTypeConfigArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetInstanceTypeConfigArgs = com.pulumi.aws.emr.inputs.ClusterMasterInstanceFleetInstanceTypeConfigArgs.builder()
        .bidPrice(bidPrice?.applyValue({ args0 -> args0 }))
        .bidPriceAsPercentageOfOnDemandPrice(
            bidPriceAsPercentageOfOnDemandPrice?.applyValue({ args0 ->
                args0
            }),
        )
        .configurations(
            configurations?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .ebsConfigs(
            ebsConfigs?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .instanceType(instanceType.applyValue({ args0 -> args0 }))
        .weightedCapacity(weightedCapacity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterMasterInstanceFleetInstanceTypeConfigArgs].
 */
@PulumiTagMarker
public class ClusterMasterInstanceFleetInstanceTypeConfigArgsBuilder internal constructor() {
    private var bidPrice: Output<String>? = null

    private var bidPriceAsPercentageOfOnDemandPrice: Output<Double>? = null

    private var configurations:
        Output<List<ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs>>? = null

    private var ebsConfigs: Output<List<ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs>>? =
        null

    private var instanceType: Output<String>? = null

    private var weightedCapacity: Output<Int>? = null

    /**
     * @param value Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("ldmutvxgwegvysix")
    public suspend fun bidPrice(`value`: Output<String>) {
        this.bidPrice = value
    }

    /**
     * @param value Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("evlhyjmahgjlfujj")
    public suspend fun bidPriceAsPercentageOfOnDemandPrice(`value`: Output<Double>) {
        this.bidPriceAsPercentageOfOnDemandPrice = value
    }

    /**
     * @param value Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("dfnntteudwcgridd")
    public suspend fun configurations(`value`: Output<List<ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs>>) {
        this.configurations = value
    }

    @JvmName("rrbnwynpemkqmgpv")
    public suspend fun configurations(vararg values: Output<ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs>) {
        this.configurations = Output.all(values.asList())
    }

    /**
     * @param values Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("jnabiomioikxrbkc")
    public suspend fun configurations(values: List<Output<ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs>>) {
        this.configurations = Output.all(values)
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("avkhmnkuitramcad")
    public suspend fun ebsConfigs(`value`: Output<List<ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs>>) {
        this.ebsConfigs = value
    }

    @JvmName("lmtumhdohetvyljb")
    public suspend fun ebsConfigs(vararg values: Output<ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs>) {
        this.ebsConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("yioqjtnqipqcgefc")
    public suspend fun ebsConfigs(values: List<Output<ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs>>) {
        this.ebsConfigs = Output.all(values)
    }

    /**
     * @param value EC2 instance type, such as m4.xlarge.
     */
    @JvmName("kyvagpslnhkmxcqn")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
     */
    @JvmName("ncawiayjylvsqebi")
    public suspend fun weightedCapacity(`value`: Output<Int>) {
        this.weightedCapacity = value
    }

    /**
     * @param value Bid price for each EC2 Spot instance type as defined by `instance_type`. Expressed in USD. If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("gxbsduwbvstlsewo")
    public suspend fun bidPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPrice = mapped
    }

    /**
     * @param value Bid price, as a percentage of On-Demand price, for each EC2 Spot instance as defined by `instance_type`. Expressed as a number (for example, 20 specifies 20%). If neither `bid_price` nor `bid_price_as_percentage_of_on_demand_price` is provided, `bid_price_as_percentage_of_on_demand_price` defaults to 100%.
     */
    @JvmName("jludwqmdrpqtcfao")
    public suspend fun bidPriceAsPercentageOfOnDemandPrice(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPriceAsPercentageOfOnDemandPrice = mapped
    }

    /**
     * @param value Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("whgtuqxvyyqgidjk")
    public suspend fun configurations(`value`: List<ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param argument Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("skykmcggylpjkmyg")
    public suspend fun configurations(argument: List<suspend ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("hfmonrvouhwbqqms")
    public suspend fun configurations(vararg argument: suspend ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param argument Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("apigsapphwtsbdrr")
    public suspend fun configurations(argument: suspend ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.configurations = mapped
    }

    /**
     * @param values Configuration classification that applies when provisioning cluster instances, which can include configurations for applications and software that run on the cluster. List of `configuration` blocks.
     */
    @JvmName("ncyhsncfqehhhjdm")
    public suspend fun configurations(vararg values: ClusterMasterInstanceFleetInstanceTypeConfigConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configurations = mapped
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("rxydhiqnaylpelpw")
    public suspend fun ebsConfigs(`value`: List<ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("xnqqxaptayhdaaiv")
    public suspend fun ebsConfigs(argument: List<suspend ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("rgksonktrviwkxqi")
    public suspend fun ebsConfigs(vararg argument: suspend ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("qacxfoendnpupacw")
    public suspend fun ebsConfigs(argument: suspend ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("kpiexvgtpasuxira")
    public suspend fun ebsConfigs(vararg values: ClusterMasterInstanceFleetInstanceTypeConfigEbsConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param value EC2 instance type, such as m4.xlarge.
     */
    @JvmName("tacjxnqjcofvbpxu")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Number of units that a provisioned instance of this type provides toward fulfilling the target capacities defined in `aws.emr.InstanceFleet`.
     */
    @JvmName("dstdbjnnuwfcrgos")
    public suspend fun weightedCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weightedCapacity = mapped
    }

    internal fun build(): ClusterMasterInstanceFleetInstanceTypeConfigArgs =
        ClusterMasterInstanceFleetInstanceTypeConfigArgs(
            bidPrice = bidPrice,
            bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice,
            configurations = configurations,
            ebsConfigs = ebsConfigs,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            weightedCapacity = weightedCapacity,
        )
}
