@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emr.kotlin.inputs

import com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bidPrice Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
 * @property ebsConfigs Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
 * @property id Master node type Instance Group ID, if using Instance Group for this node type.
 * @property instanceCount Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have map public IP on launch enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
 * @property instanceType EC2 instance type for all instances in the instance group.
 * @property name Friendly name given to the instance group.
 */
public data class ClusterMasterInstanceGroupArgs(
    public val bidPrice: Output<String>? = null,
    public val ebsConfigs: Output<List<ClusterMasterInstanceGroupEbsConfigArgs>>? = null,
    public val id: Output<String>? = null,
    public val instanceCount: Output<Int>? = null,
    public val instanceType: Output<String>,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs> {
    override fun toJava(): com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs =
        com.pulumi.aws.emr.inputs.ClusterMasterInstanceGroupArgs.builder()
            .bidPrice(bidPrice?.applyValue({ args0 -> args0 }))
            .ebsConfigs(
                ebsConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterMasterInstanceGroupArgs].
 */
@PulumiTagMarker
public class ClusterMasterInstanceGroupArgsBuilder internal constructor() {
    private var bidPrice: Output<String>? = null

    private var ebsConfigs: Output<List<ClusterMasterInstanceGroupEbsConfigArgs>>? = null

    private var id: Output<String>? = null

    private var instanceCount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
     */
    @JvmName("gfwyyutjfrwjupjk")
    public suspend fun bidPrice(`value`: Output<String>) {
        this.bidPrice = value
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("syyrxbuwqvkpyhsv")
    public suspend fun ebsConfigs(`value`: Output<List<ClusterMasterInstanceGroupEbsConfigArgs>>) {
        this.ebsConfigs = value
    }

    @JvmName("oghjnbefvymgjcwe")
    public suspend fun ebsConfigs(vararg values: Output<ClusterMasterInstanceGroupEbsConfigArgs>) {
        this.ebsConfigs = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("eevqkjoaynddudye")
    public suspend fun ebsConfigs(values: List<Output<ClusterMasterInstanceGroupEbsConfigArgs>>) {
        this.ebsConfigs = Output.all(values)
    }

    /**
     * @param value Master node type Instance Group ID, if using Instance Group for this node type.
     */
    @JvmName("gxucuvjteekvfasq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have map public IP on launch enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
     */
    @JvmName("quxahfuqdcebbcwm")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value EC2 instance type for all instances in the instance group.
     */
    @JvmName("sdgklwxpoaffijsk")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Friendly name given to the instance group.
     */
    @JvmName("efbgmbsegugnwisn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Bid price for each EC2 instance in the instance group, expressed in USD. By setting this attribute, the instance group is being declared as a Spot Instance, and will implicitly create a Spot request. Leave this blank to use On-Demand Instances.
     */
    @JvmName("cphpqbomwlpdifme")
    public suspend fun bidPrice(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bidPrice = mapped
    }

    /**
     * @param value Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("gkufqwjjacwuyydt")
    public suspend fun ebsConfigs(`value`: List<ClusterMasterInstanceGroupEbsConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("yqoebrpnhpldnska")
    public suspend fun ebsConfigs(argument: List<suspend ClusterMasterInstanceGroupEbsConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceGroupEbsConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("bdhesourbaunwyfr")
    public suspend fun ebsConfigs(vararg argument: suspend ClusterMasterInstanceGroupEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterMasterInstanceGroupEbsConfigArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param argument Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("uoergkxfriwkxkcg")
    public suspend fun ebsConfigs(argument: suspend ClusterMasterInstanceGroupEbsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterMasterInstanceGroupEbsConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ebsConfigs = mapped
    }

    /**
     * @param values Configuration block(s) for EBS volumes attached to each instance in the instance group. Detailed below.
     */
    @JvmName("ncqvqpvoxavmpclu")
    public suspend fun ebsConfigs(vararg values: ClusterMasterInstanceGroupEbsConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsConfigs = mapped
    }

    /**
     * @param value Master node type Instance Group ID, if using Instance Group for this node type.
     */
    @JvmName("aqyhwpnnxkpkkyyp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Target number of instances for the instance group. Must be 1 or 3. Defaults to 1. Launching with multiple master nodes is only supported in EMR version 5.23.0+, and requires this resource's `core_instance_group` to be configured. Public (Internet accessible) instances must be created in VPC subnets that have map public IP on launch enabled. Termination protection is automatically enabled when launched with multiple master nodes and this provider must have the `termination_protection = false` configuration applied before destroying this resource.
     */
    @JvmName("klxwtemkkcxkwsor")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value EC2 instance type for all instances in the instance group.
     */
    @JvmName("hgglsfcurciptcul")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Friendly name given to the instance group.
     */
    @JvmName("ftkkgjbubaoomwqn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ClusterMasterInstanceGroupArgs = ClusterMasterInstanceGroupArgs(
        bidPrice = bidPrice,
        ebsConfigs = ebsConfigs,
        id = id,
        instanceCount = instanceCount,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        name = name,
    )
}
